
<?php $__env->startSection('title'); ?>
Integrations List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard_page">
    <div class="card card-flush h-xl-100">
      <!--begin::Card header-->
      <div class="card-header pt-7">
        <!--begin::Title-->
        <h3 class="card-title align-items-start flex-column">
          <div class="d-flex align-items-center position-relative my-1">
            <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
            <span class="svg-icon svg-icon-1 position-absolute ms-4">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="black"></rect>
                <path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="black"></path>
              </svg>
            </span>
            <!--end::Svg Icon-->
            <input type="text" data-kt-ecommerce-seller-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Seller">
          </div>
        </h3>
        <div class="card-toolbar">
        	<a href="<?php echo e(route('add-seller')); ?>" class="btn btn-sm btn-primary pull-right">Add Integration</a>
        </div>
        <!--end::Title-->        
      </div>
      <!--end::Card header-->
      <!--begin::Card body-->
      <div class="card-body">
        <table class="table align-middle table-row-dashed fs-6 gy-3" id="seller_list_table">
            <thead class="fw-bolder text-muted">
              <tr>
                <td class="min-w-100px"></td>
                <td class="min-w-70px">Seller ID</td>
                <td class="min-w-150px">Seller Name</td>
                <td class="min-w-70px">Country</td>
                <td class="min-w-100px">Store Added On</td>
                <td class="min-w-100px">Status</td>
                <td class="min-w-100px">Payment Status</td>
                <td class="min-w-100px">Action</td>
              </tr>
            </thead>
            <tbody class="fw-bold fs-6">
              <!--begin::Table row-->
              <?php if(!empty($sellersData) && count($sellersData) > 0): ?>
                <?php $__currentLoopData = $sellersData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                      <img src="<?php echo e(@asset('assets/images/'.config('integrations.module_config')[$seller->marketplace_name]['sticker_img'])); ?>" height="30"/>
                    </td>
                    <td><?php echo e($seller->id); ?></td>
                    <td><a href="<?php echo e(@route('tlaccountdetails', array('seller_id' => App\Helpers\Helper::encryptor('encrypt',$seller->id)))); ?>"><?php echo e($seller->seller_name); ?></a></td>
                    <td><?php echo e($seller->country); ?></td>
                    <td><?php echo e(date('jS F Y',strtotime($seller->seller_created_at))); ?></td>
                    <td>
                      <?php if($seller->status == 'Active'): ?>
                        <span class="badge badge-light-success"><?php echo e($seller->status); ?></span>
                      <?php else: ?>
                        <span class="badge badge-light-danger"><?php echo e($seller->status); ?></span>
                      <?php endif; ?>
                    </td>
                    <td>
                      <?php if($seller->payment_status == 'Paid'): ?>
                        <span class="badge badge-light-success"><?php echo e($seller->payment_status); ?></span>
                      <?php else: ?>
                        <span class="badge badge-light-danger"><?php echo e($seller->payment_status); ?></span>
                      <?php endif; ?>
                    </td>
                    <td>
                        <a href="#" class="btn btn-sm btn-light btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions
                          <!--begin::Svg Icon | path: icons/duotune/arrows/arr072.svg-->
                          <span class="svg-icon svg-icon-5 m-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                              <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="black" />
                            </svg>
                          </span>
                          <!--end::Svg Icon-->
                        </a>              
                          <!--begin::Menu-->
                        <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold fs-7 w-125px py-4" data-kt-menu="true">
                            <div class="menu-item px-3">
                              <a href="<?php echo e(@route('tlsettings', array('seller_id' => App\Helpers\Helper::encryptor('encrypt',$seller->id)))); ?>" class="menu-link px-3"><i class="fas fa-cog" style="padding-right: 6px;"></i> Settigs</a>
                            </div>
                            <?php if($seller->payment_status == 'Paid'): ?>
                            <div class="menu-item px-3">
                              <a href="<?php echo e(@route('tlaccountdetails', array('seller_id' => App\Helpers\Helper::encryptor('encrypt',$seller->id)))); ?>" class="menu-link px-3"><i class="far fa-chart-bar" style="padding-right: 6px;"></i> Dashboard</a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
                <tr class="text-center">
                  <td colspan="7">
                    No Integration found.
                  </td>
                </tr>
              <?php endif; ?>
              <!--end::Table row-->                  
            </tbody>
          </table>
      </div>
      <!--end::Card body-->
    </div>
</div>  
<?php $__env->stopSection(); ?>
<?php $__env->startSection('more_scripts'); ?>
<script src="<?php echo e(asset('assets/js/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/custom/seller-list.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\ecomm2db\resources\views/master/sellers/index.blade.php ENDPATH**/ ?>