
<?php $__env->startSection('title'); ?>
  Select Tally Company
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="company_page">
   <div class="card" id="kt_conenct">
      <div class="card-body p-lg-10">
          <div class="d-flex flex-column">
              <div class="mb-5 text-center">
                  <h1 class="fw-bolder mb-5">Select your company for <?php echo e(@config('app.appModules')[$module]); ?></h1>
                  <div class="text-gray-400 fw-bold fs-5"></div>
              </div>
              <div class="row g-10">
                <div class="col-md-12 text-center connection-img">
                  <?php if($module == 'tlaz'): ?>
                      <img src="<?php echo e(asset('assets/images/az-tl-connection.png')); ?>" width="300">
                    <?php endif; ?>
                </div>
                
                <div class="col-md-12 fs-6">
                  <p>We have fetched your tally company list from your tally application. Please select the tally company which you wish to integrate with <?php echo e(@config('app.appModules')[$module]); ?> connection from below dropdown list.</p>
                  <p>Data will sync in the company which you have select from the below dropdown.</p>
                  <div class="row">
                    <div class="col-md-4">
                        <form id="from_update_company" name="from_update_company">
                            <select name="company_name" id="company_name" class="form-control">
                                <option value="">Select Company</option>
                                <?php $__currentLoopData = $companyList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ckey => $cval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($cval['guid'].','.$cval['name']); ?>"><?php echo e($cval['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </form>
                    </div>
                    <div class="col-md-4">
                      <button type="button" class="btn btn-info btn-sm" id="save-company">Update</button>
                    </div>
                  </div>
                </div>
                <p>
                  <span class="error">If you do not have the Tally(.PTG) file, please </span><a href='<?php echo e(route("tyauth",array("seller_id"=>$seller_id,"downloadFile" => "yes"))); ?>'> Click Here</a>
                </p>
                <div class="col-md-12 mb-10" id="proccedNext">
                  <button class="btn btn-success btn-sm" onclick="testConnection()" id="testConnection">Test Connection</button>
                  <a class="btn btn-info btn-md <?php echo e($tallyConnected->company_update_flag == 0 ? 'hidden' : ''); ?>" href="<?php echo e(route('tyauth',array('seller_id' => $seller_id))); ?>" id="next-step">Setup Settings</a>
                </div>
              </div>
          </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('more_scripts'); ?>
<script type="text/javascript">
  $(document).ready(function(){
    $("#company_name").select2();
  });
  
  $(document).on('click', '#save-company', function(){
      companyName = $("#company_name").val();
      if(companyName == '' || companyName == undefined){
          Swal.fire(
              "Error",
              "Please select company.",
              "error"
          );
      } else {
          $.ajaxSetup({
            headers: {
                 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            }
          });
          $.ajax({
              type: 'POST',
              url: "<?php echo e(route('updatecompany')); ?>?seller_id=<?php echo e($seller_id); ?>", 
              data: {"companyName": companyName},
              success:function( data ) 
              { 
                if(data.success == true){
                  /*$("#next-step").removeClass("hidden");
                  $("#testConnection").addClass("hidden");*/

                  startLoading('Please go to your Tally web connector application and click on the Update button.');

                  checkDataUpdated();
                }else{
                  alert(data.message)
                }
              },
              error : function(error)
              {
                 alert(error.responseJSON.message)
              }
          });
      }
  });
  function testConnection(){
      $.ajax({
          type: 'GET',
          url: "<?php echo e(route("checktallyconnection")); ?>?seller_id=<?php echo e($seller_id); ?>", 
          data:"",
          success:function( data ) 
          { 
            stopLoading();
            if(data.success == true){
              $("#next-step").removeClass("hidden");
              $("#testConnection").addClass("hidden");
            }else{
              alert(data.message)
            }
          },
          error : function(error)
          {
             alert(error.responseJSON.message)
          }
    });
  }

  function checkDataUpdated()
{
  var checkDataUpdated = setInterval(function() {
      $.ajax({
            type: 'GET',
            url: "<?php echo e(route('checktallyconnection',array('seller_id' => $seller_id ))); ?>", 
            data:"",
            success:function( data ) 
            { 
              if(data.success == true)
              {
                stopLoading();
                clearInterval(checkDataUpdated);
                window.location.reload();
              }
              
            },
            error : function(reject)
            {
              stopLoading();
              clearInterval(checkDataUpdated);
              var errorHtml = '<div class="col-md-12"><div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">&times;</button><i class="fa fa-exclamation-circle faa-pulse animated"></i><strong>Error: </strong>Something went wrong,Please try again.</div></div>';

                $('.card-body').prepend(errorHtml);

              window.scrollTo(0,0);
            }
        });

      }, 30000);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\ecomm2db\resources\views/tally/connection/updatecompany.blade.php ENDPATH**/ ?>