<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::group([ 'prefix' => 'auth','middleware' => ['web']], function () {
	Route::get('/appcallback', [App\Http\Controllers\Master\Sellers\AuthenticationController::class, 'appAuth'])->name('appcallback');
});

Route::group([ 'prefix' => 'sellers','middleware' => ['auth','web']], function () {
	Route::get('/', [App\Http\Controllers\Master\Sellers\SellersController::class, 'index'])->name('sellers');
	Route::get('/add-seller', [App\Http\Controllers\Master\Sellers\SellersController::class, 'addSeller'])->name('add-seller');
	Route::post('/getaccountingsystem', [App\Http\Controllers\Master\Sellers\SellersController::class, 'getAccountingSystem'])->name('getaccountingsystem');
	Route::post('/authenticateseller', [App\Http\Controllers\Master\Sellers\SellersController::class, 'authenticateSeller'])->name('authenticateseller');
	Route::post('/storesellerdetail', [App\Http\Controllers\Master\Sellers\SellersController::class, 'storesellerdetail'])->name('storesellerdetail');

	Route::group([ 'prefix' => 'payment','middleware' => ['auth','web']], function () {
		Route::post('/postpayment', [App\Http\Controllers\Master\Payment\PaymentController::class, 'postSubscriptions'])->name('postpayment');
		Route::post('/postfreepayment', [App\Http\Controllers\Master\Payment\PaymentController::class, 'postFreeSubscriptions'])->name('postfreepayment');
	});
});

Route::get('/plans', [App\Http\Controllers\Master\Payment\SellerPlanController::class, 'getPlansIndex'])->name('plans');
Route::get('/tyauth', [App\Http\Controllers\Master\Connection\TallyConnectionController::class, 'index'])->name('tyauth');

Auth::routes();



