<?php

use Illuminate\Support\Facades\Route;

Route::group([ 'prefix' => 'shopify','middleware' => ['web']], function () {
	Route::get('/auth', [App\Http\Controllers\Shopify\AuthenticationController::class, 'index'])->name('auth');
	Route::get('/authcallback', [App\Http\Controllers\Shopify\AuthenticationController::class, 'authCallBack'])->name('authcallback');
	Route::get('/shopifyhome', [App\Http\Controllers\Shopify\ShopifyController::class, 'shopifyHome'])->name('shopifyHome');
	Route::get('/settings', [App\Http\Controllers\Shopify\ShopifyController::class, 'settings'])->name('settings');
	Route::post('/storereportsetting', [App\Http\Controllers\Shopify\ShopifyController::class, 'storeReportSetting'])->name('storereportsetting');

	Route::get('/allsettlements', [App\Http\Controllers\Shopify\SettlementsController::class, 'getSettlementList'])->name('allsettlements');
	Route::get('/settlementdetail', [App\Http\Controllers\Shopify\SettlementsController::class, 'settlementDetails'])->name('settlementdetail');
	Route::get('/addsummaryrequest', [App\Http\Controllers\Shopify\ShopifyController::class, 'addSummaryRequest'])->name('addsummaryrequest');	
});

