@extends('layouts.default')
@section('title')
  Account Details - {{ @$seller_details->seller_name }}
@stop
@section('content')
<div class="card card-flush">
  <div class="card-header align-items-center py-5 gap-2 gap-md-5">
    @if($enableFunctionality)  
        @if($displayButtons)
            @if($autosync_enable == "YES")
              <div class="row">
                <div class="col-md-12" style="font-size: 13px;">
                      If you want to your auto sync you may disable auto sync immediately using the button below.
                </div>
                <div class="col-md-12" style="font-size: 12px;margin-top:20px;">
                  <a href="" class="btn btn-warning btn-sm ad-click-event">Disable Auto Sync</a>
                </div>
              </div>
            @else
              <div class="row">
                <div class="col-md-12" style="font-size: 13px;">
                      If you are satisified with data sync you may enable auto sync immediately using the button below.
                </div>
                <div class="col-md-12" style="margin-top:20px;" >
                   <a href="" class="btn btn-success btn-sm ad-click-event" >Enable Auto Sync</a>
               </div>
              </div>
            @endif
        @else
            <div class="row">
              <div class="col-md-12" style="font-size: 14px;">
                   Once you have synced atleast two settlements and then verified the invoice in your Tally, a button to Enable Auto Sync will appear here.
              </div>
              <div class="col-md-12" style="font-size: 12px;margin-top:20px;">
                <a href="#" class="btn btn-success btn-sm ad-click-event" disabled>Enable Auto Sync</a>
              </div>
            </div>
        @endif
    @else
      <div class="col-md-12" style="font-size: 13px;">
            Auto Sync feature is available only for Premium app users. Please upgrade your plan to Enable auto sync.
      </div>
    @endif
  </div>
</div>
<br/>
<br/>
<div class="card card-flush">
  <div class="card-body pt-0">
    <div style="margin: 16px !important;margin-left: 0px!important">
      @if(!empty($settlementData))
      <a class="btn btn-warning" style="margin:5px;" href="">View All Settlements</a>
      @endif
      <a class="btn btn-info" href="{{$fetchSettlementUrl}}">Fetch Settlements</a>
    </div>
    <!-- <table class="table align-middle table-row-dashed fs-6 gy-3" id="settlement_list_table">
      <thead>
        <tr class="text-start text-gray-400 fw-bolder fs-7 text-uppercase gs-0">
          <th class="min-w-100px">Date</th>
          <th class="min-w-100px">Total</th>
          <th class="min-w-50px">Currency</th>  
          <th class="min-w-175px">Invoice Number</th>  
          <th class="min-w-175px">Error</th>  
          <th class="min-w-100px">Status</th>
          <th class="text-center min-w-100px">Action</th>
        </tr> 
      </thead>
      <tbody class="fw-bold text-gray-600">
        @if(!empty($settlementData) && count($settlementData) > 0)
          @foreach($settlementData as $settlement)
          <tr>
              <td>{{ $settlement['invoice_date'] }}</td>
              <td>{{ $settlement['total_amount'] }}</td>
              <td>{{ $settlement['currency'] }}</td>
              <td>{{ $settlement['document_number'] }}</td>
              <td>{{ @$settlement['error'] }}</td>
              <td>
                @if($settlement['sync_status'] == 'Sync')
                  <span class="badge badge-light-success">{{ $settlement['sync_status'] }}</span>
                @else
                  <span class="badge badge-light-danger">{{ $settlement['sync_status'] }}</span>
                @endif
              </td>
              <td>
                  <a href="#" class="btn btn-sm btn-light btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions
                    <span class="svg-icon svg-icon-5 m-0">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="black" />
                      </svg>
                    </span>
                  </a>              
                  <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold fs-7 w-125px py-4" data-kt-menu="true">
                      <div class="menu-item px-3">
                        <a href="#" class="menu-link px-3"><i class="fas fa-cog" style="padding-right: 6px;"></i> Review</a>
                      </div>
                      <div class="menu-item px-3">
                        <a href="#" class="menu-link px-3"><i class="far fa-chart-bar" style="padding-right: 6px;"></i> Sync to Tally</a>
                      </div>
                  </div>
              </td>
          </tr>
          @endforeach
        @else
          <tr class="text-center">
            <td colspan="7">
              No Integration found.
            </td>
          </tr>
        @endif
      </tbody>
    </table> -->
  </div>
</div>

@stop

@section('more_scripts')
<script src="{{ asset('assets/js/datatables.bundle.js') }}"></script>
<script src="{{ asset('assets/js/custom/settlement-list.js') }}"></script>
<script type="text/javascript">
  $(document).ready(function(){

  });
</script>
@stop