@extends('layouts/default')
@section('title')
  Check Tally Connection
@stop
@section('content')
<div class="company_page">
   <div class="card" id="kt_conenct">
      <div class="card-body p-lg-10">
          <div class="d-flex flex-column">
              <div class="mb-5 text-center">
                  <h1 class="fw-bolder mb-5">Connect Tally application to {{ @config('app.appModules')[$module] }}</h1>
                  <div class="text-gray-400 fw-bold fs-5"></div>
              </div>
              <div class="row g-10">
                <div class="col-md-12 text-center connection-img">
                  @if($module == 'tlaz')
                      <img src="{{ asset('assets/images/az-tl-connection.png') }}" width="300">
                    @endif
                </div>
                
                <div class="col-md-12 fs-6">
                  <p style="font-size: 14px;text-align: left;padding: 0 15px;">
                    It seems that we were not able to test the connection with your Tally file. Please click on the Test Connection button below so that we can test the connection and take you to the next steps.
                  </p>
                  <p style="font-size: 14px;text-align: left;padding: 0 15px;">
                    Before you click on this button, please enable the Auto Run in your Tally Web connector or else please click on the Update Selected button in the Tally Web connector a few times so that we can verify the connection.
                  </p>
                  <p style="font-size: 14px;text-align: left;padding: 0 15px;">
                    This process might take a few minutes to complete.
                  </p>
                  <p style="font-size: 14px;text-align: left;padding: 0 15px;">
                    <span style="color: red;">If you do not have the Tally Web Connector(.PTG) file, please </span><a href='{{ route("tyauth",array("seller_id"=>$seller_id,"downloadFile" => "yes")) }}'> Click Here</a>
                  </p>
                </div>

                <div class="col-md-12 text-center mb-10" id="proccedNext">
                  <button class="btn btn-success btn-md" onclick="testConnection()" id="testConnection">Test Connection</button>
                  <a class="btn btn-info btn-sm hidden" href="{{ route('tyauth',array('seller_id' => $seller_id)) }}" id="next-step">Setup Company</a>
                </div>

              </div>
          </div>
      </div>
    </div>
</div>
@stop
@section('more_scripts')
<script type="text/javascript">
    function testConnection(){
      $.ajax({
            type: 'GET',
            url: "{{ route("checktallyconnection")}}?seller_id={{$seller_id}}", 
            data:"",
            success:function( data ) 
            { 
                  stopLoading();
                  if(data.success == true){
                    $("#next-step").removeClass("hidden");
                    $("#testConnection").addClass("hidden");
                  }else {
                    if(data.data == 'updatecompany'){
                      $("#next-step").removeClass("hidden");
                      $("#testConnection").addClass("hidden");
                    }else{
                      alert(data.message);
                    }
                  }
            },
            error : function(error)
            {
               alert(error.responseJSON.message)
            }
      });
  }
</script>
@stop