@extends('layouts/default')

@section('title')
Settlements List
@stop

@section('content')
<div class="settlement_page">
	<div class="card mb-5 mb-lg-10">
		<!--begin::Card header-->
		<div class="card-header">
			<!--begin::Heading-->
			<div class="card-title">
				<h3>All Settlements</h3>
			</div>
			<!--end::Heading-->
			<div class="card-toolbar">
				<a href="{{ route('shopifyHome', array('shop'=> $shop)) }}" class="btn btn-sm btn-info my-1">Back To Dashboard</a>
			</div>
		</div>
		<!--end::Card header-->
		<!--begin::Card body-->
		<div class="card-body">
			<!--begin::Table wrapper-->
			<table class="table align-middle table-row-dashed fs-6 gy-3" id="settlement_list_table">
			      <!--begin::Table head-->
			      <thead>
			        <!--begin::Table row-->
			        <tr class="text-start text-gray-400 fw-bolder fs-7 text-uppercase gs-0">
			            <th class="min-w-100px">Date</th>
						<th class="min-w-100px">Gateway</th>
						<th class="min-w-80px">Total</th>
						<th class="min-w-80px">Currency</th>
						<th class="min-w-100px">Tax Type</th>
						<th class="min-w-50px">Action</th>
			        </tr>
			        <!--end::Table row-->
			      </thead>
			      <!--end::Table head-->
			      <!--begin::Table body-->
			        <tbody class="fw-bold text-gray-600">
			        	@if(!empty($settlementData))
							@foreach($settlementData as $key=>$value)
							<tr>
								<td>{{ $value['invoice_date'] }}</td>
								<td>{{ $value['gateway'] }}</td>
								<td>{{ $value['settlement_amount'] }}</td>
								<td>{{ $value['currency'] }}</td>
								<td>{{ $value['tax_type'] }}</td>
								<td>
									<a href="{{ route('settlementdetail', array('shop' => $shop, 'settlement_id'=> App\Helpers\Helper::encryptor('encrypt', $value['id']))) }}" class="btn btn-sm btn-primary">Review</a>
								</td>
							</tr>
							@endforeach
						@else
							<tr><td class="text-center" colspan="6">No Data Found.</td></tr>
						@endif
			        </tbody>
			      <!--end::Table body-->
			    </table>
			<!--end::Table wrapper-->
		</div>
		<!--end::Card body-->
	</div>
</div>
@stop
@section('more_scripts')
<script src="{{ asset('assets/js/custom/widgets.js') }}"></script>
<script src="{{ asset('assets/js/datatables.bundle.js') }}"></script>
<script src="{{ asset('assets/js/custom/settlement-list.js') }}"></script>
@stop
