@extends('layouts/default')

@section('title')
Settlements Details
@stop

@section('content')
<div class="settlement_page">
	<div class="card mb-5 mb-lg-10">
		<!--begin::Card header-->
		<div class="card-header">
			<!--begin::Heading-->
			<div class="card-title fs-4">
        <h3>Settlement Review</h3>
				
			</div>
			<!--end::Heading-->
			<div class="card-toolbar">
				<a href="{{ route('allsettlements', array('shop'=> $shop)) }}" class="btn btn-sm btn-info my-1">View All Settlement</a>
			</div>
		</div>
		<!--end::Card header-->
		<!--begin::Card body-->
		<div class="card-body">
      <div class="col-md-12 fs-5 mb-5">
        <span><strong>Date: </strong>{{ $settlementDetail[0]['invoice_date'] }}</span>
          <span style="padding-left: 100px;"><strong>Total: </strong>{{ number_format($settlementDetail[0]['total_amount'], 2) }}</span>
          <span style="padding-left: 100px;"><strong>Currency: </strong>{{ $settlementDetail[0]['currency'] }}</span>
          <span style="padding-left: 100px;"><strong>Tax Type: </strong>{{ $settlementDetail[0]['tax_type'] }}</span>
      </div>
			<table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
				<!--begin::Thead-->
				<thead class="border-gray-200 fs-5 fw-bold bg-lighten">
					<tr>
						<th class="">Description</th>
						<th style="padding-left: 5%">Tax (Percentage/Type)</th>
						<th class="text-center">Amount</th>
					</tr>
				</thead>
			</table>
		    
		    @foreach($summaryData as $key2=>$value2)                            
          <br />
          <table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
            <tbody class="fw-6 fw-bold text-gray-600 fs-6">
              @foreach($value2 as $key1=>$value1)                              
              <?php $rowspan = false;?>
                @foreach($value1 as $key=>$value)
                <tr>
                  <?php                                
                    if(isset($value['dataTax']) && $value['dataTax'] != ''){
                      $dataTax = substr($value['dataTax'], 0, strpos($value['dataTax'], "."));
                      $taxrate_acc_name = $value['FeeType'].'-'.$dataTax.'_tax_code';
                      $acc_name = $value['FeeType'].'-'.$dataTax;
                    }else{
                      $value['dataTax'] = '';
                      $taxrate_acc_name = $value['FeeType'].'_tax_code';
                      $acc_name = $value['FeeType'];
                    }
                    $taxrate_acc_name_and = str_replace('&', '', $taxrate_acc_name);
                    $taxrate_acc_name_and = str_replace(' ', '', $taxrate_acc_name_and);

                    $acc_name_and =  str_replace('&', '', $acc_name);
                    $acc_name_and = str_replace(' ', '', $acc_name_and);
                    $acc_name_and =  str_replace('$', '', $acc_name_and);
                    $acc_name_and = str_replace(' ', '', $acc_name_and); 
                    $count = array_count_values(array_column($value1,'FeeType'));
                  ?>
                  @if(isset($value['dataTax']) && $value['dataTax'] != '')
                  @if($rowspan == false)
                  <td style="width: 15% !important;" rowspan="{{$count[$value['FeeType']]}}">
                    {{$value['FeeType_description']}}</td>
                  @endif
                  <td style="width: 15% !important;">{{$value['dataTax']}}</td>
                  @else
                  <td style="width: 30% !important;" colspan="2">{{$value['FeeType_description']}}</td>
                  @endif
                  <?php  if(isset($value['dataTax']) && $value['dataTax'] != '')$rowspan = true;?>
                  <td style="width: 10% !important;" class="text-center">{{$value['CurrencyAmount']}}</td>
                </tr>
                @endforeach
              @endforeach
            </tbody>
          </table>
      @endforeach
			<!--end::Table wrapper-->
		</div>
		<!--end::Card body-->
	</div>
</div>
@stop
@section('more_scripts')
<script type="text/javascript">
	$(document).ready(function(){
	    
	});
</script>
@stop
