@extends('layouts.default')
@section('title')
Add Integration
@stop

@section('content')
<div class="addseller_page">
	<div class="card mb-5 mb-xl-10">
		<div class="card-body pt-9 pb-0">
			<!--begin::Stepper-->
			<div class="stepper stepper-links d-flex flex-column first" id="kt_modal_add_seller_stepper" data-kt-stepper="true">
												<!--begin::Container-->
			<div class="container">
				<!--begin::Nav-->
				<div class="stepper-nav justify-content-center py-2" style="justify-content: left !important;">
					<!--begin::Step 1-->
					<div class="stepper-item me-5 me-md-15 current" data-kt-stepper-element="nav" style="margin-left: 0px;">
						<h3 class="stepper-title">Ecommerce Platform</h3>
					</div>
					<!--end::Step 1-->
					<!--begin::Step 2-->
					<div class="stepper-item me-5 me-md-15 pending" data-kt-stepper-element="nav">
						<h3 class="stepper-title">Accounting Platform</h3>
					</div>
					<!--end::Step 2-->
					<!--begin::Step 3-->
					<div class="stepper-item me-5 me-md-15 pending" data-kt-stepper-element="nav">
						<h3 class="stepper-title">Authenticate</h3>
					</div>
					<!--end::Step 3-->
				</div>
				<!--end::Nav-->
				<!--begin::Form-->
				<form class="mx-auto w-100 pt-15 pb-10 fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate" id="kt_modal_create_project_form" method="post">
					<!--begin::Type-->
					<div class="current" data-kt-stepper-element="content">
						<!--begin::Wrapper-->
						<div class="w-100">
							<!--begin::Heading-->
							<div class="pb-7 pb-lg-12">
								<!--begin::Title-->
								<h2 class="fw-bolder text-dark">Ecommerce Platform</h2>
								<!--end::Title-->
								<!--begin::Description-->
								<div class="text-muted fw-bold fs-5">Please select the Ecommerce platform that you would like to add.</div>
								<!--end::Description-->
							</div>
							<!--end::Heading-->
							<!--begin::Input group-->
							<div class="row row-cols-1 row-cols-md-5 row-cols-lg-1 row-cols-xl-5 g-9 mb-3 pt-1" data-kt-buttons="true">
								@if(!empty(config('integrations.app_integrations')))
	                                @foreach(config('integrations.app_integrations') as $key => $value)
	                                @if($value['enable'] == "true")
	                                <!--begin::Col-->
	                                <div class="col">
	                                  <!--begin::Option-->
	                                  <label class="btn btn-outline btn-outline-dashed btn-outline-default d-flex text-start p-2" data-kt-button="true">
	                                    <!--begin::Radio-->
	                                    <span class="form-check form-check-custom form-check-solid form-check-sm align-items-start">
	                                      <input type="radio" id="marketplace_type" name="marketplace_type" value="{{ $key }}" class="btn-check"/>
	                                    </span>
	                                    <!--end::Radio-->
	                                    <!--begin::Info-->
	                                    <span class="">
	                                      <span class="fs-3 fw-bolder text-gray-800 d-block"><img src="{{ asset('assets/images/logos/'.$value['logo']) }}" style="width:100%" /></span>
	                                    </span>
	                                    <!--end::Info-->
	                                  </label>
	                                  <!--end::Option-->
	                                </div>
	                                @endif
	                                @endforeach
	                              @endif							
								
							</div>
							<!--end::Input group-->						
						</div>
						<!--end::Wrapper-->
					</div>
					<!--end::Type-->
					<!--begin::Settings-->
					<div data-kt-stepper-element="content" class="pending">
						<!--begin::Wrapper-->
						<div class="w-100">
							<!--begin::Heading-->
							<div class="pb-12">
								<!--begin::Title-->
								<h2 class="fw-bolder text-dark">Accounting Platform</h2>
								<!--end::Title-->
								<!--begin::Description-->
								<div class="text-muted fw-bold fs-5">Please select the Accounting platform that you would like to integrate with <strong class="ecom-platform"></strong>.</div>
								<!--end::Description-->
							</div>
							<!--end::Heading-->
							<div class="row row-cols-1 row-cols-md-6 row-cols-lg-1 row-cols-xl-6 g-9 mb-20" data-kt-buttons="true" data-kt-buttons-target="[data-kt-button='true']" id="accounting_section">         
	                        </div>
							<!--end::Input group-->
							<div class="fv-plugins-message-container invalid-feedback" id="accounting-error"></div>
						</div>
						<!--end::Wrapper-->
					</div>
					<!--end::Settings-->
					<!--begin::Budget-->
					<div data-kt-stepper-element="content" class="pending">
						<!--begin::Wrapper-->
						<div class="w-100">
							<!--begin::Heading-->
							<div class="pb-10 pb-lg-12">
								<!--begin::Title-->
								<h2 class="fw-bolder text-dark">Authenticate</h2>
								<!--end::Title-->
								<!--begin::Description-->
								<div class="text-muted fw-bold fs-5">Connect to your <strong class="ecom-platform"></strong> account.</div>
								<!--end::Description-->
								<div id="auth_section">
									
								</div>
							</div>
							<!--end::Heading-->
						</div>
						<!--end::Wrapper-->
					</div>
					<!--end::Budget-->	
					<!--begin::Actions-->
	                    <div class="d-flex flex-stack mt-10">
	                        <!--begin::Wrapper-->
	                        <div class="me-2">
	                            <button type="button" class="btn btn-light btn-active-light-primary btn-back" data-kt-stepper-action="previous">
	                                Previous
	                            </button>
	                        </div>
	                        <!--end::Wrapper-->

	                        <!--begin::Wrapper-->
	                        <div>
	                            <button type="button" class="btn btn-primary" data-kt-stepper-action="submit" id="complete-request" style="display: none;">
	                                <span class="indicator-label">
	                                    Complete
	                                </span>
	                                <span class="indicator-progress">
	                                    Please wait... <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
	                                </span>
	                            </button>

	                            <button type="button" class="btn btn-primary" data-kt-stepper-action="next">
	                                Next
	                            </button>
	                        </div>
	                        <!--end::Wrapper-->
	                    </div>
	                    <!--end::Actions-->		
				</form>
				<!--end::Form-->
			</div>
		<!--begin::Container-->
			</div>
		</div>
<!--end::Stepper-->
	</div>  
</div>
@stop
@section('more_scripts')
<script type="text/javascript">
$(document).ready(function() {
	var element = document.querySelector("#kt_modal_add_seller_stepper");
	// Initialize Stepper
	var stepper = new KTStepper(element,{
	  startStep: 1, // initial active step number
	  clickableSteps: true, // allow step clicking
	  navigation: true // disable default navigation handlers,
	});

	// Handle next step
	step = 1;
	stepper.on("kt.stepper.next", function (stepper) {
		
		marketplace = $('input[name="marketplace_type"]:checked').val();
    	accounting = $('input[name="accounting_type"]:checked').val();

    	if(step == 1){
	    	if(marketplace == '' || marketplace == undefined){
	          	Swal.fire(
		            "Error",
		            "Please select ecommerce platform.",
		            "error"
		       	);
	        } else {
	        	$.ajaxSetup({
	              headers: {
	                   'X-CSRF-TOKEN': '{{ csrf_token() }}'
	              }
	            });
	        	$.ajax({
	              type: 'post',
	              url: "{{ route('getaccountingsystem') }}", 
	              data: {"marketplace": marketplace},
	              success:function( data  ) 
	              { 
	                if(data == 'error') {
	                  Swal.fire({text:"Oops, Something went wrong.",icon:"error",buttonsStyling:!1,confirmButtonText:"Ok",customClass:{confirmButton:"btn btn-danger"}});
	                } else {
	                  step = 2;

	                  marketplace = marketplace.toLowerCase().replace(/\b[a-z]/g, function(letter) {
	                      return letter.toUpperCase();
	                  }); 
	                  $("#accounting_section").html(data);
	                  $(".ecom-platform").html(marketplace);
	                  stepper.goNext(); // go next step  
	                  return false;    
	                }
	              }
	            });
	        }
	        return false;
    	}

    	if(step == 2){
    		if(accounting == '' || accounting == undefined){
	          	Swal.fire(
		            "Error",
		            "Please select accounting platform.",
		            "error"
		       	);
	        } else {
	        	if(marketplace != '' && accounting != ''){
	        		$.ajaxSetup({
		              headers: {
		                   'X-CSRF-TOKEN': '{{ csrf_token() }}'
		              }
		            });

		        	$.ajax({
		              	type: 'post',
		              	url: "{{ route('authenticateseller') }}", 
		              	data: {"marketplace": marketplace, "accounting": accounting},
		              	success:function( data  ) 
		              	{
		              		$("#auth_section").html(data);
		              		step = 3;
	                		stepper.goNext();
		                  	return false;
		              	}
		            });
	        	}
	        }
	        return false;
    	}
        
	});

	stepper.on("kt.stepper.previous", function (stepper) {
	    step--;
	    stepper.goPrevious(); // go previous step
	});

});

function askforamazonflow(module){
        $('#amazonModule').val(module);
        $('#modal-askAmazonCountry').modal('show');
      }

      function amazonLoginPopup(amazoncountry){
        var state = $('#amazonModule').val();
        if(amazoncountry == 'us'){
          var amazonhost = 'sellercentral.amazon.com';
          var concateCountry = 'US';
        }
        if(amazoncountry == 'ca'){
          var amazonhost = 'sellercentral.amazon.ca';
          var concateCountry = 'CA';
        }
        if(amazoncountry == 'mexico'){
          var amazonhost = 'sellercentral.amazon.mx';
          var concateCountry = 'MX';
        }
        if(amazoncountry == 'gb'){
          var amazonhost = 'sellercentral.amazon.co.uk';
          var concateCountry = 'GB';
        }
        if(amazoncountry == 'au'){
          var amazonhost = 'sellercentral.amazon.com.au';
          var concateCountry = 'AU';
        }
        if(amazoncountry == 'uae'){
          var amazonhost = 'sellercentral.amazon.ae';
          var concateCountry = 'AE';
        }
        
        state = state+'@'+concateCountry+'@'+'<?php echo App\Helpers\Helper::encryptor('encrypt',Auth::user()->id);?>';
       
        if(state != ''){
            var url = "https://"+amazonhost+"/apps/authorize/consent?application_id=<?php echo config('ecomtoacc.amazon.SP_API_APPLICATION_ID'); ?>&state="+state+"<?php echo config('ecomtoacc.amazon.SP_API_VERSION'); ?>&redirect_uri=<?php echo config('ecomtoacc.amazon.SP_API_REDIRECT_URI'); ?>"; 
    
            var parameters = "location=1,width=800,height=650";
              parameters += ",left=" + (screen.width - 800) / 2 + ",top=" + (screen.height - 650) / 2;
              var win = window.open(url, 'connectPopup', parameters);

              var pollOAuth = window.setInterval(function () {
                  try {            
                      if (win.document.URL.indexOf("auth-success") != -1) {
                          window.clearInterval(pollOAuth);
                          win.close();                
                          //window.location= win.document.URL;                                            
                      }
                  } catch (e) {
                      console.log(e);
                  }
              }, 100); 
        } 
      }
</script>
@endsection