@extends('layouts.default')
@section('title')
Plans - {{ @$sellerinfo->seller_name }}
@stop

@section('content')
<div class="plans_page">
   <div class="card" id="kt_pricing">
      <!--begin::Card body-->
      <div class="card-body p-lg-10">
          <!--begin::Plans-->
          <div class="d-flex flex-column">
              <!--begin::Heading-->
              <div class="mb-13 text-center">
                  <h1 class="fs-2hx fw-bolder mb-5">Choose Your Plan</h1>
                  <div class="text-gray-400 fw-bold fs-5"><strong>Subscribe plan for seller {{ @$sellerinfo['seller_name'] }}</strong>.</div>
              </div>
              <!--end::Heading-->
              
              <!--begin::Row-->
              <div class="row g-10">
                  <!--begin::Col-->
                  @if(!empty($plans))
                  @foreach($plans as $plan)
                    @if($plan->price == 0)
                      <form class="col-xl-4" action="{{route('postfreepayment')}}" method="POST">
                    @else
                      <form class="col-xl-4"action="" method="POST">
                    @endif                      
                      <div class="d-flex h-100 align-items-center">
                          <!--begin::Option-->
                          <div class="w-100 d-flex flex-column flex-center rounded-3 bg-light bg-opacity-75 py-15 px-10">
                              <!--begin::Heading-->
                              <div class="mb-7 text-center">
                                  <!--begin::Title-->
                                  <h1 class="text-dark mb-5 fw-boldest">{{ $plan->name }}</h1>
                                  <!--end::Title-->
                                  <!--begin::Description-->
                                  <div class="text-gray-400 fw-bold mb-5">Optimal for {{ $plan->max_orders_allowed }}+ number of orders
                                  <br />for new startup</div>
                                  <!--end::Description-->
                                  <!--begin::Price-->
                                  <div class="text-center">
                                      <span class="mb-2 text-primary">$</span>
                                      <?php $plan_value = explode('.', $plan->price); ?>
                                      <span class="fs-3x fw-bolder text-primary" data-kt-plan-price-month="39" data-kt-plan-price-annual="399">{{ $plan_value[0] }}</span>
                                      <span class="fs-7 fw-bold opacity-50">/
                                      <span data-kt-element="period">Mon</span></span>
                                  </div>
                                  <!--end::Price-->
                              </div>
                              <!--end::Heading-->
                              <!--begin::Features-->
                              <div class="w-100 mb-5">
                                <?php $description = json_decode($plan->description,true); ?>
                                @foreach ($description as $key => $node)
                                  <!--begin::Item-->
                                  <div class="d-flex align-items-center mb-5">
                                      <span class="fw-bold fs-6 text-gray-800 flex-grow-1 pe-3">{{ $key }}</span>
                                      <!--begin::Svg Icon | path: icons/duotune/general/gen043.svg-->
                                      <span class="svg-icon svg-icon-1 svg-icon-success">
                                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                              <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="black" />
                                              <path d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z" fill="black" />
                                          </svg>
                                      </span>
                                      <!--end::Svg Icon-->
                                  </div>
                                  <!--end::Item-->
                                @endforeach
                              </div>
                              <!--end::Features-->
                              <!--begin::Select-->

                              @if($selectedplan == $plan->id)
                                <label class="fs-5"><strong>Current Plan</strong></label>
                              @else
                                {{ csrf_field() }}
                                <input type="hidden" name="plan_id_primary" value="{{$plan->id}}">
                                <input type="hidden" name="plan_id" value="{{$plan->stripe_plan_id}}">
                                <input type="hidden" name="gateway" value="{{$plan->gateway}}">
                                <input type="hidden" name="plan_name" value="{{$plan->name}}">
                                <input type="hidden" name="gateway" value="{{$plan->gateway_name}}">
                                <input type="hidden" name="plan_duration" value="{{$plan->terms}}">
                                <input type="hidden" name="seller_id" value="{{$seller_id}}">
                                <input type="hidden" name="change_plans" value="{{$change_plans}}">
                                @if($plan->price == 0)
                                  <button type="submit" class="stripe-button-el btn btn-sm btn-primary">Subscribe</button>
                                @else
                                  <button type="button" class="btn btn-sm btn-primary stripe-button-el" onclick="purchasePlan('{{$plan->price*100}}','{{$plan->id}}','{{$plan->stripe_plan_id}}','{{$plan->name}}','{{$plan->terms}}','{{$seller_id}}','{{$change_plans}}','{{$plan->gateway_name}}','{{$plan->price}}')">Subscribe</button>
                                @endif
                              @endif
                              <!--end::Select-->
                          </div>
                          <!--end::Option-->
                      </div>
                    </form>
                  @endforeach
                  @endif
                  <!--end::Col-->
              </div>
              <!--end::Row-->
          </div>
          <!--end::Plans-->
      </div>
      <!--end::Card body-->
    </div>
</div>  
<div class="modal fade" id="modal-selectbillinginfo" style="display: none;">
  <div class="modal-dialog">
    <div class="modal-content" style="width: 600px;">
      <div class="modal-header">
        <h2>Billing Details</h2>
        <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times fa-lg"></i></a>
      </div>      
      <div class="modal-body">
          <div class="row g-9" data-kt-buttons="true" data-kt-buttons-target="[data-kt-button='true']">
            @foreach($billingDetailsDb as $key=>$value)
            <!--begin::Col-->
            <div class="col-md-6 col-lg-12 col-xxl-6">
              <!--begin::Option-->
              <label class="btn btn-outline btn-outline-dashed btn-outline-default d-flex text-start p-6" data-kt-button="true">
                <!--begin::Radio-->
                <span class="form-check form-check-custom form-check-solid form-check-sm align-items-start mt-1">
                  <input type="radio" name="dbBillingDetails" value="{{$value->id}}" class="form-check-input dbBillingDetails"/>
                </span>
                <!--end::Radio-->
                <!--begin::Info-->
                <span class="ms-5">
                  <span class="fs-4 fw-bolder text-gray-800 mb-2 d-block">{{$value->name}}</span>
                  <span class="fw-bold fs-7 text-gray-600">
                    {{$value->address_line1}}<br/>
                      {{$value->address_line2}}<br/>
                      {{$value->city}} , {{$value->state}}<br/>
                      {{$value->country}}. {{$value->country}}<br/>
                  </span>
                </span>
                <!--end::Info-->
              </label>
              <!--end::Option-->
            <div class="fv-plugins-message-container invalid-feedback"></div></div>
            <!--end::Col-->
            @endforeach
            <div class="col-md-6 col-lg-12 col-xxl-6">
              <!--begin::Option-->
              <label class="btn btn-outline btn-outline-dashed btn-outline-default d-flex text-start p-6" data-kt-button="true">
                <!--begin::Radio-->
                <span class="form-check form-check-custom form-check-solid form-check-sm align-items-start mt-1">
                  <input type="radio" name="" value="" class="form-check-input dbBillingDetails" onclick="getBillingformFromNewoption()"/>
                </span>
                <!--end::Radio-->
                <!--begin::Info-->
                <span class="ms-5">
                  <span class="fs-4 fw-bolder text-gray-800 mb-2 d-block">Add New</span>
                  <span class="fw-bold fs-7 text-gray-600">

                  </span>
                </span>
                <!--end::Info-->
              </label>
            </div>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
</div>
<div class="modal fade" id="modal-billinginfo" style="display: none;">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h2>Billing Details</h2>
        <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times fa-lg"></i></a>
      </div>      
      <div class="modal-body">
        <form action="{{ route('postpayment') }}" id="billingdetails_form" method="POST">
           <div class="row user-info">
            {{ csrf_field() }}
            <input type="hidden" name="seller_id" id="seller_id" value="{{$seller_id}}">
            <input type="hidden" name="plan_id_primary" id="plan_id_primary" value="">
            <input type="hidden" name="plan_id" id="plan_id" value="">
            <input type="hidden" name="plan_name" id="plan_name" value="">
            <input type="hidden" name="plan_duration" id="plan_duration" value="">
            <input type="hidden" name="change_plans" id="change_plans" value="">
            <input type="hidden" name="seller_billing_id" id="seller_billing_id" value="">
            <input type="hidden" name="billing_address_id" id="billing_address_id" value="">
            <input type="hidden" name="gateway" id="gateway" value="">
            <input type="hidden" name="plan_amount" id="plan_amount" value="">
            <input type="hidden" name="payment_id" id="payment_id" value="">
            <input type="hidden" name="subscription_id" id="subscription_id" value="">

          <div class="mb-3 col-md-12 form-group {{ $errors->has('fullname') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <input class="form-control" type="text" name="fullname" id="fullname" value="{{ Input::old('fullname') }}" placeholder="Fullname" />
            {!! $errors->first('fullname', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
          <div class="mb-3 col-md-12 form-group {{ $errors->has('companyname') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <input class="form-control" type="text" name="companyname" id="companyname" value="{{ Input::old('companyname') }}" placeholder="Company Name" />            
          </div>
           <div class="mb-3 col-md-12 form-group {{ $errors->has('address1') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <input class="form-control" type="text" name="address1" id="address1" value="{{ Input::old('address1') }}" placeholder="Address Line 1" />
            {!! $errors->first('address1', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
           <div class="mb-3 col-md-12 form-group {{ $errors->has('address2') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <input class="form-control" type="text" name="address2" id="address2" value="{{ Input::old('address2') }}" placeholder="Address Line 2" />
            {!! $errors->first('address2', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
        </div>
        <div class="row user-info">
           <div class="mb-3 col-md-12 form-group {{ $errors->has('city') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <input class="form-control" type="text" name="city" id="city" value="{{ Input::old('city') }}" placeholder="City" />
            {!! $errors->first('city', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
           <div class="mb-3 col-md-12 form-group {{ $errors->has('pincode') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <input class="form-control" type="text" name="pincode" id="pincode" value="{{ Input::old('pincode') }}" placeholder="Pincode" />
            {!! $errors->first('pincode', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
        </div>
        <div class="row user-info">           
           <div class="col-md-12 form-group {{ $errors->has('state') ? ' has-error' : '' }}">
            <select class="mb-3 form-control usstate" name="state1" >
              @foreach($state as $state)
              <option value="{{$state['stateName']}}">{{$state['stateName']}}</option>
              @endforeach
            </select>
            <!-- <div class="next-label">E-mail</div> -->
            <input class="mb-3 form-control usstatetext" type="text" name="state" value="{{ Input::old('state') }}" placeholder="State" style="display: none;" />
            {!! $errors->first('state', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
          <div class="mb-3 col-md-12 form-group {{ $errors->has('country') ? ' has-error' : '' }}">
            <!-- <div class="next-label">E-mail</div> -->
            <select class="form-control" name="country" id="country" onchange="getstatetext();">
              @foreach($country as $country)
              <option value="{{$country['countryCode2']}}" <?php if($country['countryName'] == 'United States') echo "selected";?> >{{$country['countryName']}}</option>
              @endforeach
            </select>
            <!-- <input class="form-control" type="text" name="country" id="country" value="{{ Input::old('country') }}" placeholder="Country" /> -->
            {!! $errors->first('country', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
          </div>
            <div class="col-md-12 user-info" style="text-align: center;">
            <button type="button" onclick="payNow()" class="stripe-button-el"><span style="display: block; min-height: 30px;">Pay Now</span></button> 
            <div class="col-md-12 text-center navbar-btn d-none " style="display:none!important">
              <script
                src="https://checkout.stripe.com/checkout.js" id="stripe-script" class="stripe-button"
                data-button="pay"
                data-key="{{$strip_key}}"
                data-image="{{asset('assets/images/logos/parexlogo-small.png')}}"
                data-name="Parex Technologies"
                data-description=""
                data-amount="0"
                data-email=""
                data-label="Pay"
                data-locale="auto">
              </script>      
            </div>     
         </div>

        </div>
      </form>
      
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<div class="modal fade" id="askSellerInfo" style="display: none;">
  <div class="modal-dialog" >
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Store Information</h4>
      </div>
      <div class="modal-body">
        <form id="basicsellerinfo" class="" name="basicsellerinfo" autocomplete="off" role="form" >
          <div class="col-md-12" style="margin-bottom: 14px;">We did not receive some of the information about your store. Please fill in the below details which are required for communication with you and to sync your orders accurately.</div>
          <input type="hidden" name="_token" value="{{ csrf_token() }}">
          <input type="hidden" name="seller_id" id="seller_id" value="{{@$seller_id}}"/>
          <div class="form-group" style="<?php if(@$sellerinfo['seller_name'] != '') echo "display: none;";?>">
              <div class="next-label">Store Name</div>
                <input class="form-control" type="text" name="seller_name" id="seller_name"  placeholder="Seller Name" value="{{ @$sellerinfo['seller_name'] }}" />
                <span id="err_seller_name" class="text-red"></span>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" onclick="saveSellerInfo();">Save</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
@endsection
@section('more_scripts')
<script type="text/javascript">
  $('input[type=radio][name=dbBillingDetails]').change(function() {    
    $('#billing_address_id').val($('input[name="dbBillingDetails"]:checked').val());
    
        var gateway_name = $('#gateway').val();
        if(gateway_name == 'stripe'){
          stripeBuyOnBillingSelect();
        }
  });

  $(document).ready(function() {
    $("#billingdetails_form").validate({
          rules: {
              fullname: { required: true},
              address1: { required: true,minlength: 5},            
              country: { required: true},            
              state: { required: true},            
              city: { required: true},            
              pincode: { required: true}, 
          },
          messages: {
              fullname: {required:"Name is required"},
              address1: {required:"Address Line 1 is required",minlength:"Address1 must be at least 5 characters long"},
              country: {required:"Country is required"},            
              state: {required:"State is required"},            
              city: {required:"City is required"},            
              pincode: {required:"Pincode is required"},            

          }
      });

      <?php if($askSellerInfo==true) { ?>
        $('#askSellerInfo').modal("show");
      <?php } ?>
    });

  function getBillingformFromNewoption(){

    $('#modal-selectbillinginfo').modal('hide');
    $('#modal-billinginfo').modal('show');
  }

  function purchasePlan(amount,plan_id_primary,plan_id,plan_name,plan_duration,seller_id,change_plans,gateway,plan_amount){
      var stripe_cust = '{{@$seller_plan->stripe_customer_id}}';
      if(stripe_cust == ''){
        $('.dbBillingDetails').prop('checked', false);

        $('script.stripe-button').attr('data-amount', amount);
        $('script.stripe-button').attr('data-description', 'Pay $'+amount);
        $('#plan_id_primary').val(plan_id_primary);
        $('#plan_id').val(plan_id);
        $('#gateway').val(gateway);
        $('#plan_name').val(plan_name);
        $('#plan_amount').val(plan_amount);
        $('#plan_duration').val(plan_duration);
        $('#change_plans').val(change_plans);

        //$('#stripe-button').attr('data-amount',amount);
        if('{{$billingDetailsexist}}' == true)
          $('#modal-selectbillinginfo').modal('show');
        else
          $('#modal-billinginfo').modal('show');
      }else{

          $('#changeplan_plan_id').val(plan_id);
          $('#changeplan_plan_id_primary').val(plan_id_primary);
          $('#changePlanInfo').modal('show');
      }
  }

  function stripeBuyOnBillingSelect(){
     var amount = $('script.stripe-button').attr('data-amount');
     var token = function(res){
              var $id = $('<input type=hidden name=stripeToken />').val(res.id);
              var $email = $('<input type=hidden name=stripeEmail />').val(res.email);
              //var $email = $('<input type=hidden name=planid />').val(res.email);
              $('#billingdetails_form').append($id).append($email).submit();
            };

        StripeCheckout.open({
            key:         '{{$strip_key}}',
            amount:      amount,
            name:        'Parex Technologies',
            image:       '{{asset('assets/images/logos/parexlogo-small.png')}}',
            description: 'Payment Amount $'+amount/100,
            locale:"auto",
            token:       token
        });
  }

  function stripeBuy(){
    if($("#billingdetails_form").valid()){

        var amount = $('script.stripe-button').attr('data-amount');
        var token = function(res){
            var $id = $('<input type=hidden name=stripeToken />').val(res.id);
            var $email = $('<input type=hidden name=stripeEmail />').val(res.email);
            //var $email = $('<input type=hidden name=planid />').val(res.email);
            $('#billingdetails_form').append($id).append($email).submit();
        };

        StripeCheckout.open({
            key:         '{{$strip_key}}',
            amount:      amount,
            name:        'Parex Technologies',
            image:       '{{asset('assets/images/logos/parexlogo-small.png')}}',
            description: 'Payment Amount $'+amount/100,
            locale:"auto",
            token:       token
          });
      }
  }

  function getstatetext(){
  
    if($('#country').val() != 'US'){      
      $('.usstatetext').css('display','block');
      $('.usstate').css('display','none');
    }else{
      $('.usstatetext').css('display','none');
      $('.usstate').css('display','block');
    }
 }

 function payNow(){
    var gateway = $('#gateway').val();
    if(gateway == 'stripe'){
      stripeBuy();
    }
 }

 function saveSellerInfo(){
      var seller_name = $('#seller_name').val();
      
      if(seller_name == ''){
        if(seller_name == ''){
          $('#err_seller_name').html('Store Name is required.');
        }else{
          $('#err_seller_name').html('');
        }
      }else{
        //call ajax to save seller info
        $.ajax({
            type: 'POST',
            url: "{{route('storesellerdetail',array('seller_id' => $seller_id ))}}", 
            data:$('#basicsellerinfo').serialize(),
            success:function( data  ) 
            { 
              //stopLoading();
              if(data == 'success')
              $('#askSellerInfo').modal('hide');
              $('.connection-img-btn').css('display','block');
            },
        });
      }
  }
</script>
@endsection