"use strict";

// Class definition
var varSettlementListing = function () {
    // Shared variables
    var table;
    var datatable;
    
    // Private functions
    var initDatatable = function () {
        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
            "info": false,
            'order': [],
            'pageLength': 10,
            /*'columnDefs': [
                { orderable: false, targets: 0 }, // Disable ordering on column 0 (checkbox)
                { orderable: false, targets: 7 }, // Disable ordering on column 7 (actions)
            ]*/
        });

    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-ecommerce-order-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }

    // Public methods
    return {
        init: function () {
            table = document.querySelector('#settlement_list_table');

            if (!table) {
                return;
            }

            initDatatable();			
            handleSearchDatatable();                    
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    varSettlementListing.init();
});