"use strict";

// Class definition
var varSellerListing = function () {
    // Shared variables
    var table;
    var datatable;
    
    // Private functions
    var initDatatable = function () {
        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
            "info": false,
            'order': [],
            'pageLength': 10,
            'columnDefs': [
				{ orderable: false, targets: 0 },
                { orderable: false, targets: 7 },
            ]
        });

    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-ecommerce-seller-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }

    // Public methods
    return {
        init: function () {
            table = document.querySelector('#seller_list_table');

            if (!table) {
                return;
            }

            initDatatable();			
            handleSearchDatatable();                    
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    varSellerListing.init();
});