<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Model;
use App\Models\Shopify\Spylastsync;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

class Spysummaryorder extends Model
{
    protected $connection = 'shopify';
    protected $dates = [''];
    protected $table = 'spy_summary_order';
    protected $rules = array();

    protected $injectUniqueIdentifier = true;

    public static function ftechLastOrder($seller_id)
    {
    	$SpyorderObj = Spysummaryorder::where("seller_id",$seller_id)->orderBy("order_id","DESC")->limit(1)->first();

    	return $SpyorderObj;
    }

    public static function fetchSpyOrderSingleData($column , $value,$seller_id,$module)
    {
        $SpycredentialObj = Spysummaryorder::where($column,$value)->where('seller_id',$seller_id)->where('module',$module)->first();

        return $SpycredentialObj;
    }
    public static function fetchLastSyncOrder($seller_id)
    {
        $spyOrder = Spysummaryorder::select('order_id','processed_at')->where("seller_id",$seller_id)
                    ->where("sync_status_flg","Sync")
                    ->orderBy("processed_at","DESC")
                    ->first();
        return $spyOrder;
    }
    public static function fetchAllData($seller_id,$order_id)
    {
        $spyOrder = Spysummaryorder::select('xero_payments.*','spy_customers.*')
                    ->join('xero_payments','xero_payments.order_id','=','spy_summary_order.order_id')
                    ->join('spy_customers','spy_customers.customer_id','=','spy_summary_order.customer_id')
                    ->where("spy_summary_order.seller_id",$seller_id)->where('spy_summary_order.xo_id',$order_id)->whereNull("xero_payments.deleted_at")                   
                    ->first();
        return $spyOrder;
    }
    public static function orderlistAjax($seller_id,$status)
    {
        $spyOrder = Spysummaryorder::where("seller_id",$seller_id)
                    ->where("sync_status_flg",'=',$status);
        return $spyOrder;
    }
    public function scopeTextsearch($query, $search, $type)
    {
      return $query->where(function ($query) use ($search) 
      {
        $query
          ->where('name', 'LIKE', "%$search%")
          ->orWhere('order_created_at', 'LIKE', "%$search%")
          ->orWhere('order_id', 'LIKE', "%$search%")
          ->orWhere('total_price', 'LIKE', "%$search%");
      });
    }
    public static function orderTotalSync($seller_id,$flg)
    {
        $spyOrder = Spysummaryorder::where('sync_status_flg',$flg)
        ->where('seller_id',$seller_id)->count();

        return $spyOrder;
    }
    public static function getGateways($seller_id){
        $spyOrder = DB::select(DB::Raw("SELECT `gateway` FROM `spy_summary_order` WHERE `seller_id` = '".$seller_id."' GROUP BY `gateway`"));  
        if(!empty($spyOrder)){
            return $spyOrder;
        }
        else
            return array();
    }

    public static function fetchOrdersCountByOrderId($seller_id,$module,$orderIds){
        $spyOrder = DB::select(DB::Raw("SELECT * FROM `spy_summary_order` WHERE `seller_id` = '".$seller_id."'  and `module` = '".$module."'  and order_id in (".implode(',',$orderIds).")"));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }

    public static function fetchOrderOrderId($seller_id,$orderId){
        $spyOrder = DB::select(DB::Raw("SELECT * FROM `spy_summary_order` WHERE `seller_id` = '".$seller_id."' and order_id = ".$orderId));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }
    public static function fetchSyncedOrder($seller_id,$module,$orderId){
        $spyOrder = DB::select(DB::Raw("SELECT  (total_price+IFNULL(total_giftcard,0)) as total_price ,sync_flg,taxes_included  FROM `spy_summary_order` WHERE `seller_id` = '".$seller_id."' and `module` = '".$module."' and order_id ='".$orderId."' "));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       if(isset($spyOrder[0]))
        return $spyOrder[0];
       else
        return array();
    }

    public static function fetchCurrencyConversionByOrderIds($seller_id,$module,$orderIds){
        $spyOrder = DB::select(DB::Raw("SELECT concat(`spy_summary_order`.`currency`,'-',`presentment_currency`) as currency,sum(`amount`) - sum(`total_price`) - sum(`total_giftcard`)  as amount FROM `spy_summary_order` join  spy_summary_payout_transaction on `spy_summary_order`.order_id = `spy_summary_payout_transaction`.`order_id` and `spy_summary_order`.seller_id = `spy_summary_payout_transaction`.`seller_id` and   type = 'charge' WHERE `spy_summary_order`.`seller_id` = '".$seller_id."' and `spy_summary_order`.`module` = '".$module."' and `spy_summary_order`.order_id in (".implode(',',$orderIds).") And presentment_currency != spy_summary_order.currency group by presentment_currency having sum(total_price) - sum(amount) != 0 "));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }
    public static function getCostData($startdate,$reportenddate){
       
       return Spysummaryorder::with(['orders'])->whereBetween('processed_at', [$startdate, $reportenddate])->get();
    }

    public static function fetchCurrencyConversionByOrderId($seller_id,$orderId){
        $spyOrder = DB::select(DB::Raw("SELECT concat(`spy_summary_order`.`currency`,'-',`presentment_currency`) as currency,sum(`amount`) - sum(`total_price`)  as amount FROM `spy_summary_order` join  spy_summary_payout_transaction on `spy_summary_order`.order_id = `spy_summary_payout_transaction`.`order_id` and `spy_summary_order`.seller_id = `spy_summary_payout_transaction`.`seller_id` and   type = 'charge' WHERE `spy_summary_order`.`seller_id` = '".$seller_id."' and `spy_summary_order`.order_id = ".$orderId." And presentment_currency != spy_summary_order.currency group by presentment_currency having sum(total_price) - sum(amount) != 0 "));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return json_encode($spyOrder);
    }

    public static function fetchUnsyncgatewayorders($seller_id,$date)
    {
         $spyOrder = DB::select(DB::Raw("SELECT count(order_id) as total_transactions,gateway,DATE_FORMAT(transaction_gateway, '%Y-%m-%d') as payout_date,sum(`total_line_items_price`) as total_sale,sum(`total_tax`) as total_tax,sum(`total_shipping`) as total_shipping,sum(`total_shipping_tax`) as total_shipping_tax,sum(`total_tip_received`) as total_tip_received,sum(`total_discounts`) as total_discounts,sum(`total_giftcard`) as total_giftcard FROM `spy_summary_order`  WHERE `seller_id` = '".$seller_id."' and (gateway !='shopify_payments' OR gateway IS NULL) and transaction_gateway > '".$date."' and transaction_gateway < '".date('Y-m-d')."' group by gateway,DATE_FORMAT(transaction_gateway, '%Y-%m-%d') order by transaction_gateway asc"));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }
    public static function fetchUnsyncgatewayorder($seller_id,$module,$startdate,$reportenddate,$report_type,$reCalcParameters)
    {   
        $transaction_id=(isset($reCalcParameters['transactionId']))?$reCalcParameters['transactionId']:"";
        $transaction_type=(isset($reCalcParameters['transaction_type']))?$reCalcParameters['transaction_type']:"";
        $gateway=(isset($reCalcParameters['gateway']))?$reCalcParameters['gateway']:"";
        $reportType=(isset($reCalcParameters['reportType']))?$reCalcParameters['reportType']:"";
        $transactionId=$gatewayCnd="";

        if(!empty($transaction_id) && $transaction_type=="Individual"){
            $transactionId="and transaction_id='".$transaction_id."' ";
        }else if($reportType=="recalculateReport" && $transaction_type=="Summary"){
            $gateways=config('app.gatewayKey');

            if((isset($gateways[$gateway])) && is_array($gateways[$gateway])){
                $commaDoubleQuoteList='"' . implode('", "' , $gateways[$gateway]) . '"';
                $gatewayCnd="and transaction_gateway in (".$commaDoubleQuoteList.") ";
            }else if(!empty($gateway)){
                $gatewayCnd="and transaction_gateway='".$gateway."' ";
            }else{
                $gatewayCnd="and (transaction_gateway IS NULL OR transaction_gateway ='')";
            }
            
        }else{
            $gatewayCnd="and ((transaction_gateway != 'shopify_payments' AND transaction_gateway != 'shopify_installments' AND transaction_gateway != 'shop_cash')  OR transaction_gateway IS NULL OR transaction_gateway ='')";
        }
        $date=($report_type=="monthly")?date('Y-m'):date('Y-m-d');

        $spyOrder = DB::select(DB::Raw("SELECT *,(total_price-IFNULL(total_giftcard,0)) as total_price FROM `spy_summary_order` WHERE `seller_id` = '".$seller_id."' and `module` = '".$module."' ".$gatewayCnd." and transaction_date > '".$startdate."' and transaction_date < '".$reportenddate."' and processed_at <'".$date."' ".$transactionId." and sync_flg !='D'  order by transaction_date asc"));  
         
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }
    public function orders()
    {
        return $this->hasMany(Spylineitems::class, 'order_id', 'id');
    }
    public static function checkOrderIgnore($details,$orderData){
        $paraAry=array("module"=>$details->module,"type"=>"feature");
        $featureRelation=getModuleViseData($paraAry);
        $featureDetails=(!empty($details->$featureRelation))?$details->$featureRelation:"";
      
        $orderFlag=false;
        foreach ($featureDetails as $key => $value) {
     
            if(!empty($value) && !is_null($value['details']) && !empty($value['details'])){
                $detailsAry = json_decode($value['details'],true);
                $detailsAryValue =  Arr::dot($detailsAry);
                $orderDataAry =  Arr::dot($orderData);
                
                $details_key=array_keys($detailsAry);
                $details_key=(isset($details_key[0]))?$details_key[0]:"";
                $orderDataKey=(isset($orderDataAry[$details_key]))?$orderDataAry[$details_key]:"";
         
                if(in_array($orderDataKey,$detailsAryValue)){
                    $orderFlag=true;
                }
            }   
        }
        return $orderFlag;
    }
}
