<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Spyordertransaction extends Model
{
    protected $connection = 'shopify';
    protected $dates = [''];
    protected $table = 'spy_summary_order_transaction';
    protected $rules = array();
    protected $injectUniqueIdentifier = true;

    public static function fetchTransactionSingleData($column , $value,$seller_id,$module)
    {
        $SpycredentialObj = Spyordertransaction::where($column,$value)->where('seller_id',$seller_id)->where('module',$module)->first();

        return $SpycredentialObj;
    }
    public static function fetchTransactionData($column , $value,$seller_id,$module,$transaction_id)
    {
        $kindAry=['capture','sale'];
        $SpycredentialObj = Spyordertransaction::where($column,$value)->whereIn('kind',$kindAry)->where('seller_id',$seller_id)->where('module',$module)->where('transaction_id',$transaction_id)->first();

        return $SpycredentialObj;
    }
    public static function fetchRemainingTransactionData( $seller_id,$module,$date,$reportenddate,$transIds,$report_type="",$reCalcParameters,$orderId)
    {
        $reportType=(isset($reCalcParameters['reportType']))?$reCalcParameters['reportType']:"";
        $transaction_type=(isset($reCalcParameters['transaction_type']))?$reCalcParameters['transaction_type']:"";
        $gateway=(isset($reCalcParameters['gateway']))?$reCalcParameters['gateway']:"";
        $removeEmptyTrans=array_filter($transIds);
        $transactions=implode(",", $removeEmptyTrans);
   
        if(!empty($transactions))
        $transwhere= "AND spy_summary_order_transaction.id Not In (".$transactions.")";
        else
        $transwhere= '';

        $dateCnd=$orderIdCnd="";
        if( $reportType=="recalculateReport" && !empty($orderId) && $transaction_type=="Individual"){
            $orderIdCnd=" and `spy_summary_order_transaction`.`order_id` ='".$orderId."'";
        }else if($reportType=="recalculateReport" && $transaction_type=="Summary"){
            $gateways=config('app.gatewayKey');
            if((isset($gateways[$gateway])) && is_array($gateways[$gateway])){
                $commaDoubleQuoteList='"' . implode('", "' , $gateways[$gateway]) . '"';
                $gatewayCnd="and spy_summary_order_transaction.gateway in (".$commaDoubleQuoteList.") ";
            }else if(!empty($gateway)){
                $gatewayCnd="and spy_summary_order_transaction.gateway='".$gateway."' ";
            }else{
                $gatewayCnd="and (spy_summary_order_transaction.gateway IS NULL OR spy_summary_order_transaction.gateway ='')";
            }
            
            $dateCnd=$gatewayCnd." and spy_summary_order_transaction.transaction_created_at < '".$reportenddate."' ";
            
        }else{
            $cDate=($report_type=="monthly")?date('Y-m'):date('Y-m-d');
            $dateCnd="and (spy_summary_order_transaction.gateway!='shopify_payments' and spy_summary_order_transaction.gateway!='shopify_installments'  and spy_summary_order_transaction.gateway!='shop_cash') and spy_summary_order_transaction.transaction_created_at < '".$reportenddate."' and spy_summary_order_transaction.transaction_created_at < '".$cDate."'";
        }
        
        $spyOrder = DB::select(DB::Raw("SELECT spy_summary_order_transaction.* FROM   `spy_summary_order_transaction` join `spy_summary_order` on `spy_summary_order_transaction`.`order_id` = `spy_summary_order`.order_id and `spy_summary_order_transaction`.seller_id = `spy_summary_order`.seller_id WHERE spy_summary_order_transaction.`seller_id` = '".$seller_id."' and spy_summary_order_transaction.`module` = '".$module."' and  `kind` IN ('capture','sale')  and spy_summary_order_transaction.transaction_created_at > '".$date."' and `spy_summary_order_transaction`.`sync_flg` = 'N' and `spy_summary_order`.`sync_flg` != 'D'  ".$transwhere." ".$dateCnd." ".$orderIdCnd." order by transaction_created_at asc "));  
       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }

    public static function fetcholdTransactionData($seller_id,$module,$orderid,$transaction_id)
    {
        $SpycredentialObj = Spyordertransaction::where('seller_id',$seller_id)->where('module',$module)->where('order_id',$orderid)->where('transaction_id','<',$transaction_id)->where('status','success')->get()->toArray();

        return $SpycredentialObj;
    }
    public static function fetchTransactionDataCount($seller_id,$module,$orderid)
    {
        $SpycredentialObj = Spyordertransaction::where('seller_id',$seller_id)->where('module',$module)->where('order_id',$orderid)->where('status','success')->count();
        return $SpycredentialObj;
    }

}
