<?php
namespace App\Models\Master;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Master\Plans;
use App\Models\Master\SellerPlan;
use App\Models\User;
use Auth;
use DB;

class Sellers extends Model
{
  protected $connection = 'mysql';
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $table = 'sellers';
    protected $rules = array();
    protected $injectUniqueIdentifier = true;
    
 	protected $fillable = ['seller_name', 'status'];

 	public function scopeTextSearch($query, $search)
  {
        return $query->where(function ($query) use ($search) {
            $query->where('seller_name', 'LIKE', '%'.$search.'%');
        });
  }

  public static function getSellerData($column, $value){

      return Sellers::where($column, $value)->where('status', 'Active')->first();
  }

  public static function listSellers()
  {
      $user_id= Auth::user()->id;
      $sellers = DB::select( DB::raw("SELECT `sellers`.`id`, `sellers`.`seller_name`,`sellers`.`unique_seller_id`, `sellers`.`country`, `sellers`.`created_at` as seller_created_at, `sellers`.`status`, `sellers`.`payment_status`, `seller_plan`.`plan_name`, `seller_plan`.`plan_price`, `seller_plan`.`id` as `seller_plan_id`, `seller_plan`.`plan_cancelled_on`,`seller_plan`.`max_orders_allowed`,`seller_plan`.`dollar_per_order`,`sellers`.`marketplace_name`,`user_seller_int`.`role` FROM sellers inner join `user_seller_int` on `user_seller_int`.`seller_id` = `sellers`.`id` LEFT JOIN `seller_plan` on `seller_plan`.`seller_id` = `sellers`.`id` AND `seller_plan`.`status` = 'Active' where `user_seller_int`.`user_id` = '$user_id' and `sellers`.`status` = 'Active' and `user_seller_int`.`status` = 'Active' and `user_seller_int`.`deleted_at` is null and `sellers`.`deleted_at` is null group by `sellers`.`id`  order by `sellers`.`created_at` desc"));

      return $sellers;
  }

  /**
   update and add billing start day
  */
  public static function UpdateBillingdate($subscriptions,$plan_id)
  {
    $seller_plan = SellerPlan::where('seller_id',$subscriptions['seller_id'])->first();
    $plans = Plans::where('id',$plan_id)->first();

    $Sellers = Sellers::find($subscriptions['seller_id']);
    if($seller_plan)
    {   
        //$seller_plan = $seller_plan->plan_activated_on;
        $date =date('Y-m-d');
        $date1=date_create($seller_plan->plan_activated_on);
        $date2=date_create($date);
        $diff=date_diff($date1,$date2);
        if($plans->trial_days >= 1){
        $date = $plans->trial_days - $diff->format("%a");
        if($date <= $plans->trial_days){
          $Sellers->billing_start_date  = date("Y-m-d",strtotime("+".$date." day"));
        }else{
          $Sellers->billing_start_date  = date("Y-m-d");
        }
       }
    }else{
      
          if($plans->trial_days >= 1){
        $Sellers->billing_start_date = date( "Y-m-d", strtotime( "+".$plans->trial_days." day" ) );
      }else{
        $Sellers->billing_start_date  = date("Y-m-d");
      }
    }
    $Sellers->payment_status = 'Paid';
    $Sellers->save();
    
    return $Sellers;
  }

}
