<?php
namespace App\Models\Master;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Auth;
use DB;

class Plans extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql';
    protected $dates = ['deleted_at'];
    protected $table = 'plans';
    protected $rules = array(
        
    );
    protected $injectUniqueIdentifier = true;
 	protected $fillable = [];

 	public function scopeTextSearch($query, $search)
    {
        return $query->where(function ($query) use ($search) {
            $query->where('seller_name', 'LIKE', '%'.$search.'%');
        });
    }

    public static function getAppPlans($column, $value){

        return Plans::where('status','Active')->wherein('plan_type',array('Monthly','Yearly'))->where($column,$value)->orderby('price','asc')->get();
    }

    public static function getPlansForLandingPage(){

        $plansObj = Plans::select('*')->where('plan_type','Monthly')->where('price','>','0')->where('status','Active')->limit('3')->get();
        if(!empty($plansObj))
            $plansObj = $plansObj->toArray();
        else
            $plansObj = array();
        return $plansObj;
    }
}
