<?php
namespace App\Models\Amazon;

use Illuminate\Database\Eloquent\Model;
use DB;

class Azsummaryfinanceevent extends Model
{
    protected $dates = [''];
    protected $table = 'az_summary_financial_events';
    protected $connection = 'amazon';
    protected $rules = array(
        
    );
    protected $injectUniqueIdentifier = true;

   

   public static function checkExistOfEventEntry($seller_id,$settlement_id,$currency,$settlement_month,$type){
      $financeEventExistObj = Azsummaryfinanceevent::select('*')->where("seller_id",$seller_id)->where('settlement_id',$settlement_id)->where('financial_events_currency',$currency)->where('settlement_month',$settlement_month)->where('summary_type',$type)->first();
      return $financeEventExistObj;  
   }

   public static function getUnsyncFinaicalEventsData($seller_id){    
      $status = array("New","Pending");
      $financeEventExistObj = Azsummaryfinanceevent::select('*')
      ->whereIn('sync_status_flg',$status)      
      ->where('seller_id',$seller_id)
      //->whereDate('posted_date','<=',date('Y-m-d',strtotime('-2 days',strtotime('now'))))      
      ->orderBy('posted_date')
      ->limit(config('app.financialEventInQbLimit'))->get();
      return $financeEventExistObj;    
   }

   public static function getEventsBySettlementId($settlement_id){
      return  Azsummaryfinanceevent::select('az_summary_financial_events.*','az_summary_financial_settlements.total_amount')->join('az_summary_financial_settlements','az_summary_financial_settlements.settlement_id','=','az_summary_financial_events.settlement_id')->where('az_summary_financial_events.settlement_id',$settlement_id)->get()->toArray();
   }
   
   public static function getMaxOrderCount($seller_id,$duration = ''){
      $azFinance = Azsummaryfinanceevent::where('seller_id',$seller_id)->where('sync_status_flg','Sync');

      if($duration != '')
        $azFinance = $azFinance->where('created_at','>=',$duration);

      $azFinance = $azFinance->count();

        return $azFinance;
    }

    public static function eventSyncAsyncCountMonth($seller_id,$date)
    {
        $azOrder = Azsummaryfinanceevent::select('t1.syncOrders','t2.unsyncOrders')
        ->leftjoin(DB::raw("(select count(id) as syncOrders,DATE_FORMAT(created_at, '%Y-%m') as refordate from az_summary_financial_events where seller_id = '".$seller_id."' and sync_status_flg='Sync' and DATE_FORMAT(created_at, '%Y-%m') = '".$date."'  group by DATE_FORMAT(created_at, '%Y-%m')) as t1 "),DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'=','t1.refordate')
        ->leftjoin(DB::raw("(select count(id) as unsyncOrders,DATE_FORMAT(created_at, '%Y-%m') as refordate from az_summary_financial_events where seller_id = '".$seller_id."' and sync_status_flg IN ('Pending','Manualsync') and DATE_FORMAT(created_at, '%Y-%m') = '".$date."'  group by DATE_FORMAT(created_at, '%Y-%m')) as t2 "),DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'=','t2.refordate')
        ->where('seller_id',$seller_id)
        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'=',$date)
        ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'t1.syncOrders','t2.unsyncOrders')->first();

        if(!empty($azOrder))
            $azOrder = $azOrder->toArray();
        else
            $azOrder = array();

        return $azOrder;
    }

    public static function eventTotalSync($sd_id)
    {
        $azOrder = Azsummaryfinanceevent::where('sync_status_flg','Sync')
        ->where('seller_id',$sd_id)->count();

        return $azOrder;
    }

    public static function getEventsForSync($seller_id, $sync_status, $sync_flag, $type = ''){
        $azEvent = Azsummaryfinanceevent::whereIn('sync_flg',$sync_flag)->where('sync_status_flg',$sync_status)->where('seller_id',$seller_id)->limit(config('ecomtoacc.amazon.eventSyncDbToAccLimit'))->get();

        return $azEvent;
    }

    public static function getSummaryDetailsByReportID($seller_id,$report_id,$summarydb){
      
      $financeEventExistObj = Azsummaryfinanceevent::select($summarydb.'.*')
                              ->join($summarydb,$summarydb.'.marketplace_primary_id','=','az_summary_financial_events.id')
                              ->where("az_summary_financial_events.seller_id",$seller_id)
                              ->where('az_summary_financial_events.financial_reports_id',$report_id)
                              ->where('az_summary_financial_events.seller_id',$seller_id)
                              ->where($summarydb.'.seller_id',$seller_id)
                              ->get();

      return $financeEventExistObj;  
    }

    public static function getUnsyncFinaicalEventsDataEventData($seller_id){    
      $status = array("New","Pending");
      $financeEventExistObj = Azsummaryfinanceevent::select('az_financial_reports.*')
                            ->join('az_financial_reports','az_summary_financial_events.financial_reports_id','=','az_financial_reports.ReportId')
      ->whereIn('sync_status_flg',$status)      
      ->where('az_summary_financial_events.seller_id',$seller_id)     
      ->orderBy('az_summary_financial_events.posted_date')
      ->limit(config('app.financialEventInQbLimit'))->get();
      return $financeEventExistObj;    
   }
}
