<?php

namespace App\Http\Controllers\Tally\Tlsellers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Master\SellerPlan;
use App\Models\Tally\Tyconnections;
use App\Models\Tally\Tysummarysettings;
use App\Models\Tally\Tysummary;
use App\Models\Tally\Apierrorlog;
use App\Http\Traits\Summaryfetch;
use View;

class TallySellersController extends Controller
{
    use Summaryfetch;
	public function accountDetails(Request $request) {

		$seller_id_enc = $request->get('seller_id');
        $seller_id = Helper::encryptor('decrypt', $seller_id_enc);

        $sellerData = Sellers::getSellerData('id', $seller_id);
        if(!empty($sellerData)){
        	/* Check seller plan */
        	$sellerPlanData = SellerPlan::getSellerPlan($seller_id);
        	if(empty($sellerPlanData)){
        		return redirect()->route('plans', array('seller_id'=>$seller_id_enc));
        	}else{
                $enableFunctionality = false;
                if($sellerPlanData->plan_price > 0){
                    $enableFunctionality = true;
                }
            }
            $tlConnected = Tyconnections::checkTallyConnected($seller_id, $sellerData->marketplace_name);
            if($tlConnected == 'connected'){
                $tlSettings = Tysummarysettings::fetchSettingForSeller($seller_id, $sellerData->marketplace_name);
                if(!empty($tlSettings)){
                    $displayButtons = false;
                    $tallySummary = Tysummary::where('seller_id',$seller_id)->whereNotNull('tally_id')->count();
                    if($tallySummary > 0)
                    $displayButtons = true;

                    $settlementData = $this->getSummaryData($seller_id,3);

                    if(!empty($settlementData))
                    {
                        foreach ($settlementData as $key => $value) {
                          if($value['sync_status'] == 'Pending'){
                            $error = Apierrorlog::where('uniqueId',$value['id'])->orderby('id','desc')->first();
                            if(isset($error->error_msg)){
                              $settlementData[$key]['error'] = $error->error_msg;
                            }
                          }
                        }
                    }

                    $autosync_enable = $tlSettings->autosync_enable;
                    $fetchSettlementUrl = route('summaryfetchrequest',array('seller_id'=>$request->get('seller_id')));
                    return View::make('tally/sellers/accountdetails',compact('enableFunctionality','displayButtons','autosync_enable'))->with('seller_id',$seller_id_enc)->with('seller_details',$sellerData)->with('fetchSettlementUrl',$fetchSettlementUrl)->with('settlementData',$settlementData);
                } else {
                    return redirect()->route('tlsettings', array('seller_id'=>$seller_id_enc));    
                }
            } else {
                return redirect()->route('tyauth', array('seller_id'=>$seller_id_enc));
            }         	
        }
    }

    public function summaryFetchRequest(Request $request){
        $seller_id = Helper::encryptor('decrypt',$request->seller_id);
        list($message,$message_type) = $this->fetchSummaryRequest($seller_id);  
        return redirect()->route('tlaccountdetails',array("seller_id"=>$request->seller_id))->with($message_type,$message);
    }

    public function fetchSummary(Request $request){
      $seller_id = Helper::encryptor('decrypt',$request->get('seller_id'));
      $this->fetchSummaryToDb($seller_id);
    }

}
