<?php

namespace App\Http\Controllers\Shopify;

use App\Http\Controllers\Controller;
use App\Models\Shopify\Spycredential;
use App\Models\Shopify\Spyreportsetting;
use App\Models\Shopify\Spysummary;
use App\Models\Shopify\SpySummaryRequest;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Validator;
use Input;
use Redirect;
use View;
use Response;
use Session;

class ShopifyController extends Controller
{
    public static function shopifyHome(Request $request){

        $shop = $_REQUEST["shop"];
        $SpycredentialObj = Spycredential::fetchSpySingleData("store_domain", $shop);
        if(!empty($SpycredentialObj)){
            $seller_id = $SpycredentialObj->id;
            $seller_id_enc = Helper::encryptor('encrypt', $seller_id);
            $settingData = Spyreportsetting::fetchReportSettingData('seller_id', $seller_id);
            if(empty($settingData)){
                return redirect()->route('settings', array('shop' => $shop));
            } else {
                $settlementData = Spysummary::where("seller_id", $SpycredentialObj->id)->where('module', config('app.module'))->orderBy('invoice_date', 'desc')->limit(3)->get()->toArray();
                
                $requestedData = SpySummaryRequest::where('seller_id', $SpycredentialObj->id)->where('module', config('app.module'))->where('status','Pending')->first();
                if (empty($requestedData)) {
                    $requestedFlg = false;
                } else {
                    $requestedFlg = true;
                }

                return View::make('shopify/accountdetail')->with('shop', $shop)->with('seller_id', $seller_id)->with('settlementData', $settlementData)->with('seller_id_enc', $seller_id_enc)->with('requestedFlg', $requestedFlg);
            }
        }
    }

    public static function settings(Request $request){

        $shop = $_REQUEST["shop"];
        $SpycredentialObj = Spycredential::fetchSpySingleData("store_domain", $shop);

        if(!empty($SpycredentialObj)){
            $seller_id = $SpycredentialObj->id;
            $settingData = Spyreportsetting::fetchReportSettingData('seller_id', $seller_id);
            if(empty($settingData)){
                $settingData = new Spyreportsetting();
                $settingData->report_type = 'daily';
            }
            
            $enable = true;
            $settlementData = Spysummary::where("seller_id", $SpycredentialObj->id)->where('module', config('app.module'))->first();;
            if(!empty($settlementData)){
                $enable = false;
            }

            $syncMinDate = date('Y-m-d', strtotime('-60 day', strtotime('now')));

            return View::make('shopify/report_setting')->with('shop', $shop)->with('seller_id', $seller_id)->with('settingData', $settingData)->with('syncMinDate', $syncMinDate)->with('enable', $enable);
        }
    }

    public static function storeReportSetting(Request $request){

        $shop = $_REQUEST["shop"];
        $rule = array(
            'sync_start_date' => 'required',
        );
        $validator = Validator::make(Input::all(),$rule);
        
        if ($validator->fails()){
            return Redirect::route('settings',array('shop'=> $shop))->withInput(Input::all())->withErrors($validator);
        } else {
            $SpycredentialObj = Spycredential::fetchSpySingleData("store_domain", $shop);
            if(!empty($SpycredentialObj)){
                $settingData = Spyreportsetting::fetchReportSettingData('seller_id', $SpycredentialObj->id);
                if(empty($settingData)){
                    $settingData = new Spyreportsetting;
                    $settingData->seller_id = $SpycredentialObj->id;
                }
                $settingData->sync_start_date = $request->get('sync_start_date');
                $settingData->report_type = $request->get('report_type');
                $settingData->save();

                return redirect()->route('shopifyHome', array('shop' => $shop));

            } else {
                return redirect()->route('settings', array('shop' => $shop));
            }
        }
    }
    
    public function addSummaryRequest(Request $request)
    {
        $shop = $request->get('shop');
        $SpycredentialObj = Spycredential::fetchSpySingleData("store_domain", $shop);
        if($SpycredentialObj->status = 'Active'){
            $spysummaryreq = SpySummaryRequest::where('seller_id', $SpycredentialObj->id)->where('module', config('app.module'))->where('status', 'Pending')->first();        
            if (empty($spysummaryreq)) {
                $spysummaryreq = new SpySummaryRequest();
                $spysummaryreq->seller_id = $SpycredentialObj->id;
                $spysummaryreq->module = config('app.module');
                $spysummaryreq->created_at = date('Y-m-d H:i:s');
                $spysummaryreq->save();
            }

            //return redirect()->route('shopifyHome', array('shop' => $shop))->with('success','Your request has been submitted successfully!');
            return Response::json(array(
                'success' => true,
                'message' => "Request Saved successfully.",

            ), 200);
        }
    }

    public function processSummaryRequest(Request $request){

        $spysummaryrequest = SpySummaryRequest::fetchSpyRequestPending();
        if(!empty($spysummaryrequest)){
            foreach ($spysummaryrequest as $key => $value) {
                $spycredential = Spycredential::checkConnection($value['seller_id']);
                if(!empty($spycredential)){
                    $settingData = Spyreportsetting::fetchReportSettingData('seller_id', $value['seller_id']);
                    if(!empty($settingData)){
                        Spysummaryrequest::where('seller_id', $value['seller_id'])->where('module', $value['module'])->update(['status' => 'process']);
                        app('App\Http\Controllers\Ecomtoacc\Shopify\OrderController')->syncSummaryOrderData($spycredential['store_domain'],$spycredential,$settingData);
                        app('App\Http\Controllers\Ecomtoacc\Shopify\PayoutController')->syncPayoutData($spycredential['store_domain'],$spycredential,$settingData);
                        app('App\Http\Controllers\Ecomtoacc\Shopify\ReportController')->summaryReport($settingData,$spycredential);

                        Spysummaryrequest::where('seller_id', $value['seller_id'])->where('module', $value['module'])->delete();
                    }
                }
            }
        }

        echo "success";exit;
    }
}
