<?php

namespace App\Http\Controllers\Master\Sellers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Amazon\Azsellers;
use View;

class SellersController extends Controller
{
	public function index(Request $request){

		$sellersData = Sellers::listSellers();
    	return View::make('master/sellers/index')->with('sellersData', $sellersData);
    }

    public function addSeller(Request $request){

    	return View::make('master/sellers/add-seller');
    }

    public function getAccountingSystem(Request $request){
    	$marketplace = $request->get('marketplace');
        if(!empty($marketplace)){
          $accounting = config('integrations.app_integrations')[$marketplace]['accounting'];
          return View::make('master/sellers/accounting')->with('marketplace', $marketplace)->with('accounting', $accounting);
        } else {
          echo 'error';
        }
    }

    public function authenticateSeller(Request $request){

    	$marketplace = $request->get('marketplace');
    	$accounting = $request->get('accounting');
    	
    	return View::make('master/sellers/auth')->with('marketplace', $marketplace)->with('accounting', $accounting);
    }

    public function storesellerdetail(Request $request){

        $seller_id = Helper::encryptor('decrypt',$request->get('seller_id'));
        $sellerUpdateData['seller_name'] = $request->get('seller_name');
        $sellerData = Sellers::where('id',$seller_id)->first();
    
        Sellers::where('id',$seller_id)->update(['seller_name'=>$request->get('seller_name')]);
        if($sellerData->marketplace_name == 'tlaz'){
            Azsellers::where('id',$seller_id)->update($sellerUpdateData);
        }
        echo 'success';
        exit;
    }

}
