<?php

namespace App\Http\Controllers\Master\Payment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Master\SellerPlan;
use App\Models\Master\Plans;
use App\Models\Master\Billingdetailsint;
use View;
use Auth;

class SellerPlanController extends Controller
{
	public function getPlansIndex(Request $request){

		$seller_id_enc = $request->get('seller_id');
        $seller_id = Helper::encryptor('decrypt', $seller_id_enc);

        $sellerData = Sellers::getSellerData('id', $seller_id);
        if(!empty($sellerData)){
        	$change_plans = 0;
        	$selectedplan = ''; $selectedplanStatus = 'Active';
	        $check_plan = SellerPlan::getSellerPlan($seller_id);
	        
	        if(!empty($check_plan)){
				$selectedplan = $check_plan->plan_id;
				$selectedplanStatus = $check_plan->status;
				$change_plans = 1;
	        }

			$plans = Plans::getAppPlans('app_name', $sellerData->marketplace_name);

			$billingDetailsDb = Billingdetailsint::getUserwiseBillingDetailInfo(Auth::user()->id);
            if(isset($billingDetailsDb[0])){
                $billingDetailsexist = true;
            }else{
                $billingDetailsexist = false;
            }
            $askSellerInfo = false;
            if($sellerData->seller_name == ''){
                $askSellerInfo = true;
            }
            
            list($strip_key,$stripe_env) = $this->fetchStripeKeyCredential($seller_id);

            $country = $this->getCountry();
            $state = $this->getState();

			return view('master/plans/index')->with('seller_id',$seller_id_enc)->with('plans',$plans)->with('selectedplan',$selectedplan)->with('billingDetailsDb', $billingDetailsDb)->with('askSellerInfo', $askSellerInfo)->with('billingDetailsexist', $billingDetailsexist)->with('strip_key', $strip_key)->with('change_plans', $change_plans)->with('country', $country)->with('state', $state)->with('sellerinfo', $sellerData)->with('selectedplanStatus', $selectedplanStatus);
        } else {
        	return redirect()->route('sellers');
        }

    }

}
