<?php

namespace App\Http\Controllers\Ecomtoacc\Shopify;

use App\Http\Controllers\Controller;
use App\Models\Shopify\Spylastsync;
use App\Models\Shopify\Spycredential;
use App\Models\Shopify\Spysummaryorder;
use App\Models\Shopify\Spysummaryordersales;
use App\Models\Shopify\Spyordertransaction;
use App\Models\Shopify\Spysummarypayout;
use App\Models\Shopify\Spysummarypayouttransaction;
use App\Models\Shopify\Spysummaryrefund;
use App\Models\Shopify\Spysummaryreport;
use App\Models\Shopify\Spysummarycostreport;
use App\Models\Shopify\Spyreportsetting;
use App\Models\Shopify\Xerosummarycostjournals;
use App\Models\Shopify\SpySummary;
use Illuminate\Http\Request;
use App\Helpers\Helper;

class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    private $randomValue = 0;
    public function generateReports(Request $request){

        $seller_id = Helper::encryptor('decrypt', $request->get('seller_id'));
        $startdate = $request->get('startdate');
        $enddate = $request->get('enddate');
        $spyStoreDatas = Spycredential::fetchValidSpyStores($seller_id);
        
        $this->randomValue = rand(1111111111,9999999999);
        foreach ($spyStoreDatas as $key => $spyStoreData) {
            //$this->cronActionLog($seller_id, $module, 'Auto cron for fetch reports- START', $this->randomValue);

            $shop = $spyStoreData['store_domain'];
            /* $request = new Request();
            $request->initialize(['domain' => $domain]); */
            $spyConnected = Spycredential::checkConnection($spyStoreData->id);
            if(!empty($spyConnected)){
                $settingData = Spyreportsetting::fetchReportSettingData('seller_id', $spyStoreData->id);
                if(!empty($settingData)){
                    $this->summaryReport($settingData,$spyConnected,$startdate,$enddate);
                }
            }
           // $this->cronActionLog($seller_id, $module, 'Auto cron for fetch reports- END', $this->randomValue);
        }
        return 'success';
    }
    public function summaryReport($settingData,$spyConnected,$startdate="",$enddate="")
    {
        if (version_compare(phpversion(), '7.1', '>=')) {
            ini_set('precision', 10);
            ini_set('serialize_precision', 10);
        }
        ini_set('max_execution_time', 0);
       /*  $shop         = Helper::encryptor('decrypt', $request->get('domain'));
        $shopenc      = $request->get('domain'); */
        //$spyConnected = XeroCredential::checkXeroConnected('store_domain', $shop);
        
        if (!empty($spyConnected)) {
            $cogs_enable=(isset($settingData->cogs_enable))?$settingData->cogs_enable:"";
            $seller_id= Helper::encryptor('encrypt', $spyConnected['id']);
            $this->shopifyPayoutsReport($spyConnected, $settingData,10,$startdate,$enddate);
            $this->otherGatewayReport($spyConnected, $settingData,10,$startdate,$enddate);
            $this->transferReport($spyConnected['module'],$seller_id,"",$cogs_enable);
        }
    }
    public function shopifyPayoutsReport($spyConnected, $settingData,$reportCount,$startdate="",$enddate="",$reCalcParameters=[])
    {
        if (version_compare(phpversion(), '7.1', '>=')) {
            ini_set('precision', 10);
            ini_set('serialize_precision', 10);
        }
        ini_set('max_execution_time', 0);
        $orderReport = array();
        $payoutData  = Spysummarypayout::fetchUnsyncPayouts($spyConnected['id'],$spyConnected['module'],$reportCount,$startdate,$enddate,$reCalcParameters);
        
        if (!empty($payoutData)) {
            foreach ($payoutData as $key => $value) {
                $orderReport   = array();
                $orderIds      = array();
                $refundIds     = array();
                $payoutTransactions=array();
                $shopifyFee    = $this->calculateShopifyFee($value['summary']);
                //$update = Spysummarypayouttrns::updatePayoutAmount($spyConnected['id'],$spyConnected['module'], 'payout_id', $value['payout_id']);
                $payoutAllTrns = Spysummarypayouttransaction::fetchPayoutTransAll($spyConnected['id'],$spyConnected['module'], 'payout_id', $value['payout_id']);
                if (!empty($payoutAllTrns)) {
                    $last=last($payoutAllTrns);
                    $first=current($payoutAllTrns);
                   
                    foreach ($payoutAllTrns as $key1 => $value1) {
                       
                        $transaction_id = "";
                        $posted_date = date('Y-m', strtotime($value1['processed_at']));
                        $gateway= "";
                        $type="payout";
                        $date = app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createKey("",$type,$transaction_id,$posted_date,$gateway);

                        if (!isset($orderReport[$date]['total_amount'])) {
                            $orderReport[$date]['total_amount'] = 0;
                        }
                        $oldTransactions=array();
                        $orderReport[$date]['seller_id']         = $value['seller_id'];
                        $orderReport[$date]['module']         = $value['module'];
                        $orderReport[$date]['start_date']         = $first['processed_at'];
                        $orderReport[$date]['end_date']         = $last['processed_at'];
                        $orderReport[$date]['unique_id']        = $value['payout_id'];
                        $orderReport[$date]['posted_date']      = $value['date'];
                        $orderReport[$date]['transaction_type'] = 'Summary';
                        $orderReport[$date]['gateway']          = 'shopify_payments';
                        $orderReport[$date]['payout_amount']    = $value['amount'];
                        $orderReport[$date]['currency']         = $value['currency'];
                        $orderReport[$date]['settlement_month'] = $payoutMonth =$posted_date;
                        if (isset($orderReport[$date]['summary_details']['shopify_fee'])) {
                            $orderReport[$date]['summary_details']['shopify_fee'] -= $value1['fee'];
                        } else {
                            $orderReport[$date]['summary_details']['shopify_fee'] = $value1['fee'] *(-1);
                        }
                        $orderReport[$date]['total_amount'] += $value1['fee'] * (-1);
                        if ($date != date('Y-m', strtotime($value['date'])) ) {
                            $orderReport[$date]['posted_date'] = date('Y-m-t', strtotime($value1['processed_at']));
                        }
                        if(isset($payoutTransactions[$value1['order_id']][$value1['type']])){
                            $payoutTransactions[$value1['order_id']][$value1['type']]['amount']+=$value1['amount'];
                            $payoutTransactions[$value1['order_id']][$value1['type']]['sumAmount']+=$value1['sumAmount'];
                            $payoutTransactions[$value1['order_id']][$value1['type']]['net']+=$value1['net'];
                            $payoutTransactions[$value1['order_id']][$value1['type']]['fee']+=$value1['fee'];
                          
                            
                        }else{

                            $payoutTransactions[$value1['order_id']][$value1['type']]=$value1;
                        }
                        //pr($payoutTransactions);
                        if ($value1['type'] == 'charge') {

                            $pendingAmount=0;
                            //Spyordertransaction::where('seller_id', $spyConnected['id'])->where('transaction_id', $value1['order_transaction_id'])->update(['sync_flg' => 'Y']);
                            $syncorder = Spysummaryorder::fetchSyncedOrder($spyConnected['id'],$spyConnected['module'], $value1['order_id']);
                            if (!empty($syncorder)) {
                                $oldTransactions=Spyordertransaction::fetcholdTransactionData($spyConnected['id'],$spyConnected['module'],$value1['order_id'],$value1['order_transaction_id']);
                               # echo $value1['order_id']." = ".$value1['order_transaction_id'];

                                if (!empty($oldTransactions)) {
                                    if(isset($orderIds[$date]) && !in_array($value1['order_id'],$orderIds[$date])){
                                        #echo $value1['sumAmount']." - ".$value1['order_id']."<br>";
                                         $pendingAmount=$value1['sumAmount'];
                                         if (isset($orderReport[$date]['summary_details']['payment_pending'])) {
                                             $orderReport[$date]['summary_details']['payment_pending'] += $value1['sumAmount'];
                                         } else {
                                             $orderReport[$date]['summary_details']['payment_pending'] = $value1['sumAmount'];
                                         }

                                    }else if(!isset($orderIds[$date])){
                                        $pendingAmount=$value1['sumAmount'];
                                        if (isset($orderReport[$date]['summary_details']['payment_pending'])) {
                                            $orderReport[$date]['summary_details']['payment_pending'] += $value1['sumAmount'];
                                        } else {
                                            $orderReport[$date]['summary_details']['payment_pending'] = $value1['sumAmount'];
                                        }
                                    }

                                } else {
                                    $orderIds[$date][] = $value1['order_id'];
                                    /*if($syncorder['total_price'] >= $value1['sumAmount']){
                                    $amt = $syncorder['total_price'] - $value1['sumAmount'];
                                    }else{
                                    $amt = $value1['sumAmount'] - $syncorder['total_price'];
                                    }

                                    if ($value['sumAmount'] != $syncorder['total_price'] && $amt >= 0.05) {
                                       # echo -$amt." - ".$value1['order_id']."<br>";
                                        $pendingAmount= $amt * (-1);
                                        if (isset($orderReport[$date]['summary_details']['payment_pending'])) {
                                            $orderReport[$date]['summary_details']['payment_pending'] -= $amt;
                                        } else {
                                            $orderReport[$date]['summary_details']['payment_pending'] = $amt * -1;
                                        }

                                    }*/
                                }

                                if (isset($pendingAmount)) {
                                    $orderReport[$date]['total_amount'] += $pendingAmount;
                                }
                                if (isset($syncorder['taxes_included']) && $syncorder['taxes_included']==1) {
                                    $orderReport[$date]['taxes_included'] = "Inclusive";
                                }else{
                                    $orderReport[$date]['taxes_included'] = "Exclusive";
                                }
                    
                            }

                        } elseif ($value1['type'] == 'refund') {
                            $refundIds[$date][] = $value1['order_transaction_id'];
                        } elseif ($value1['type'] == 'dispute') {
                            if (isset($orderReport['payout_dispute']) && !empty($orderReport['payout_dispute'])) {
                                $orderReport[$date]['summary_details']['payout_dispute'] += $value1['sumAmount'];
                            } else {
                                $orderReport[$date]['summary_details']['payout_dispute'] = $value1['sumAmount'];
                            }
                            $orderReport[$date]['total_amount'] += $value1['sumAmount'];

                        } elseif ($value1['type'] == 'reserve') {
                            if (isset($orderReport['payout_reserve']) && !empty($orderReport['payout_reserve'])) {
                                $orderReport[$date]['summary_details']['payout_reserve'] += $value1['sumAmount'];
                            } else {
                                $orderReport[$date]['summary_details']['payout_reserve'] = $value1['sumAmount'];
                            }
                            $orderReport[$date]['total_amount'] += $value1['sumAmount'];
                        } elseif ($value1['type'] == 'payout_cancellation') {
                            if (isset($orderReport[$date]['summary_details']['payout_cancellation']) && !empty($orderReport['payout_cancellation'])) {
                                $orderReport[$date]['summary_details']['payout_cancellation'] += $value1['sumAmount'];
                            } else {
                                $orderReport[$date]['summary_details']['payout_cancellation'] = $value1['sumAmount'];
                            }
                            $orderReport[$date]['total_amount'] += $value1['sumAmount'];
                        } elseif ($value1['type'] == 'adjustment' || $value1['source_type'] == 'adjustment') {
                            if (isset($orderReport[$date]['summary_details']['adjustment']) && !empty($orderReport['adjustment'])) {
                                $orderReport[$date]['summary_details']['adjustment'] += $value1['sumAmount'];
                            } else {
                                $orderReport[$date]['summary_details']['adjustment'] = $value1['sumAmount'];
                            }
                            $orderReport[$date]['total_amount'] += $value1['sumAmount'];
                        }

                    }
                    #pr($orderReport,1);
                    # pr($orderIds,1);
                    if (!empty($orderIds)) {
                        foreach ($orderIds as $orderKey => $orderValue) {
                            $orderReport[$orderKey]['total_transactions'] = count($orderValue);
                            $orderData                                    = Spysummaryorder::fetchOrdersCountByOrderId($spyConnected['id'],$spyConnected['module'], $orderValue);
                            $cogs_enable=(isset($settingData->cogs_enable))?$settingData->cogs_enable:"";
                            $this->formatOrderData($orderData, $orderReport, $orderKey,$payoutTransactions,$spyConnected['module'],$cogs_enable,$spyConnected);
                            //Spysummaryorder::where('seller_id', $spyConnected['id'],$spyConnected['module'])->whereIn('order_id', $orderValue)->update(['sync_flg' => 'Y']);
                            $orderData                                                                 = array();
                            $orderReport[$orderKey]['summary_details']['currency_conversion_rounding'] = null;
                            $orderData                                                                 = Spysummaryorder::fetchCurrencyConversionByOrderIds($spyConnected['id'],$spyConnected['module'], $orderValue);
                            if (!empty($orderData)) {
                                foreach ($orderData as $valuecur) {
                                    $orderReport[$orderKey]['total_amount'] += $valuecur['amount'];
                                }
                                $orderReport[$orderKey]['summary_details']['currency_conversion_rounding'] = $orderData;
                            }
                        }

                    }
                    if (!empty($refundIds)) {
                        foreach ($refundIds as $refKey => $refValue) {
                            $orderRefundData = Spysummaryrefund::fetchRefundCountByOrderId($spyConnected['id'],$spyConnected['module'], $refValue);
                            $cogs_enable=(isset($settingData->cogs_enable))?$settingData->cogs_enable:"";
                            $orderRefundData = $this->formatRefundData($orderRefundData, $orderReport, $refKey,$cogs_enable,$spyConnected);
                            $refundData      = array();
                            $refundData      = Spysummaryrefund::fetchCurrencyConversionByRefundIds($spyConnected['id'],$spyConnected['module'], $refValue);
                            if (!empty($refundData)) {
                                foreach ($refundData as $valuecur) {
                                    $orderReport[$orderKey]['total_amount'] += $valuecur['amount'];
                                }

                                $orderReport[$orderKey]['summary_details']['refund_currency_conversion_rounding'] = $refundData;
                            }
                        }
                    }
                        $i=1;
                        $preKey="";
                        $totalOrderReport=count($orderReport);
                        foreach($orderReport as $reskey => $resval){
                            if ($settingData->prefix_required == 'Y') {
                                $document_number = $settingData->prefix . '_' . $orderReport[$reskey]['unique_id'];
                            } else {
                                $document_number = $orderReport[$reskey]['unique_id'];
                            }
                            if($totalOrderReport > 1){
                                $document_number = $document_number.'-'.$i;
                                $preKey= app('App\Http\Controllers\Ecomtoacc\Shopify\ApiController')::getPrevKey($reskey, $orderReport); 
                                    
                                $preArrayCarryAmount=(isset($orderReport[$preKey]['summary_details']['carry_forward_to_next_month']))?$orderReport[$preKey]['summary_details']['carry_forward_to_next_month']:0;
                                
                                $payoutAmount=$resval['total_amount']*(-1);
                                if($i!=1){
                                    $orderReport[$reskey]['summary_details']
                                    ['carry_forward_from_previous_month'] =$preArrayCarryAmount*(-1);
                                }
                                
                                $total_carry_forward_to_next_month=$preArrayCarryAmount+$payoutAmount;
                                $carray_total_amount=$total_carry_forward_to_next_month*(-1);
                                if($totalOrderReport==$i){
                                    $orderReport[$reskey]['total_amount'] =$carray_total_amount;
                                 
                                }else{
                                    $orderReport[$reskey]['summary_details']['carry_forward_to_next_month'] =$total_carry_forward_to_next_month;
                                    $orderReport[$reskey]['total_amount'] =$carray_total_amount+$total_carry_forward_to_next_month;
                                }
                                $i++;
                            }
                            $orderReport[$reskey]['document_number']    = $document_number;

                    }
                    $orderReportAll[$value['payout_id']] = $orderReport;
                }
            }
            //pr($orderReportAll,1);

            if (!empty($orderReportAll)) {
                Spysummaryreport::savereportData($orderReportAll,'payout',$settingData,"report",$reCalcParameters,$first['processed_at'],$last['processed_at']);
            }
        }
    }
    public function otherGatewayReport($spyConnected, $settingData,$days,$startdate,$enddate)
    {
        $reportKey=[];
        for($i=0;$i<$days;$i++)
        {
            $this->otherOrdersReport($reportKey,$spyConnected, $settingData,$startdate,$enddate);
        }
    }
    public function otherOrdersReport(&$reportKey,$spyConnected, $settingData,$startdate,$enddate,$reCalcParameters=[])
    {
        $transactionId=(isset($reCalcParameters['transactionId']))?$reCalcParameters['transactionId']:"";
        $posted_date=(isset($reCalcParameters['posted_date']))?$reCalcParameters['posted_date']:"";
        $seller_id        = $spyConnected['id'];
        $module        = $spyConnected['module'];
        $report_type        = (isset($settingData->report_type))?$settingData->report_type:"";
        
        $betweenDate=false;
        $spyFirstsyncdata = Spylastsync::fetchReportStart($seller_id,$module);

        if(!empty($posted_date)){
            $reportstartdate=$posted_date;
        }else if (!empty($startdate) && !empty($enddate)) {
            $reportstartdate =$startdate;
            $betweenDate=true;
        }else if (!empty($spyFirstsyncdata->report_date)) {
            $reportstartdate =$spyFirstsyncdata->report_date;
        } else {
            $reportstartdate = $settingData->sync_start_date;
        }
        
        if ($report_type == "monthly") {
            $reportenddate =    (!empty($startdate) && !empty($enddate))? $enddate:\Carbon\Carbon::parse($reportstartdate)->endOfMonth()->toDateString() . " 23:59:59";
        } else {
            $reportenddate = (!empty($startdate) && !empty($enddate))? $enddate:$reportstartdate." 23:59:59";
        }
        
        $gatwayOrders1 = $orderIds = $transIds = array();
        $gatwayOrders  = Spysummaryorder::fetchUnsyncgatewayorder($seller_id,$module, $reportstartdate,$reportenddate,$report_type,$reCalcParameters);
        
        if(empty($gatwayOrders)){
            Spylastsync::updateSyncStartDate($reportstartdate,$seller_id,$module,$report_type);
        }
        foreach ($gatwayOrders as $key => $orderData) {
            $transaction_id = $orderData['transaction_id'];
            $posted_date = date('Y-m-d', strtotime($orderData['transaction_date']));
            $gateway=$this->getGateway($orderData['transaction_gateway']);
            $type="other";
           
            $date = app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createKey($settingData,$type,
            $transaction_id,$posted_date,$gateway,$reCalcParameters);
            
            if(in_array($date, $reportKey) && empty($reCalcParameters) && empty($startdate) && empty($enddate)){
                return true; //If match then do not process further
            }

            if(!isset($orderReport[$date]))
            $orderReport[$date]= array();
            $orderReport= app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createReportHeader($orderReport,$orderData,$settingData,$gateway,$date,$posted_date,$transaction_id,$reCalcParameters);
            $this->getStartEndDates($orderReport,$date,$reportstartdate,$reportenddate,$posted_date,$report_type,$betweenDate);
            $orderReport[$date]['module'] = $module;

           if (!isset($orderReport[$date]['total_amount'])) {
            $orderReport[$date]['total_amount'] = 0;
            }
            if (!isset($orderReport[$date]['total_transactions'])) {
                $orderReport[$date]['total_transactions'] = 1;
            }
            else{
                $orderReport[$date]['total_transactions'] += 1;
            }
            if (isset($orderData['taxes_included']) && $orderData['taxes_included']==1) {
                $orderReport[$date]['taxes_included'] = "Inclusive";
            }else{
                $orderReport[$date]['taxes_included'] = "Exclusive";
            }

            $orderIds[$date][]=$orderData['order_id']; 
          
            $paymentAmount = 0;
          
            $paymentData = Spyordertransaction::fetchTransactionData('order_id', $orderData['order_id'], $seller_id, $module,$orderData['transaction_id']);
            if (!empty($paymentData) || $orderData['transaction_id'] == $orderData['order_id']) {
                if(empty($paymentData)){
                    $paymentData['currency']=$paymentData['order_id']=$paymentData['id']="";
                    $paymentData['amount']=0;
                }
                $countOrderTransaction=Spyordertransaction::fetchTransactionDataCount($seller_id,$module, $orderData['order_id']);

                $oldTransactions=Spyordertransaction::fetcholdTransactionData($seller_id,$module, $orderData['order_id'],$orderData['transaction_id']);
               if(!empty($oldTransactions))
               {
                    if (isset($orderReport[$date]['summary_details']['payment_pending'])) {
                        $orderReport[$date]['summary_details']['payment_pending'] += $paymentData['amount'];
                    } else {
                        $orderReport[$date]['summary_details']['payment_pending'] = $paymentData['amount'];
                    }
                    $orderReport[$date]['total_amount'] +=$paymentData['amount'];
                }
                else
                {   
                  
                    if($orderData['currency'] == $paymentData['currency']){
                        $paymentAmount+=$paymentData['amount'];
                    }else{
                        if(!empty($paymentData['exchange_rate'])){
                            $paymentAmount+=$paymentData['amount']*$paymentData['exchange_rate'];
                        }else if(!empty($orderData['financial_status']) && $orderData['financial_status']=="paid" && $countOrderTransaction==1){
                            $paymentAmount+=$orderData['current_total_price'];
                        }else{
                            $transaction_date = date('Y-m-d', strtotime($orderData['transaction_date']));
                            $exchange_rate=getExchangeRateApi($settingData,$transaction_date,$orderData['currency'],$paymentData['currency'],$paymentData['order_id']);
                            $paymentAmount+=(double)$paymentData['amount']*(double)$exchange_rate;
                        }
                    }
                    $ordersArray[$date][]=$orderData;
                    $payoutTransactions[$orderData['order_id']]['charge']['sumAmount']= $paymentAmount;
                    
               }
               $transIds[]=$paymentData['id']; 
               //$orderReport[$date]['reference'] = (isset($paymentData['reference']))?$paymentData['reference']:"";

                #echo $orderData['order_id']." - ".$orderData['total_price']." - ".$paymentAmount." - ".($orderData['total_price']-$paymentAmount)."<br>";
            }
            #echo $orderData['order_id']."<br>";
        }
        if(!empty($ordersArray)){
            $cogs_enable=(isset($settingData->cogs_enable))?$settingData->cogs_enable:"";
            foreach($ordersArray as $key=>$orders)
            $this->formatOrderData($orders, $orderReport, $key,$payoutTransactions,$spyConnected['module'],$cogs_enable,$spyConnected);
        }
        //pr($orderReport,1);
        $order_id=(isset($orderData['order_id']))?$orderData['order_id']:"";
        $remainsPayment = Spyordertransaction::fetchRemainingTransactionData($seller_id,$module,$reportstartdate,$reportenddate,$transIds,$report_type,$reCalcParameters,$order_id);
        
        if(!empty($remainsPayment) ){
            foreach ($remainsPayment as $remainspay) {
                $transaction_id = $remainspay['transaction_id'];
                $posted_date = date('Y-m-d', strtotime($remainspay['transaction_created_at']));
                $gateway=$this->getGateway($remainspay['gateway']);
                $type="other";
                $date = app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createKey($settingData,$type,$transaction_id,$posted_date,$gateway,$reCalcParameters);
                if(in_array($date, $reportKey) && empty($reCalcParameters) && empty($startdate) && empty($enddate)){
                    return true; //If match then do not process further
                }
                if(!isset($orderReport[$date]))
                $orderReport[$date]= array();
                $this->getStartEndDates($orderReport,$date,$reportstartdate,$reportenddate,$posted_date,$report_type,$betweenDate);
                $orderReport= app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createReportHeader($orderReport,$remainspay,$settingData,$gateway,$date,$posted_date,$transaction_id,$reCalcParameters);

                if (!isset($orderReport[$date]['total_transactions'])) {
                    $orderReport[$date]['total_transactions'] = 1;
                }
                else{

                    $orderReport[$date]['total_transactions'] += 1;
                }
                $transIds[]=$remainspay['id'];

                $paymentAmount = $remainspay['amount'];
                if(!is_null($remainspay['exchange_rate']))
                    $paymentAmount = $remainspay['amount']*$remainspay['exchange_rate'];

                if (isset($orderReport[$date]['summary_details']['payment_pending'])) {
                    $orderReport[$date]['summary_details']['payment_pending'] += $paymentAmount;
                } else {
                    $orderReport[$date]['summary_details']['payment_pending'] = $paymentAmount;
                }
                $orderReport[$date]['total_amount'] += $paymentAmount;
            }
        }
        #pr($orderReport,1);
       
        $gatewayRefunds = Spysummaryrefund::fetchRefundOthergateway($seller_id,$module,$reportstartdate,$reportenddate,$report_type,$reCalcParameters);
        #pr($gatewayRefunds,1);
        if(!empty($gatewayRefunds)){
            foreach ($gatewayRefunds as $refunds) {
                $transaction_id = $refunds['refund_transaction_id'];
                $posted_date = date('Y-m-d', strtotime($refunds['processed_at']));
                $gateway=$this->getGateway($refunds['gateway']);
                $type="other";
                $date = app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createKey($settingData,$type,$transaction_id,$posted_date,$gateway,$reCalcParameters);
                if(in_array($date, $reportKey) && empty($reCalcParameters) && empty($startdate) && empty($enddate)){
                    return true; //If match then do not process further
                }
                if(!isset($orderReport[$date]))
                $orderReport[$date]= array();
                $orderReport[$date]['module'] = $module;
                $this->getStartEndDates($orderReport,$date,$reportstartdate,$reportenddate,$posted_date,$report_type,$betweenDate);
                $orderReport= app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createReportHeader($orderReport,$refunds,$settingData,$gateway,$date,$posted_date,$transaction_id,$reCalcParameters);
               
                if (!isset($orderReport[$date]['total_transactions'])) {
                    $orderReport[$date]['total_transactions'] = 1;
                }
                else{
                    $orderReport[$date]['total_transactions'] += 1;
                }
                $refundArray[$date][]=$refunds;
            }
            $cogs_enable=(isset($settingData->cogs_enable))?$settingData->cogs_enable:"";
            foreach($refundArray as $key=>$refund)
            $this->formatRefundData($refund, $orderReport, $key,$cogs_enable,$spyConnected);
        }
        //pr($orderReport,1);
        if (!empty($orderReport)) {
            $reportKey=array_merge($reportKey,array_keys($orderReport));
            Spysummaryreport::savereportData($orderReport, 'other',$settingData,"report",$reCalcParameters,$reportstartdate,$reportenddate,$report_type);
        }
    }
    public function calculateShopifyFee($summary)
    {
        $summary   = json_decode($summary, true);
        $feeAmoutn = $summary['charges_fee_amount'] + $summary['adjustments_fee_amount'] + $summary['refunds_fee_amount'] + $summary['reserved_funds_fee_amount'] + $summary['retried_payouts_fee_amount'];
        return $feeAmoutn;
    }
    public function formatOrderData($orderData, &$orderReport, $date,$payoutTransactions,$module="xosp",$cogs_enable,$spyConnected)
    {
        $salesData=$costData= array();
        $sum=$costCount=0;
        $orderReport[$date]['summary_details']['total_sale']         = 0;
        $orderReport[$date]['summary_details']['total_tax']          = 0;
        $orderReport[$date]['summary_details']['total_shipping']     = 0;
        $orderReport[$date]['summary_details']['total_shipping_tax'] = 0;
        $orderReport[$date]['summary_details']['total_tip_received'] = 0;
        $orderReport[$date]['summary_details']['total_discounts']    = 0;
        $orderReport[$date]['summary_details']['total_giftcard']     = 0;
        $orderReport[$date]['summary_details']['total_duties']       = 0;
        $orderReport[$date]['summary_details']['total_duties_tax']   = 0;

        foreach ($orderData as $key => $value) {
            if ($value['taxes_included'] == 1) {
                #$lineprice     = $value['total_line_items_price'] - $value['total_tax'];
                #$shippingprice = $value['total_shipping'] - $value['total_shipping_tax'];
                $totalsumtax = 0;
            } else {
                #$lineprice     = $value['total_line_items_price'];
                #$shippingprice = $value['total_shipping'];
                $totalsumtax = $value['total_tax'] + $value['total_shipping_tax']; 
            }
            
            $lineprice     = $value['total_line_items_price'];
            $shippingprice = $value['total_shipping'];

            $orderReport[$date]['summary_details']['total_sale']         = $orderReport[$date]['summary_details']['total_sale'] + $lineprice;
            $orderReport[$date]['summary_details']['total_tax']          = $orderReport[$date]['summary_details']['total_tax'] + $value['total_tax'];
            $orderReport[$date]['summary_details']['total_shipping']     = $orderReport[$date]['summary_details']['total_shipping'] + $shippingprice;
            $orderReport[$date]['summary_details']['total_shipping_tax'] = $orderReport[$date]['summary_details']['total_shipping_tax'] + $value['total_shipping_tax'];
            $orderReport[$date]['summary_details']['total_tip_received'] = $orderReport[$date]['summary_details']['total_tip_received'] + $value['total_tip_received'];
            $orderReport[$date]['summary_details']['total_discounts']    = $orderReport[$date]['summary_details']['total_discounts'] - $value['total_discounts'];
            $orderReport[$date]['summary_details']['total_giftcard']     = $orderReport[$date]['summary_details']['total_giftcard'] + $value['total_giftcard'];
            $orderReport[$date]['summary_details']['total_duties']       = $orderReport[$date]['summary_details']['total_duties'] + $value['total_duties'];
            $orderReport[$date]['summary_details']['total_duties_tax']   = $orderReport[$date]['summary_details']['total_duties_tax'] + $value['total_duties_tax'];

            #$orderReport[$date]['total_amount'] += ($lineprice + $totalsumtax + $shippingprice  + $value['total_tip_received'] + ($value['total_discounts'] * -1) + $value['total_giftcard'] + $value['total_duties'] + $value['total_duties_tax']);

            if (isset($value['sales_data']) && !empty($value['sales_data'])) {
                $ordersales     = 0;
                $ordershipping  = 0;
                $orderdiscount = 0;
                $shippingdiscount=0;
                $salestax=0;
                $shippingtax=0;
                $dutiesamount=0;
                $dutiestax=0;
                $data = json_decode($value['sales_data'], true);
                foreach ($data as $key1 => $value1) {
                    $linesale =0;
                    $shippingsaleprice = 0;
                    $taxKey = app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createTaxKey($spyConnected,$value,$key1);

                   
                        if ($value['taxes_included'] == 1) {
                            if(isset($value1['order']['amount']))
                            $ordersales     += $value1['order']['amount'];
                            if(isset($value1['shipping']['amount']))
                            $ordershipping  += $value1['shipping']['amount'];
                        } else {

                            if(isset($value1['order']['amount']))
                            $ordersales     += $value1['order']['amount'] + $value1['order']['tax'];
                            if(isset($value1['shipping']['amount']))

                            $ordershipping  += $value1['shipping']['amount'] + $value1['shipping']['tax'];
                            
                        }


                        if(isset($value1['order']['amount']))
                        $linesale     = $value1['order']['amount'];
                        if(isset($value1['shipping']['amount']))
                        $shippingsaleprice = $value1['shipping']['amount'];

                        if(isset($value1['order']['discount']))
                        $orderdiscount  += $value1['order']['discount'];
                        if(isset($value1['shipping']['discount']))
                        $shippingdiscount  += $value1['shipping']['discount'];
                         if(isset($value1['order']['tax']))
                        $salestax  += $value1['order']['tax'];
                        if(isset($value1['shipping']['tax']))
                        $shippingtax  += $value1['shipping']['tax'];
                        if(isset($value1['duties']['amount']))
                        $dutiesamount +=$value1['duties']['amount'];
                        if(isset($value1['duties']['tax']))
                        $dutiestax +=$value1['duties']['tax'];

                    if (isset($value1['order'])) {
                        (!isset($salesData[$taxKey]['order']['amount'])) ?
                        $salesData[$taxKey]['order']['amount'] = $linesale :
                        $salesData[$taxKey]['order']['amount'] += $linesale;
                        (!isset($salesData[$taxKey]['order']['tax'])) ?
                        $salesData[$taxKey]['order']['tax'] = $value1['order']['tax'] :
                        $salesData[$taxKey]['order']['tax'] += $value1['order']['tax'];
                        (!isset($salesData[$taxKey]['order']['discount'])) ?
                        $salesData[$taxKey]['order']['discount'] = $value1['order']['discount'] *(-1) :
                        $salesData[$taxKey]['order']['discount'] -= $value1['order']['discount'];
                    }

                    if (isset($value1['shipping'])) {
                        (!isset($salesData[$taxKey]['shipping']['amount'])) ?
                        $salesData[$taxKey]['shipping']['amount'] = $shippingsaleprice :
                        $salesData[$taxKey]['shipping']['amount'] += $shippingsaleprice;
                        (!isset($salesData[$taxKey]['shipping']['tax'])) ?
                        $salesData[$taxKey]['shipping']['tax'] = $value1['shipping']['tax'] :
                        $salesData[$taxKey]['shipping']['tax'] += $value1['shipping']['tax'];
                        (!isset($salesData[$taxKey]['shipping']['discount'])) ?
                        $salesData[$taxKey]['shipping']['discount'] = $value1['shipping']['discount'] *(-1):
                        $salesData[$taxKey]['shipping']['discount'] -= $value1['shipping']['discount'];
                    }

                    if (isset($value1['duties'])) {
                        (!isset($salesData[$taxKey]['duties']['amount'])) ?
                        $salesData[$taxKey]['duties']['amount'] = $value1['duties']['amount'] :
                        $salesData[$taxKey]['duties']['amount'] += $value1['duties']['amount'];
                        (!isset($salesData[$taxKey]['duties']['tax'])) ?
                        $salesData[$taxKey]['duties']['tax'] = $value1['duties']['tax'] :
                        $salesData[$taxKey]['duties']['tax'] += $value1['duties']['tax'];

                    }
                }

                $sale_history = new Spysummaryordersales();
                $sale_history->module = $module;
                $sale_history->spy_order_id = $value['id'];
                $sale_history->order_id = $value['order_id'];
                $sale_history->seller_id = $value['seller_id'];
                $sale_history->sales = $ordersales;
                $sale_history->sales_tax = $salestax;
                $sale_history->sales_discount = $orderdiscount;
                $sale_history->shipping = $ordershipping;
                $sale_history->shipping_tax = $shippingtax;
                $sale_history->shipping_discount = $shippingdiscount;
                $sale_history->duties = $dutiesamount;
                $sale_history->duties_tax = $dutiestax;
                $sale_history->sales_data = $value['sales_data'];
                $sale_history->save();


                $total_order_sale = $ordersales+$ordershipping-$orderdiscount-$shippingdiscount+$value['total_giftcard'] + $value['total_duties'] + $value['total_duties_tax'] + $value['total_tip_received'];
               $orderReport[$date]['total_amount'] += $total_order_sale;
              
                if($payoutTransactions[$value['order_id']]['charge']['sumAmount'] > $total_order_sale)
                $amt = $payoutTransactions[$value['order_id']]['charge']['sumAmount'] - $total_order_sale;
                else
                $amt = $total_order_sale - $payoutTransactions[$value['order_id']]['charge']['sumAmount'];
                $amt = number_format($amt,4,".","");
                if($payoutTransactions[$value['order_id']]['charge']['sumAmount'] != $total_order_sale/*  && $amt >= 0.05 */)
                {
                    
		    if($payoutTransactions[$value['order_id']]['charge']['sumAmount'] > $total_order_sale)
                    $pendingAmount =  $amt ;
		    else
		    $pendingAmount =  $amt = $amt *(-1);

        #echo $value['order_id']." - ".$pendingAmount." - ".$payoutTransactions[$value['order_id']]['charge']['sumAmount']." - ".$total_order_sale."<br>";

		    #echo $pendingAmount." - ".$value['order_id']."<br>";
                    if (isset($orderReport[$date]['summary_details']['payment_pending'])) {
                        $orderReport[$date]['summary_details']['payment_pending'] += $amt;
                    } else {
                        $orderReport[$date]['summary_details']['payment_pending'] = $amt;
                    }
                    $orderReport[$date]['total_amount'] += $pendingAmount;

                }

            }
            
            if (isset($value['cost_data']) && !empty($value['cost_data']) && $cogs_enable=="Yes") {
                $cost=json_decode($value['cost_data']);
                $productCost =  (array) $cost;
                
                foreach ($productCost as $key => $value) {
                    $sum+=$value;
                    $costCount++;
                    //$costData['Amount1'][]=$value;
                }
                $costData['description']= "Shopify";
                $costData['Amount']=$sum;
                $orderReport[$date]['total_cost_amount'] = $sum;
                $orderReport[$date]['total_cost_transactions'] = $costCount;
            }
        }
        if(!empty($costData))
        $orderReport[$date]['summary_details']['costData'] = $costData;
        $orderReport[$date]['summary_details']['salesData'] = $salesData;
    }
    public function formatRefundData($orderData, &$orderReport, $date,$cogs_enable,$spyConnected)
    {
        $sum=$costCount=0;
        $salesData =$refundData= array();
        $orderReport[$date]['summary_details']['total_refund']                 = 0;
        $orderReport[$date]['summary_details']['total_refund_tax']             = 0;
        $orderReport[$date]['summary_details']['total_refund_shipping']        = 0;
        $orderReport[$date]['summary_details']['total_refund_shipping_tax']    = 0;
        $orderReport[$date]['summary_details']['total_refund_discrepancy']     = 0;
        $orderReport[$date]['summary_details']['total_refund_discrepancy_tax'] = 0;
        $orderReport[$date]['summary_details']['total_refund_giftcard']        = 0;

        foreach ($orderData as $key => $value) {
            $lineprice =0;
            $shippingprice =0;
            
            if ($value['taxes_included'] == 1) {
                $lineprice     = $value['total_refund'];
                #$lineprice     = $value['total_refund'] - $value['total_refund_tax'];
                $shippingprice = $value['total_refund_shipping'] + $value['total_refund_shipping_tax'];
                $sumtax=0;
            } else {
                $lineprice     = $value['total_refund'];
                //$lineprice     = $value['total_refund'] - $value['total_refund_tax'];
                $shippingprice = $value['total_refund_shipping'];
                $sumtax=$value['total_refund_tax']+ $value['total_refund_shipping_tax'];
            }
            #$lineprice     = $value['total_refund'];
            $adjprice      = $value['total_refund_discrepancy'];

            $orderReport[$date]['summary_details']['total_refund']                 = $orderReport[$date]['summary_details']['total_refund'] - $lineprice;
            $orderReport[$date]['summary_details']['total_refund_tax']             = $orderReport[$date]['summary_details']['total_refund_tax'] - $value['total_refund_tax'];
            $orderReport[$date]['summary_details']['total_refund_shipping']        = $orderReport[$date]['summary_details']['total_refund_shipping'] - $shippingprice;
            $orderReport[$date]['summary_details']['total_refund_shipping_tax']    = $orderReport[$date]['summary_details']['total_refund_shipping_tax'] - $value['total_refund_shipping_tax'];
            $orderReport[$date]['summary_details']['total_refund_discrepancy']     = $orderReport[$date]['summary_details']['total_refund_discrepancy'] - $adjprice;
            $orderReport[$date]['summary_details']['total_refund_discrepancy_tax'] = $orderReport[$date]['summary_details']['total_refund_discrepancy_tax'] - $value['total_refund_discrepancy_tax'];
            $orderReport[$date]['summary_details']['total_refund_giftcard']        +=  $value['total_refund_giftcard'];

            if(!empty($orderReport[$date]['total_amount']))
                $orderReport[$date]['total_amount'] -= ($lineprice + $sumtax + $shippingprice  + $adjprice + $value['total_refund_discrepancy_tax'] + ($value['total_refund_giftcard'] * -1));
            else{
                
                $orderReport[$date]['total_amount'] = ($lineprice + $sumtax + $shippingprice + $adjprice + $value['total_refund_discrepancy_tax'] + ($value['total_refund_giftcard'] * -1));
                if($orderReport[$date]['total_amount']!=0){
                    $orderReport[$date]['total_amount'] = $orderReport[$date]['total_amount']*(-1);
                }
            }


            if (isset($value['sales_data']) && !empty($value['sales_data'])) {
                $data = json_decode($value['sales_data'], true);
                foreach ($data as $key1 => $value1) {

                    $linesale     =0;
                    $shiprefund     =0;
                    $taxKey = app('App\Http\Controllers\Ecomtoacc\Shopify\CustomDataController')->createTaxKey($spyConnected,$value,$key1);

                     if ($value['taxes_included'] == 1) {
                            if(isset($value1['refund']['amount']))
                            $linesale     = $value1['refund']['amount'];
                            if(isset($value1['refund_shipping']['amount']))
                            $shiprefund     = $value1['refund_shipping']['amount'] + $value1['refund_shipping']['tax'];
                        } else {
                            
                            if(isset($value1['refund']['amount']))
                            $linesale     = $value1['refund']['amount'] - $value1['refund']['tax'];
                            if(isset($value1['refund_shipping']['amount']))
                            $shiprefund     = $value1['refund_shipping']['amount'];
                        }
                      

                    if (isset($value1['refund'])) {
                        (!isset($salesData[$taxKey]['refund']['amount'])) ?
                        $salesData[$taxKey]['refund']['amount'] = $linesale *(-1) :
                        $salesData[$taxKey]['refund']['amount'] -= $linesale;

                        (!isset($salesData[$taxKey]['refund']['tax'])) ?
                        $salesData[$taxKey]['refund']['tax'] = $value1['refund']['tax'] *(-1):
                        $salesData[$taxKey]['refund']['tax'] -= $value1['refund']['tax'];
                    }

                    if (isset($value1['refund_discrepancy'])) {
                        (!isset($salesData[$taxKey]['refund_discrepancy']['amount'])) ?
                        $salesData[$taxKey]['refund_discrepancy']['amount'] = $value1['refund_discrepancy']['amount'] *(-1):
                        $salesData[$taxKey]['refund_discrepancy']['amount'] -= $value1['refund_discrepancy']['amount'];

                        (!isset($salesData[$taxKey]['refund_discrepancy']['tax'])) ?
                        $salesData[$taxKey]['refund_discrepancy']['tax'] = $value1['refund_discrepancy']['tax'] *(-1):
                        $salesData[$taxKey]['refund_discrepancy']['tax'] -= $value1['refund_discrepancy']['tax'];
                    }

                    if (isset($value1['refund_shipping'])) {
                        (!isset($salesData[$taxKey]['refund_shipping']['amount'])) ?
                        $salesData[$taxKey]['refund_shipping']['amount'] = $shiprefund *(-1):
                        $salesData[$taxKey]['refund_shipping']['amount'] -= $shiprefund;

                        (!isset($salesData[$taxKey]['refund_shipping']['tax'])) ?
                        $salesData[$taxKey]['refund_shipping']['tax'] = $value1['refund_shipping']['tax']*(-1) :
                        $salesData[$taxKey]['refund_shipping']['tax'] -= $value1['refund_shipping']['tax'];
                    }
                }
            }
            if (isset($value['cost_data']) && !empty($value['cost_data']) && $cogs_enable=="Yes") {
                $cost=json_decode($value['cost_data']);
                $productCost =  (array) $cost;
                
                foreach ($productCost as $key => $value) {
                    $sum+=$value;
                    $costCount++;
                    //$refundData['Amount1'][]=$value;
                }
                $refundData['description']= "Shopify";
                $refundData['Amount']=$sum;
                if(isset($orderReport[$date]['total_cost_amount'])){
                    $orderReport[$date]['total_cost_amount'] -= $sum;
                }else{
                    $orderReport[$date]['total_cost_amount'] = $sum;
                }

                if(isset($orderReport[$date]['total_cost_transactions'])){
                    $orderReport[$date]['total_cost_transactions'] += $costCount;
                }else{
                    $orderReport[$date]['total_cost_transactions'] = $costCount;
                }
            }
        }
        if(!empty($refundData))
        $orderReport[$date]['summary_details']['costrefundData'] = $refundData;
        $orderReport[$date]['summary_details']['refundData'] = $salesData;
    }
    public function formatOrderDataInd($orderData, &$orderReport, $date)
    {
        if ($orderData['taxes_included'] == 1) {
            $lineprice     = $orderData['total_line_items_price'] - $orderData['total_tax'];
            $shippingprice = $orderData['total_shipping'] - $orderData['total_shipping_tax'];
        } else {
            $lineprice     = $orderData['total_line_items_price'];
            $shippingprice = $orderData['total_shipping'];
        }

        if (isset($orderReport[$date]['summary_details']['total_sale'])) {
            $orderReport[$date]['summary_details']['total_sale'] = $orderReport[$date]['summary_details']['total_sale'] + $lineprice;
        } else {
            $orderReport[$date]['summary_details']['total_sale'] = $lineprice;
        }
        if (isset($orderReport[$date]['summary_details']['total_tax'])) {
            $orderReport[$date]['summary_details']['total_tax'] = $orderReport[$date]['summary_details']['total_tax'] + $orderData['total_tax'];
        } else {
            $orderReport[$date]['summary_details']['total_tax'] = $orderData['total_tax'];
        }
        if (isset($orderReport[$date]['summary_details']['total_shipping'])) {
            $orderReport[$date]['summary_details']['total_shipping'] = $orderReport[$date]['summary_details']['total_shipping'] + $shippingprice;
        } else {
            $orderReport[$date]['summary_details']['total_shipping'] = $shippingprice;
        }
        if (isset($orderReport[$date]['summary_details']['total_shipping_tax'])) {
            $orderReport[$date]['summary_details']['total_shipping_tax'] = $orderReport[$date]['summary_details']['total_shipping_tax'] + $orderData['total_shipping_tax'];
        } else {
            $orderReport[$date]['summary_details']['total_shipping_tax'] = $orderData['total_shipping_tax'];
        }
        if (isset($orderReport[$date]['summary_details']['total_tip_received'])) {
            $orderReport[$date]['summary_details']['total_tip_received'] = $orderReport[$date]['summary_details']['total_tip_received'] + $orderData['total_tip_received'];
        } else {
            $orderReport[$date]['summary_details']['total_tip_received'] = $orderData['total_tip_received'];
        }
        if (isset($orderReport[$date]['summary_details']['total_discounts'])) {
            $orderReport[$date]['summary_details']['total_discounts'] = $orderReport[$date]['summary_details']['total_discounts'] + $orderData['total_discounts'];
        } else {
            $orderReport[$date]['summary_details']['total_discounts'] = $orderData['total_discounts'];
        }
        if (isset($orderReport[$date]['summary_details']['total_giftcard'])) {
            $orderReport[$date]['summary_details']['total_giftcard'] = $orderReport[$date]['summary_details']['total_giftcard'] + $orderData['total_giftcard'];
        } else {
            $orderReport[$date]['summary_details']['total_giftcard'] = $orderData['total_giftcard'];
        }
        if (isset($orderReport[$date]['summary_details']['total_duties'])) {
            $orderReport[$date]['summary_details']['total_duties'] = $orderReport[$date]['summary_details']['total_duties'] + $orderData['total_duties'];
        } else {
            $orderReport[$date]['summary_details']['total_duties'] = $orderData['total_duties'];
        }
        if (isset($orderReport[$date]['summary_details']['total_duties_tax'])) {
            $orderReport[$date]['summary_details']['total_duties_tax'] = $orderReport[$date]['summary_details']['total_duties_tax'] + $orderData['total_duties_tax'];
        } else {
            $orderReport[$date]['summary_details']['total_duties_tax'] = $orderData['total_duties_tax'];
        }



        $orderReport[$date]['total_amount'] += $lineprice + $orderData['total_tax'] + $shippingprice + $orderData['total_shipping_tax'] + $orderData['total_tip_received'] + ($orderData['total_discounts'] * -1) + ($orderData['total_giftcard'] * -1) + $orderData['total_duties'] + $orderData['total_duties_tax'];
    }
    public function formatRefundDataIND($refundData, &$orderReport, $date)
    {
        if ($refundData['taxes_included'] == 1) {
            $lineprice     = $refundData['total_refund'] - $refundData['total_refund_tax'];
            $shippingprice = $refundData['total_refund_shipping'] - $refundData['total_refund_shipping_tax'];
            $adjprice      = $refundData['total_refund_discrepancy'] - $refundData['total_refund_discrepancy_tax'];
        } else {
            $lineprice     = $refundData['total_refund'];
            $shippingprice = $refundData['total_refund_shipping'];
            $adjprice      = $refundData['total_refund_discrepancy'];
        }

        if (isset($orderReport[$date]['total_refund'])) {
            $orderReport[$date]['summary_details']['total_refund'] = $orderReport[$date]['summary_details']['total_refund'] + $lineprice;
        } else {
            $orderReport[$date]['summary_details']['total_refund'] = $lineprice;
        }
        if (isset($orderReport[$date]['total_refund_tax'])) {
            $orderReport[$date]['summary_details']['total_refund_tax'] = $orderReport[$date]['summary_details']['total_refund_tax'] + $refundData['total_refund_tax'];
        } else {
            $orderReport[$date]['summary_details']['total_refund_tax'] = $refundData['total_refund_tax'];
        }
        if (isset($orderReport[$date]['total_refund_shipping'])) {
            $orderReport[$date]['summary_details']['total_refund_shipping'] = $orderReport[$date]['summary_details']['total_refund_shipping'] + $shippingprice;
        } else {
            $orderReport[$date]['summary_details']['total_refund_shipping'] = $shippingprice;
        }
        if (isset($orderReport[$date]['total_refund_shipping_tax'])) {
            $orderReport[$date]['summary_details']['total_refund_shipping_tax'] = $orderReport[$date]['summary_details']['total_refund_shipping_tax'] + $refundData['total_refund_shipping_tax'];
        } else {
            $orderReport[$date]['summary_details']['total_refund_shipping_tax'] = $refundData['total_refund_shipping_tax'];
        }
        if (isset($orderReport[$date]['total_refund_discrepancy'])) {
            $orderReport[$date]['summary_details']['total_refund_discrepancy'] = $orderReport[$date]['summary_details']['total_refund_discrepancy'] + $adjprice;
        } else {
            $orderReport[$date]['summary_details']['total_refund_discrepancy'] = $adjprice;
        }
        if (isset($orderReport[$date]['total_refund_discrepancy_tax'])) {
            $orderReport[$date]['summary_details']['total_refund_discrepancy_tax'] = $orderReport[$date]['summary_details']['total_refund_discrepancy_tax'] + $refundData['total_refund_discrepancy_tax'];
        } else {
            $orderReport[$date]['summary_details']['total_refund_discrepancy_tax'] = $refundData['total_refund_discrepancy_tax'];
        }
        if (isset($orderReport[$date]['total_refund_giftcard'])) {
            $orderReport[$date]['summary_details']['total_refund_giftcard'] = $orderReport[$date]['summary_details']['total_refund_giftcard'] + $refundData['total_refund_giftcard'];
        } else {
            $orderReport[$date]['summary_details']['total_refund_giftcard'] = $refundData['total_refund_giftcard'];
        }

        $orderReport[$date]['total_amount'] -= $lineprice + $refundData['total_refund_tax'] + $shippingprice + $refundData['total_refund_shipping_tax'] + $adjprice + $refundData['total_refund_discrepancy_tax'] + ($refundData['total_refund_giftcard'] * -1);

    }
    public function transferReport($module,$seller_id,$report_id="",$cogs_enable=""){
        $seller_id=(!empty($seller_id))? Helper::encryptor('decrypt', $seller_id):"";
        $report_id=(!empty($report_id))? Helper::encryptor('decrypt', $report_id):"";
       
        $reportData = Spysummaryreport::fetchReportData($seller_id,$report_id);
        
        if (isset($cogs_enable) && $cogs_enable=="Yes") {
            $costReportData = Spysummarycostreport::fetchCostReport($seller_id);
        
            if(!empty($costReportData)){
                foreach ($costReportData as $value) {
                    $modelCost = new Xerosummarycostjournals;

                    $xeroJournalSumary = $modelCost::where('marketplace_id', $value['id'])->where('module', $module)->where('seller_id', $value['seller_id'])->first();
                    
                    if (empty($xeroJournalSumary))
                    $xeroJournalSumary = new $modelCost();

                    $xeroJournalSumary->seller_id = $value['seller_id'];
                    $xeroJournalSumary->module = $module;
                    $xeroJournalSumary->marketplace_id = $value['id'];
                    $xeroJournalSumary->narration = (isset($value['document_number']))?$value['document_number']:null;
                    $xeroJournalSumary->journal_date = $value['posted_date'];
                    $xeroJournalSumary->line_items = $value['summary_details'];
                    $xeroJournalSumary->save();
                    Spysummarycostreport::where('id', $value['id'])->update(['sync_status_flg' => 'Process', 'sync_flg' => 'Y']);
                }
            }
        }
        
        if(!empty($reportData)){
            foreach ($reportData as $value) {
                $xeroSumary = SpySummary::where('marketplace_primary_id',$value['id'])->where('module',$module)->where('seller_id',$value['seller_id'])->first();
                
                if(empty($xeroSumary))
                    $xeroSumary = new SpySummary();
                $payoutData= array();
                if($value['gateway'] == 'shopify_payments' || $value['gateway'] == 'shopify_installments'){
                    $payoutData = Spysummarypayout::where('payout_id',$value['unique_id'])->first();
                }
                if(!empty($payoutData) && $value['partial_settlement'] == 'N'){
                    $amount = $payoutData['amount'];
                }else{
                    $amount = $value['total_amount'];                    
                }
                if(!empty($xeroSumary->xo_id) &&((isset($xeroSumary->total_amount) && $xeroSumary->total_amount!=$amount)||(isset($xeroSumary->json_amount) && $xeroSumary->json_amount!=$value['total_amount']))){
                    $xeroSumary->sync_flag ="U";
                }
                $xeroSumary->payout_id = $this->getPayoutId($value,"shopify");
                $xeroSumary->seller_id = $value['seller_id'];
                $xeroSumary->start_date = $value['start_date'];
                $xeroSumary->end_date = $value['end_date'];
                $xeroSumary->module = $module;
                $xeroSumary->marketplace_primary_id = $value['id'];
                $xeroSumary->marketplace_record_type = 'payout';
                $xeroSumary->document_number = $value['document_number'];
                $xeroSumary->invoice_date = $value['posted_date'];
                $xeroSumary->json_amount = $value['total_amount'];
                $xeroSumary->tax_type = $value['tax_type'];
                if(!empty($payoutData) && $value['partial_settlement'] == 'N'){
                    $xeroSumary->total_amount = $payoutData['amount'];
                    $xeroSumary->settlement_amount = $payoutData['amount'];
                }else{
                    $xeroSumary->total_amount = $value['total_amount'];                    
                    $xeroSumary->settlement_amount = $value['total_amount'];                    
                }
                $xeroSumary->gateway = $value['gateway'];
                $xeroSumary->currency = $value['currency'];
                $xeroSumary->reference = (isset($value['reference']))?$value['reference']:null;
                $valuesummary = array();
                $data = array();
                $valuesummary = json_decode($value['summary_details'],true);
               
                if(!empty($value['summary_details'])){
                    $summaryData = array();
                    $summaryData['shopify']['amount'] = $value['total_amount'];
                    $data['sales']['amount'] =0;
                    $data['sales']['taxAmount'] = 0;
                    if(isset($valuesummary['shopify_fee']))
                        $data['shopify_fee']['amount'] = $valuesummary['shopify_fee'];
                
                    /* if(isset($valuesummary['total_discounts']))
                        $data['discount']['amount'] = $valuesummary['total_discounts'];   */
                    if(isset($valuesummary['total_shipping']))
                        $data['shipping']['amount'] = $valuesummary['total_shipping'];  
                    if(isset($valuesummary['total_shipping_tax']))
                        $data['shipping']['taxAmount'] = $valuesummary['total_shipping_tax'];  
                    if(isset($valuesummary['total_tip_received']))
                        $data['tip']['amount'] = $valuesummary['total_tip_received'];  
                    if(isset($valuesummary['total_giftcard']))
                        $data['giftcard']['amount'] = $valuesummary['total_giftcard'];  
                    if(isset($valuesummary['total_duties']))
                        $data['duties']['amount'] = $valuesummary['total_duties'];  
                    if(isset($valuesummary['total_duties_tax']))
                        $data['duties']['taxAmount'] = $valuesummary['total_duties_tax']; 
                    if(isset($valuesummary['total_refund']))
                        $data['refund_sale']['amount'] = $valuesummary['total_refund']+@$valuesummary['total_refund_discrepancy'];
                    if(isset($valuesummary['total_refund_tax']))
                        $data['refund_sale']['taxAmount'] = $valuesummary['total_refund_tax']+ @$valuesummary['total_refund_discrepancy_tax'];
                    if(isset($valuesummary['total_refund_shipping']))
                        $data['refund_shipping']['amount'] = $valuesummary['total_refund_shipping'];
                    if(isset($valuesummary['total_refund_shipping_tax']))
                        $data['refund_shipping']['taxAmount'] = $valuesummary['total_refund_shipping_tax'];
                    /* if(isset($valuesummary['total_refund_discrepancy']))
                        $data['refund_discrepancy']['amount'] = $valuesummary['total_refund_discrepancy'];
                    if(isset($valuesummary['total_refund_discrepancy_tax']))
                        $data['refund_discrepancy']['taxAmount'] = $valuesummary['total_refund_discrepancy_tax']; */
                    if(isset($valuesummary['total_refund_giftcard']))
                        $data['refund_giftcard']['amount'] = $valuesummary['total_refund_giftcard']; 
                    if(!empty($valuesummary['salesData'])){
                        foreach ($valuesummary['salesData'] as $key1 => $valuesales) {
                            if(is_numeric($key1))
                            $key1 = number_format($key1,4,".","");
                            if(isset($valuesales['order']['amount'])){
                                 $data['sales']['amount'] += $valuesales['order']['amount']+$valuesales['order']['discount'];
                                $data['sales']['data'][$key1]['amount'] = $valuesales['order']['amount']+$valuesales['order']['discount'];
                            }
                            if(isset($valuesales['order']['tax'])){
                                $data['sales']['taxAmount'] += $valuesales['order']['tax'];
                                $data['sales']['data'][$key1]['taxAmount'] = $valuesales['order']['tax'];
                            }
                           // if(isset($valuesales['order']['discount']))
                            //    $data['sales']['data'][$key1]['discount'] = $valuesales['order']['discount'];
                            if(isset($valuesales['shipping']['amount']))
                                $data['shipping']['data'][$key1]['amount'] = $valuesales['shipping']['amount'] + $valuesales['shipping']['discount'];
                            if(isset($valuesales['shipping']['tax']))
                                $data['shipping']['data'][$key1]['taxAmount'] = $valuesales['shipping']['tax'];
                            //if(isset($valuesales['shipping']['discount']))
                             //   $data['shipping']['data'][$key1]['discount'] = $valuesales['shipping']['discount']; 
                            if(isset($valuesales['duties']['amount']))
                                $data['duties']['data'][$key1]['amount'] = $valuesales['duties']['amount'];
                            if(isset($valuesales['duties']['tax']))
                                $data['duties']['data'][$key1]['taxAmount'] = $valuesales['duties']['tax'];
                        }
                    }
                  
                    if(!empty($valuesummary['refundData'])){
                        foreach ($valuesummary['refundData'] as $key2 => $valueref) {
                            $refund=$refundtax=0;
                            ////pr($valueref,1);
                            $refundFlg=false;

                            foreach ($valueref as $key => $value2) {
                                if($key=="refund" || $key=="refund_discrepancy"){
                                    $refundFlg=true;
                                    $refund+=(isset($value2['amount']))?$value2['amount']:"";
                                    $refundtax+=(isset($value2['tax']))?$value2['tax']:"";
                                }
                            }
                            if($refundFlg){
                                if($value['tax_type']=="Inclusive"){
                                    $data['refund_sale']['data'][$key2]['amount'] =$refund;
                                }else{
                                    $data['refund_sale']['data'][$key2]['amount'] =$refund+$refundtax;
                                }
                                $data['refund_sale']['data'][$key2]['taxAmount'] =$refundtax;
                            }
                        }
                    }
                    if(isset($valuesummary['payment_pending']))
                        $data['payment_pending']['amount']= $valuesummary['payment_pending'];
                    if(isset($valuesummary['adjustment']))
                            $data['adjustment']['amount']= $valuesummary['adjustment'];
                    if(isset($valuesummary['payout_dispute']))
                        $data['payout_dispute']['amount']= $valuesummary['payout_dispute'];
                    if(isset($valuesummary['payout_reserve']))
                        $data['payout_reserve']['amount']= $valuesummary['payout_reserve'];
                    if(isset($valuesummary['payout_cancellation']))
                        $data['payout_cancellation']['amount']= $valuesummary['payout_cancellation'];
                    if(isset($valuesummary['carry_forward_from_previous_month']))
                    $data['carry_forward_from_previous_month']['amount']= $valuesummary['carry_forward_from_previous_month'];    
                    if(isset($valuesummary['carry_forward_to_next_month']))
                    $data['carry_forward_to_next_month']['amount']= $valuesummary['carry_forward_to_next_month'];    
                    if(!empty($valuesummary['currency_conversion_rounding'])){
                        $convertionAmount=0;
                        foreach ($valuesummary['currency_conversion_rounding'] as $keycur => $valuecur) {
                            if (isset($data['currency_conversion_rounding' . '_' . $valuecur['currency']]['amount'])) {
                                $data['currency_conversion_rounding' . '_' . $valuecur['currency']]['amount'] += $valuecur['amount'];
                            } else {
                                $data['currency_conversion_rounding' . '_' . $valuecur['currency']]['amount'] = $valuecur['amount'];
                            }
                            $convertionAmount +=$valuecur['amount'];
                        }
                        /* Start :if amount diffrent same as currency then minus from pending amount and total amount */
                        $total_amount =isset($xeroSumary->total_amount)? number_format($xeroSumary->total_amount,2,".",""):"";
                        $payout_amount =isset($xeroSumary->json_amount)? number_format($xeroSumary->json_amount,2,".",""):"";

                        $diffSumryAmt=$payout_amount-$total_amount;
                        
                        if((string)$diffSumryAmt===(string)number_format($convertionAmount,2,".","")){
                            $data['payment_pending']['amount'] -= $convertionAmount;
                            $summaryData['shopify']['amount'] -= $convertionAmount;
                            $xeroSumary->json_amount -= $convertionAmount;
                        }
                        /* End :if amount diffrent same as currency then minus from pending amount and total amount */
                    }
                    if(!empty($valuesummary['refund_currency_conversion_rounding'])){
                        foreach ($valuesummary['refund_currency_conversion_rounding'] as $keyrefcur => $valuerefcur) {
                            if(isset($data['currency_conversion_rounding'.'_'.$valuerefcur['currency']]['amount']))
                                $data['currency_conversion_rounding'.'_'.$valuerefcur['currency']]['amount'] += $valuerefcur['amount'];
                            else
                                $data['currency_conversion_rounding'.'_'.$valuerefcur['currency']]['amount'] = $valuerefcur['amount'];
                        }
                    }
                    $summaryData['shopify']['data'] = $data;
                    $xeroSumary->data = json_encode($summaryData);
                    
                }
                $xeroSumary->save();
                Spysummaryreport::where('id',$value['id'])->update(['sync_status_flg'=>'Process','sync_flg'=>'Y']);
            }
        }
    }
    public function recalculateReport(Request $request){
      
        if (version_compare(phpversion(), '7.1', '>=')) {
            ini_set('precision', 10);
            ini_set('serialize_precision', 10);
        }
        ini_set('max_execution_time', 0);
        $report_id= Helper::encryptor('decrypt', $request->get('id'));
        //$report_id= $request->get('id');
        $module= $request->get('module');
        $Spylastsyncdata = Spysummaryreport::fetchReportById($report_id,$module);
        
        if(!empty($Spylastsyncdata)){
           
            $spyConnected = Spycredential::checkConnection($Spylastsyncdata->store_domain,$Spylastsyncdata->module);
            
            //$spyConnected = Xerocredential::checkXeroConnected('store_domain', $Spylastsyncdata->store_domain);
            if (!empty($spyConnected)) {
                //$settingData = Spysummarysetting::fetchSummarySettingData('seller_id', $spyConnected['id'], $spyConnected['xero_org_muid']);
                $settingData = Summarysetting::fetchSummarySettingData($spyConnected);
                $reportKey=[];
                $posted_date=date('Y-m-d', strtotime($Spylastsyncdata->posted_date));
                $transactionId=$Spylastsyncdata->unique_id;
                $transaction_type=$Spylastsyncdata->transaction_type;
                $gateway=$Spylastsyncdata->gateway;
                $gatway_type=$Spylastsyncdata->gateway;
                $reportType="recalculateReport";
                $cogs_enable=(isset($settingData->cogs_enable))?$settingData->cogs_enable:"";

                $reCalcParameters = array('posted_date' => $posted_date,'transactionId' => $transactionId,'reportType' => $reportType,'transaction_type' => $transaction_type,'gateway' => $gateway,"report_id"=>$report_id);
               
                if($gatway_type!="shopify_payments" && $gatway_type!="shopify_installments" && $gatway_type!="shop_cash"){
                    $this->otherOrdersReport($reportKey,$spyConnected, $settingData,"","",$reCalcParameters);
                }else{
                    $this->shopifyPayoutsReport($spyConnected, $settingData,config('shopify.otherGatewaySummaryReportcount'),"","",$reCalcParameters);
                }
                $seller_id= Helper::encryptor('encrypt', $spyConnected['id']);
                $this->transferReport($spyConnected['module'],$seller_id,$request->get('id'),$cogs_enable);
            }
        }
        
    }
    //when start and end date pass use posted date otherwise use report calc date
    public function getStartEndDates(&$orderReport,$dateKey,$reportstartdate,$reportenddate,$posted_date,$report_type,$betweenDate){
        if($betweenDate){
            if ($report_type == "monthly"){

                $reportstartdate =$posted_date;
                $reportenddate = \Carbon\Carbon::parse($posted_date)->endOfMonth()->toDateString() . " 23:59:59";

            }else{
                $reportstartdate =$posted_date;
                $reportenddate = $posted_date. " 23:59:59";
            }

        }else{
            $reportstartdate =$reportstartdate;
            $reportenddate = $reportenddate;
        } 
        $orderReport[$dateKey]['start_date'] = $reportstartdate;
        $orderReport[$dateKey]['end_date'] = $reportenddate;
    }

    public function getGateway($gateway = null)
    {
        $gateways=config('shopify.gatewayKey');
       
        foreach ($gateways as $Gkey => $Gtypes) {
          
            if(!empty($gateway) && in_array($gateway, $Gtypes)){
                $gateway=$Gkey;
            }else{
                $gateway= (!empty($gateway))?$gateway:"";
            }
        }
        return $gateway;
    }

    public function getPayoutId($reportData,$type)
    {
        $currency=(isset($reportData['currency']))?$reportData['currency']:"";
        $gateway=(isset($reportData['gateway']))?$reportData['gateway']:"";
        $gatewayKey=(!empty($gateway))?"-".$gateway:"";
        $unique_id=(isset($reportData['unique_id']))?$reportData['unique_id']:"";
        if($type=="shopify"){
            //for shopify module
            if($gateway == 'shopify_payments' || $gateway == 'shopify_installments' || $gateway == 'shop_cash'){
                $payoutId=$unique_id;
            }else{
                $payoutId=$unique_id.$gatewayKey;
            }

        }else{
            //for woocommerce module
            if($reportData['transaction_type']=="Summary"){
                $date1=date_create($reportData['start_date']);
                $date2=date_create($reportData['end_date']);
                $diff=date_diff($date1,$date2);
                $days= $diff->format("%a");
                if($days>0){
                    $unique_id=date("Ym",strtotime($reportData['unique_id']));
                }else{
                    $unique_id=$reportData['unique_id'];
                }
                $payoutId=$unique_id."-".$currency.$gatewayKey;
                
            }else{
                $payoutId=$unique_id;
            }
        }
        return  $payoutId;
    }
}
