<?php

namespace App\Http\Controllers\Ecomtoacc\Shopify;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CustomDataController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function createKey($settingData,$type="",$transaction_id,$posted_date,$gateway,$reCalcParameters=[])
    {
        $transaction_type=isset($reCalcParameters['transaction_type'])?$reCalcParameters['transaction_type']:"";
        $gatewayRecalc=isset($reCalcParameters['gateway'])?$reCalcParameters['gateway']:"";
        $reportType=isset($reCalcParameters['reportType'])?$reCalcParameters['reportType']:"";
        if ($type == "payout") {
            return $key = $posted_date;
        } else {
            $gateway_settings = (!empty($settingData->gateway_settings))?json_decode($settingData->gateway_settings):[];
            $checkGatewaySetings = array_column($gateway_settings, $gateway);
            if($transaction_type=="Summary" && $reportType=="recalculateReport"){
                $key = $posted_date . ',' . $gatewayRecalc;
            }else if(($transaction_type=="Individual" && $reportType=="recalculateReport") || (!empty($checkGatewaySetings) && $checkGatewaySetings[0] == "YES")){
                $key = $transaction_id;
            } else {
                $key = $posted_date . ',' . $gateway;
            }
            return $key;
        }
    }
    public function createReportHeader(&$orderReport,$data, $settingData, $gateway,$key="",$posted_date,$transaction_id,$reCalcParameters=[])
    {
        $transaction_type=isset($reCalcParameters['transaction_type'])?$reCalcParameters['transaction_type']:"";
        $reportType=isset($reCalcParameters['reportType'])?$reCalcParameters['reportType']:"";
        $gateway_settings = (!empty($settingData->gateway_settings))?json_decode($settingData->gateway_settings):[];
        $checkGatewaySetings = array_column($gateway_settings, $gateway);

        if($transaction_type=="Summary" && $reportType=="recalculateReport"){
            $orderReport[$key]['transaction_type'] = $reCalcParameters['transaction_type'];
            $orderReport[$key]['unique_id'] = date('Ymd', strtotime($posted_date));
        }else if($transaction_type=="Individual" && $reportType=="recalculateReport"){
            $orderReport[$key]['transaction_type'] = $reCalcParameters['transaction_type'];
            $orderReport[$key]['unique_id'] = $transaction_id;
        }else if (!empty($checkGatewaySetings) && $checkGatewaySetings[0] == "YES") {
            $orderReport[$key]['transaction_type'] = 'Individual';
            $orderReport[$key]['unique_id'] = $transaction_id;
        } else {
            $orderReport[$key]['transaction_type'] = 'Summary';
            $orderReport[$key]['unique_id'] = date('Ymd', strtotime($posted_date));
        }
        if (!isset($orderReport[$key]['total_amount'])) {
            $orderReport[$key]['total_amount'] = 0;
        }
        if (!isset($orderReport[$key]['seller_id']))
        $orderReport[$key]['seller_id'] = $data['seller_id'];
        if (!isset($orderReport[$key]['gateway']))
        $orderReport[$key]['gateway'] = $gateway;
        if (!isset($orderReport[$key]['posted_date']))
        $orderReport[$key]['posted_date'] = $posted_date;
        if (!isset($orderReport[$key]['settlement_month']))
        $orderReport[$key]['settlement_month'] = date('Y-m', strtotime($posted_date));
        if (!isset($orderReport[$key]['currency'])) {
            $orderReport[$key]['currency'] = "";
        }
        $orderReport[$key]['currency'] = (!empty($data['currency']))?$data['currency']:"";

        return $orderReport;
    }
    public function createFeesReportHeader(&$orderReport,$data, $settingData, $gateway,$aryKey="",$posted_date,$transaction_id)
    {
        $gateway_settings = (!empty($settingData->gateway_settings))?json_decode($settingData->gateway_settings):[];
        $checkGatewaySetings = array_column($gateway_settings, $gateway);
        $gatewayKey=(!empty($gateway))?$gateway."fee":"";

        if (!empty($checkGatewaySetings) && $checkGatewaySetings[0] == "YES") {

            $orderReport[$aryKey]['transaction_type'] = 'Individual';
            $orderReport[$aryKey]['unique_id'] = $transaction_id;
            if(!isset($orderReport[$aryKey]['order_id']))
            $orderReport[$aryKey]['order_id']         = $data['order_id'];
            if(!isset($orderReport[$aryKey]['reference']))
            $orderReport[$aryKey]['reference']= $data['referance'];
        } else {
            $orderReport[$aryKey]['transaction_type'] = 'Summary';
            $orderReport[$aryKey]['unique_id'] = date('Ymd', strtotime($posted_date));
        }

        if(!isset($orderReport[$aryKey]['seller_id']))
        $orderReport[$aryKey]['seller_id']= $data['seller_id'];
        if(!isset($orderReport[$aryKey]['currency']))
        $orderReport[$aryKey]['currency'] = (!empty($data['currency']))?$data['currency']:"";

        if(!isset($orderReport[$aryKey]['gateway']))
        $orderReport[$aryKey]['gateway']= $gateway;

        if(!isset($orderReport[$aryKey]['posted_date']))
        $orderReport[$aryKey]['posted_date']      = $posted_date;

        if (!isset($orderReport[$aryKey]['summary_details']['shopify']['amount'])) {
        $orderReport[$aryKey]['summary_details']['shopify']['amount'] =0;
        }
        $orderReport[$aryKey]['summary_details']['shopify']['amount'] += $data['fee_amount'];

        if (!isset($orderReport[$aryKey]['summary_details']['shopify']['data'][$gatewayKey]['amount'])) {
            $orderReport[$aryKey]['summary_details']['shopify']['data'][$gatewayKey]['amount'] =0;
        }
        $orderReport[$aryKey]['summary_details']['shopify']['data'][$gatewayKey]['amount'] = $orderReport[$aryKey]['summary_details']['shopify']['amount'];

        if (!isset($orderReport[$aryKey]['total_amount'])) {
        $orderReport[$aryKey]['total_amount'] =0;
        }
        $orderReport[$aryKey]['total_amount'] += $data['fee_amount'];
        if (!isset($orderReport[$aryKey]['settlement_month']))
        $orderReport[$aryKey]['settlement_month'] = date('Y-m', strtotime($posted_date));

        return $orderReport;
    }
    public function createFeesTransferKey($settingData,$gateway)
    {
        $gateway_settings = (!empty($settingData->gateway_settings))?json_decode($settingData->gateway_settings):[];
        $checkGatewaySetings = array_column($gateway_settings, $gateway);
        
        if (!empty($checkGatewaySetings) && $checkGatewaySetings[0] == "YES") {
            $key ="transaction";
        } else {
            $key ="payout";
        }
        return $key;
    }
    public function createTaxKey($spyConnected,$orderData,$key){
        $tKey="";
        /* echo $orderData['shipping_country_code'];
        echo "<br>"; */

        if($spyConnected['shop_country']=="US" || $spyConnected['shop_country']=="CA"){

            if(!empty($spyConnected['shop_country']) && !empty($orderData['shipping_country_code']) && $spyConnected['shop_country']!=$orderData['shipping_country_code']){

                $tKey="International";

            }else{

                if($key>0){
                    $tKey="Taxable";
                }else if($key<=0){
                    $tKey="Non-Taxable";
                }else{
                    $tKey=$key;
                }
            }
        
        }else{
            
            if(!empty($spyConnected['shop_country']) && !empty($orderData['shipping_country_code']) && $spyConnected['shop_country']!=$orderData['shipping_country_code']){

                $tKey="International";

            }else{

                $tKey = number_format($key,4,".","");
            }
        }
        return $tKey;
    }
}
