<?php
namespace App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Amazon\Azfinancialreport;
use App\Models\Amazon\Marketplace;
use App\Models\Amazon\Azsellers;
use App\Models\Amazon\Azlastsync;
use App\Models\Amazon\Azfinancialeventgroup;
use Log;
use DateTime;
use DateTimeZone;
use DB;
use File;

class FinanceController extends Controller
{
    private $randomValue = 0;
    /*
    Auto Url for report fetch for Summary
    Manali Patel - 04-05-2023
    */
    public function getfinanceeventsamazonsummaryauto(){
        $this->randomValue = rand(1111111111,9999999999);
        $sellerData = Azsellers::getAutoSellerDetails('Summary');
        
        if(!empty($sellerData)){
            $this->cronActionLog('', 'Amazon', 'Auto cron for fetch summary finance events for all sellers - START', $this->randomValue);
            foreach ($sellerData as $key => $value) {
                if($value->sync_type == 'Summary'){
                    $sellerid = Helper::encryptor('encrypt',$value->sellerId);
                    $request = new \Illuminate\Http\Request();
                    $request->replace(['sellerid' => $sellerid]);
                    $this->cronActionLog($value->sellerId, 'Amazon', 'Fetch summary finance events for seller', $this->randomValue);
                    $this->getFinanceEvents($request,'Auto');
                }
            }
            $this->cronActionLog('', 'Amazon', 'Auto cron for fetch summary finance events for all sellers - END', $this->randomValue);
        }
    }

    public function getFinanceEvents(Request $request,$para = ''){

        set_time_limit(0);
        $sellerid = Helper::encryptor('decrypt',$request->get('sellerid'));
        $sellerid = 15;
        $seller = Azsellers::find($sellerid);
        $connection_name = '';
        if(strpos($seller->module,'tl') !== false){
            $connection_name = env('DB_DATABASE_TALLY_MASTER').'.tally_connections';
        } 

        if($seller->sync_type == 'Summary'){
            if(strpos($seller->module,'tl') !== false)
            $setting_name = env('DB_DATABASE').'.tally_summary_setting';
        }
        else{
            if(strpos($seller->module,'tl') !== false)
            $setting_name = 'tally_sync_settings';
        }
        
        $sellerDetails = Azsellers::getSellerDetail($sellerid,$connection_name,$setting_name,$seller->module);
            
        $backdated_dates = array();
        if(!empty($sellerDetails) && count($sellerDetails) > 0){
            $sellerDetails = $sellerDetails->toArray()[0];            
            
            if($request->get('startDate') != '' || $request->get('endDate') != '')
                $backdated_dates = array('start_date'=>$request->get('startDate'),'end_date'=>$request->get('endDate'));
            
            if(isset($sellerDetails['sync_type']) && $sellerDetails['sync_type'] == 'Summary'){
                
                if($para != 'All'){
                    /*list($EventRanges,$next_token,$version,$availableDate) = $this->getFinancialEventsRanges($sellerDetails,'','',$backdated_dates);
                    //Log::info('Amazon Report EventRanges : '.json_encode($EventRanges));
                    if(!empty($EventRanges)){ 
                        $this->reportDataProcess($EventRanges,$sellerDetails,$backdated_dates);
                        if($next_token != ''){
                            $this->getNexttokenReports($sellerDetails,$next_token,$version,$availableDate,$request->get('endDate'),$backdated_dates);
                        }
                    } else {
                        $this->getReportFromReportGroups($sellerDetails);
                    }*/
                    app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\SummaryfinanceController')->getSummaryFinanceFeesFromDB($sellerDetails,'',$backdated_dates);
                    //$this->storeAmazonFinancialEventGroupData($request);       
                    app('App\Http\Controllers\Ecomtoacc\Dbtoacc\AmazonController')->syncDbToAcc($request,'from manual');
                    $updaterequest = new \Illuminate\Http\Request();
                    $updaterequest->replace(['sellerid' => $request->get('sellerid'),'type' => 'update']);
                    app('App\Http\Controllers\Ecomtoacc\Dbtoacc\EbayController')->syncDbToAcc($request,'from manual');
                }
            }else{

                list($EventRanges,$next_token,$version,$availableDate) = $this->getFinancialEventsRanges($sellerDetails,$request->get('startDate'),$request->get('endDate'),$backdated_dates);
            
                if(!empty($EventRanges)){
                    $this->reportDataProcess($EventRanges,$sellerDetails,$backdated_dates);
                    if($next_token != ''){
                        $this->getNexttokenReports($sellerDetails,$next_token,$version,$availableDate,$request->get('endDate'),$backdated_dates);
                    }
                } else {
                    $this->getReportFromReportGroups($sellerDetails);
                }

                app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\IndividualfinanceController')->getFinanceFeesFromDB($sellerDetails);
            }
        }

        if($para == '')
        return 'success';
        else
        return true;
    }

    private function getFinancialEventsRanges($sellerDetails,$startDate = '',$endDate = '',$backdated_dates = array()){
        $report_result = $next_token = array();
        $version = 'V2';

        $availableDate = $this->getAvailableDate($sellerDetails,$startDate,'V2',$backdated_dates);

        try{
            list($report_result,$next_token) = $this->reportApi($sellerDetails,$availableDate,$endDate,'V2');       
            $reportTwoExist = Azfinancialreport::where('seller_id',$sellerDetails['seller_id'])->where('ReportType',config('ecomtoacc.amazon.FINANCE_SPAPI_V2_REPORT'))->first();
            
            if(empty($report_result) && empty($reportTwoExist)){
                $version = 'V1';
                $availableDate = $this->getAvailableDate($sellerDetails,$startDate,'V1',$backdated_dates);
                list($report_result,$next_token) = $this->reportApi($sellerDetails,$availableDate,$endDate,'V1');
            }
        } catch(\ClouSale\AmazonSellingPartnerAPI\ApiException $e) {            
            \Log::info('AZXO getFinancialEventsRanges request error: '.$sellerDetails['seller_id'].'-'.$e->getMessage());
        }
        
        return array($report_result,$next_token,$version,$availableDate);
    }

    private function reportDataProcess($EventRanges,$sellerDetails,$backdated_dates = array()){
        $EventRanges = array_reverse($EventRanges);
        
        $timezone = isset(config('ecomtoacc.amazon.AWS_MARKETPLACE_TIMEZONE')[$sellerDetails['az_marketplace_name']]) ? config('ecomtoacc.amazon.AWS_MARKETPLACE_TIMEZONE')[$sellerDetails['az_marketplace_name']] : 'UTC';
        
        if(isset($EventRanges[0])){
            foreach ($EventRanges as $key => $value) {                
                $report_id = $value->getReportId();
                $report_type = $value->getReportType();
                $processing_start_date = $value->getProcessingStartTime();
                $data_end_date = $value->getDataEndTime();
                $report_document_id = $value->getReportDocumentId();
                $reportDbData = Azfinancialreport::where('ReportType',$report_type)->where('seller_id',$sellerDetails['seller_id'])->where(function($query) use($report_id){
                            $query->where('ReportId',$report_id);
                            $query->orWhere('ReportRequestId', $report_id);
                        })->first();
                $data_end_date = $data_end_date->setTimezone(new DateTimeZone($timezone))->format('Y-m-d H:i:s');
                $entry = false;
                if(!empty($backdated_dates)){
                    if(strtotime($data_end_date) >= strtotime($backdated_dates['start_date']) && strtotime($data_end_date) <= strtotime($backdated_dates['end_date']) ){
                        $entry = true;
                    }
                }else{
                    if(strtotime($data_end_date) >= strtotime($sellerDetails['sync_start_date'])){
                        $entry = true;
                    }    
                }
                if($entry == true){
                    if(!empty($reportDbData)){
                        $reportDbObj = $reportDbData;
                    }else{                            
                        $reportDbObj = new Azfinancialreport();
                    }
                    $reportDbObj->seller_id = $sellerDetails['seller_id'];
                    $reportDbObj->ReportType = $report_type;
                    $reportDbObj->ReportId = $report_id;    
                    $reportDbObj->ReportRequestId = $report_id;    
                    $reportDbObj->ReportDocumentId = $report_document_id;    
                    $reportDbObj->AvailableDate = $processing_start_date->setTimezone(new DateTimeZone($timezone))->format('Y-m-d H:i:s'); 
                    $reportDbObj->save();
                }
            }
        }else{
            $report_id = $EventRanges->getReportId();
            $report_type = $EventRanges->getReportType();
            $processing_start_date = $EventRanges->getProcessingStartTime();
            $data_end_date = $EventRanges->getDataEndTime();
            $report_document_id = $value->getReportDocumentId();
            $reportDbData = Azfinancialreport::where('ReportType',$report_type)->where('seller_id',$sellerDetails['seller_id'])->where(function($query) use($report_id){
                            $query->where('ReportId',$report_id);
                            $query->orWhere('ReportRequestId', $report_id);
                        })->first();
            $data_end_date = $data_end_date->setTimezone(new DateTimeZone($timezone))->format('Y-m-d H:i:s');
            $entry = false;
            if(!empty($backdated_dates)){
                if(strtotime($data_end_date) >= strtotime($backdated_dates['start_date']) && strtotime($data_end_date) <= strtotime($backdated_dates['end_date']) ){
                    $entry = true;
                }
            }else{
                if(strtotime($data_end_date) >= strtotime($sellerDetails['sync_start_date'])){
                    $entry = true;
                }    
            }
            if($entry == true){
                if(!empty($reportDbData)){
                    $reportDbObj = $reportDbData;
                }else{                            
                    $reportDbObj = new Azfinancialreport();
                }
                $reportDbObj->seller_id = $sellerDetails['seller_id'];
                $reportDbObj->ReportType = $report_type;
                $reportDbObj->ReportId = $report_id;    
                $reportDbObj->ReportRequestId = $report_id;    
                $reportDbObj->ReportDocumentId = $report_document_id;
                $reportDbObj->AvailableDate = $processing_start_date->setTimezone(new DateTimeZone($timezone))->format('Y-m-d H:i:s');
                $reportDbObj->save();
            }
        }        
        $this->getReportFromReportGroups($sellerDetails);
        //check if setting is for individual or for summary.
        
        if(isset($sellerDetails['sync_type']) && $sellerDetails['sync_type'] == 'Summary'){
            app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\SummaryfinanceController')->getSummaryFinanceFeesFromDB($sellerDetails,'',$backdated_dates);
        }else{
            app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\IndividualfinanceController')->getFinanceFeesFromDB($sellerDetails);
        }
        
    }

    private function getAvailableDate($sellerDetails,$startDate = '',$version,$backdated_dates = array()){
        if($version == 'V2')
        $version = config('ecomtoacc.amazon.FINANCE_SPAPI_V2_REPORT');
        else
        $version = config('ecomtoacc.amazon.FINANCE_SPAPI_V1_REPORT');

        if(empty($backdated_dates)){
            $lastSyncData = Azfinancialreport::select(DB::RAW('MIN(AvailableDate) as availdate'))->where('ReportType',$version)->where('seller_id',$sellerDetails['seller_id'])->whereNull('EventData')->first();
            
            if($lastSyncData->availdate == ''){
                $lastSyncData = Azfinancialreport::select(DB::RAW('MAX(AvailableDate) as availdate'))->where('ReportType',$version)->where('seller_id',$sellerDetails['seller_id'])->first();
            }
            
            if($startDate != ''){
                $availableDate = date("Y-m-d\TH:i:s\Z", strtotime($startDate));
            }else if($lastSyncData['availdate'] != ''){
                $availableDate = date("Y-m-d\TH:i:s\Z", strtotime($lastSyncData['availdate']));
            }else{
                $availableDate = date("Y-m-d\TH:i:s\Z", strtotime($sellerDetails['sync_start_date']));
            }
            if (strtotime($availableDate) < strtotime('-90 days') && $startDate == ''){
                $availableDate = date('Y-m-d\TH:i:s\Z',strtotime('-89 days'));
            } 
        }else{
            $availableDate = date('Y-m-d\TH:i:s\Z',strtotime('-89 days'));
        }
        return $availableDate;
    }

    private function reportApi($sellerDetails,$DateFrom,$DateTo = '',$version = 'V2',$next_token = ''){    
            
        if($version == 'V2')
        $version = config('ecomtoacc.amazon.FINANCE_SPAPI_V2_REPORT');
        else
        $version = config('ecomtoacc.amazon.FINANCE_SPAPI_V1_REPORT');

        $config = app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\ApiController')->getCommonConfigDetails($sellerDetails);
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\ReportsApi($config);
        $report_types = $version;

        $created_since = new \DateTime($DateFrom); 
        $created_until = new \DateTime($DateTo); 

        if(!empty($next_token)){
            $result = $apiInstance->getReports(null,null,null,null,null,null,$next_token);
        } else {
            $result = $apiInstance->getReports($report_types,null,null,config('amazonsummaryconstant.maxReportFetchLimit'),$created_since,$created_until,$next_token);
        }
        
        $report_result = $result->getPayload();
        //Log::info("Report Data : ".print_r($report_result,true));
        $next_token = $result->getNextToken();
        return array($report_result,$next_token);
        
    }

    public function getReportFromReportGroups($sellerDetails){
        
        $EventRanges = Azfinancialreport::select('az_financial_reports.*')->where('az_financial_reports.seller_id',$sellerDetails['seller_id'])->whereNull('settlement_id')->whereIn('az_financial_reports.process_flag',array('N','P'))->limit(config('ecomtoacc.amazon.FINANCE_SPAPI_V2_REPORT_DATA_LIMIT'))->get();

        if(!empty($EventRanges)){            
            foreach ($EventRanges as $key => $value) {
                if(!empty($value['ReportDocumentId'])){
                    sleep(10);
                    $responseArray = array();
                    $docResult = $this->reportFinanceReport($sellerDetails,$value['ReportDocumentId']);

                    if(!empty($docResult)){

                        $url = $docResult->geturl();
                        $key = $docResult->getEncryptiondetails()->getkey();
                        $iv = $docResult->getEncryptiondetails()->getInitializationvector();
                        $iv = base64_decode($iv, true);
                        $key = base64_decode($key, true);
                        $decryptedData = openssl_decrypt(file_get_contents($url), 'AES256', $key, OPENSSL_RAW_DATA, $iv);

                        if(!empty($decryptedData)){
                            $Data = str_getcsv($decryptedData, "\n"); 
                            foreach($Data as $k=>$Row){
                            
                                $Row = mb_convert_encoding($Row, 'UTF-8', 'UTF-8');
                                $Row = str_getcsv($Row, ";");
                                $D = str_getcsv($Row[0], "\t");

                                if($k == 0){
                                  $key = $D;
                                  $header = $key;
                                }else{
                                  $remainingCount = 0;
                                  $keycount = count($key);
                                  $Dcount = count($D);
                                  if($keycount > $Dcount){
                                    $remainingCount = $keycount - $Dcount;
                                    for ($i=0; $i < $remainingCount; $i++) { 
                                        array_push($D, '');
                                    }
                                  }
                                  if(count($key) == count($D)){                    
                                    $responseArray[] = array_combine($key, $D);
                                  }
                                }                 
                              }  

                            $path = public_path().'/financereports/' . $sellerDetails['seller_id'];
                            if(!File::isDirectory($path)){
                                File::makeDirectory($path, $mode = 0777, true, true);
                            }
                            $csvName = rand().'_financedataspapi.csv';
                            $fileName = $path.'/'.$csvName;                      
                            $file = fopen($fileName, 'w');                   
                            fputcsv($file, $header);
                            foreach ($responseArray as $row)
                            {
                                fputcsv($file, $row);
                            }                   
                            fclose($file);

                            $checkSettlementExist = Azfinancialreport::where('seller_id',$sellerDetails['seller_id'])->where('settlement_id',$responseArray[0]['settlement-id'])->first();
                            $country = '';
                            if(isset($responseArray[1])){
                                if($responseArray[1]['marketplace-name'] != ''){
                                    $marketplace_data = Marketplace::where('seller_id',$sellerDetails['seller_id'])->where('az_marketplace_name',$responseArray[1]['marketplace-name'])->first();
                                    if($marketplace_data)
                                        $country = $marketplace_data->country;
                                }
                            }

                            $updateData = array();
                            $updateData = array(
                                'process_flag'=>'N',
                                'settlement_id'=>$responseArray[0]['settlement-id'],
                                'EventData'=>$csvName,
                                'deposit_date'=> date('Y-m-d H:i:s',strtotime($responseArray[0]['deposit-date'])),
                                'start_date'=> date('Y-m-d H:i:s',strtotime($responseArray[0]['settlement-start-date'])),
                                'end_date'=>date('Y-m-d H:i:s',strtotime($responseArray[0]['settlement-end-date'])),
                                'total_amount'=>app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\SummaryfinanceController')->format_amount($responseArray[0]['total-amount']),
                                'currency'=>$responseArray[0]['currency'],
                                'country_code'=>$country
                            );
                            if(empty($checkSettlementExist)){
                                $updateData['process_flag'] = 'N';
                            }else{
                                $updateData['process_flag'] = 'D';
                            }
                            if(!empty($updateData))
                            Azfinancialreport::where('id',$value['id'])->update($updateData);
                        }
                    }
                    if(!empty($error)){
                        Azfinancialreport::where('id',$value['id'])->update(array('process_flag'=>'P'));
                    }
                    //save all transaction fro this report
                    $transactionRequest = new \Illuminate\Http\Request();
                    $sellerid = Helper::encryptor('encrypt',$value->sellerId);
                    $transactionRequest->replace(['seller_id' => $sellerDetails['seller_id'] ,'report_id'=>$value['id']]);
                    app('App\Http\Controllers\Amazon\Amazon\FinancedetailsController')->processAmazonFinancialReports($transactionRequest);
		}
            }
        }        
        return true;
    }

    private function reportFinanceReport($sellerDetails,$reportDocId){
        $config = app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\ApiController')->getCommonConfigDetails($sellerDetails);
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\ReportsApi($config);
        try {
            $result = $apiInstance->getReportDocument($reportDocId);
            $docResult = $result->getPayload();
            return $docResult;
        } catch(\ClouSale\AmazonSellingPartnerAPI\ApiException $e) {
            return array();
        }
    }

    private function getNexttokenReports($sellerDetails,$nextToken,$version,$availableDate,$endDate,$backdated_dates){
        for ($i=1; $i < config('app.maxPagePerCall'); $i++) {
            if($nextToken != ''){
                list($report_result,$nextToken) = $this->reportApi($sellerDetails,$availableDate,$endDate,$version,$nextToken);
                if(!empty($report_result)){
                    $this->reportDataProcess($report_result,$sellerDetails,$backdated_dates);
                }
            }
        } 
    }

    private function reportParametersNextToken($sellerDetails,$nextToken){    
        $parameters = config('ecomtoacc.amazon.AWS_AUTHENTICATION');                  
        $parameters['MWSAuthToken'] = $sellerDetails['az_app_token'];
        $parameters['SellerId'] = $sellerDetails['az_seller_id'];
        $parameters['Version'] = '2009-01-01';
        $parameters['Action']               = 'GetReportListByNextToken';
        $parameters['NextToken']      = $nextToken;
        return $parameters;
    }

    public function processFinanceReport(Request $request){
        $sellerid = Helper::encryptor('decrypt',$request->get('sellerid')); 
        $sellerData = Azsellers::find($sellerid);
        if($sellerData->sync_type == 'Summary')
        $sellerDetails = Azsellers::getSellerDetailsForSummaryById($sellerid);
        else
        $sellerDetails = Azsellers::getSellerDetails($sellerid);
        if(!empty($sellerDetails)){
            $sellerDetails = $sellerDetails->toArray()[0];
            if(isset($sellerDetails['sync_type']) && $sellerDetails['sync_type'] == 'Summary'){
                app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\SummaryfinanceController')->getSummaryFinanceFeesFromDB($sellerDetails);
            }else{
                app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\IndividualfinanceController')->getFinanceFeesFromDB($sellerDetails);
            }
        }
        return 'success';
    }

    // AR - 15/12/2022 store amazon financial event group data
    public function storeAmazonFinancialEventGroupData(Request $request,$para = '')
    {
        set_time_limit(0);
        $start_date = $request->get('startDate');
        $seller_id = Helper::encryptor('decrypt',$request->get('sellerid'));
        
        $seller = Azsellers::find($seller_id);
        
        if(strpos($seller->module,'xo') !== false){
            $connection_name = env('DB_DATABASE').'.xero_credential';
        } else if(strpos($seller->module,'sg') !== false){
            $connection_name = env('DB_DATABASE').'.sage_credential';
        } else if(strpos($seller->module,'qbd') !== false){
            $connection_name = env('DB_DATABASE_QBDESKTOP').'.qbd_quickbooks_user';
        } else if(strpos($seller->module,'qb') !== false){
            $connection_name = env('DB_DATABASE').'.qbo_credential';
        }

        if($seller->sync_type == 'Summary'){
            if(strpos($seller->module,'sg') !== false)
            $setting_name = 'sg_summary_sync_settings';
            elseif(strpos($seller->module,'xo') !== false)
            $setting_name = 'xo_summary_sync_settings';
            elseif(strpos($seller->module,'qbd') !== false)
            $setting_name = 'qbd_summary_setting';
            elseif(strpos($seller->module,'qb') !== false)
            $setting_name = 'qbo_summary_setting';
        }else{
            if(strpos($seller->module,'sg') !== false)
            $setting_name = 'sg_sync_settings';
            if(strpos($seller->module,'xo') !== false)
            $setting_name = 'xo_sync_settings';
        }
        $sellerDetails = Azsellers::getSellerDetail($seller_id,$connection_name,$setting_name,$seller->module);

        if(!empty($sellerDetails)){
            $sellerDetails = $sellerDetails->toArray()[0];
            $financialEventGroupDate = $this->financialEventGroupDateRange($sellerDetails,$start_date);
            if(!empty($financialEventGroupDate)){
                $financialEventGroupEndDate = '';
                if($request->get('endDate') != '')
                    $financialEventGroupEndDate = date("Y-m-d\TH:i:s\Z", strtotime($request->get('end_Date')));
                list($FinancialGroupEventRanges) = $this->getFinancialGroupEventRanges($sellerDetails,$financialEventGroupDate,$financialEventGroupEndDate);
                if(!empty($FinancialGroupEventRanges)){
                    $this->processFinancialEventGroupsData($FinancialGroupEventRanges,$sellerDetails,$financialEventGroupDate);
                    $financialEventGroupDate = $this->financialEventGroupDateRange($sellerDetails,'','dbDataProcess');
                    if(!empty($financialEventGroupDate)){
                        list($FinancialGroupEventRanges) = $this->getFinancialGroupEventRanges($sellerDetails,$financialEventGroupDate,$financialEventGroupEndDate);
                        if(!empty($FinancialGroupEventRanges)){
                            $this->processFinancialEventGroupsData($FinancialGroupEventRanges,$sellerDetails,$financialEventGroupDate);
                        }
                    }
                }
            }
        }
        if($para == '')
            return true;
        else
        echo "suceess"; exit;
    }

    public function financialEventGroupDateRange($sellerDetails,$start_date,$para = '')
    {
        $getLastSyncData = Azlastsync::getLastSync($sellerDetails['sellerId'],'Eventgroup',$sellerDetails['region']);     
        if(!empty($start_date)){
            $CreatedAfter = date("Y-m-d\TH:i:s\Z", strtotime($start_date));
        }else if($para == 'dbDataProcess'){
            $groupData = Azfinancialeventgroup::where('seller_id',$sellerDetails['sellerId'])->where(function($query){
                    $query->where('original_total_currency','');
                    $query->orWhereNULL('original_total_currency');
            })->first(); 
            if($groupData){
                $CreatedAfter = date("Y-m-d\TH:i:s\Z", strtotime($groupData->financial_event_group_start));
            }else{
                $CreatedAfter = '';
            }
        }else if(!empty($getLastSyncData)){
            $CreatedAfter = date("Y-m-d\TH:i:s\Z", strtotime($getLastSyncData['LastPurchaseDate']));
        }else{
            $CreatedAfter = date("Y-m-d\TH:i:s\Z", strtotime($sellerDetails['sync_start_date']));
        }
        return $CreatedAfter;      
    }

    public function processFinancialEventGroupsData($FinancialGroupEventRanges,$sellerDetails,$financialEventGroupDate)
    {
        $LastPurchaseDate = '';
        $date_array = array();
        $financialGroupData = $FinancialGroupEventRanges->getFinancialEventGroupList();
        foreach($financialGroupData as $key=>$value)
        {
            if($value['processing_status'] == 'Closed'){
                $LastPurchaseDate = $this->storeFinacialGroupDataInDB($sellerDetails,$value,$LastPurchaseDate);  
            }
            $date_array [] = $LastPurchaseDate;   
        }
        $nextToken = $FinancialGroupEventRanges->getNextToken(); 
        if(!empty($nextToken)){
            list($TokenData) = $this->getFinancialGroupEventRanges($sellerDetails,$financialEventGroupDate,'',$nextToken);
            if(!empty($TokenData)){
                $this->processFinancialEventGroupsData($TokenData,$sellerDetails,$financialEventGroupDate);
            }
        }
        if(!empty($date_array)){
            $unix = array_map('strtotime', $date_array);
            $LastPurchaseDate = date('Y-m-d H:i:s', max($unix));
        }
        if(!empty($LastPurchaseDate)){
            $this->setFinancialGroupEventLastSync($sellerDetails,$LastPurchaseDate,'Eventgroup');    
        }
        return true;
    }

    public function storeFinacialGroupDataInDB($sellerDetails,$value,$LastPurchaseDate)
    {
        $checkDataExist = Azfinancialeventgroup::checkExistOfFinancialGroupEventEntry($sellerDetails['sellerId'],$sellerDetails['module'],$value['financial_event_group_id']);
        if(empty($checkDataExist)){
            $checkDataExist = new Azfinancialeventgroup();
        }
        $checkDataExist->seller_id = $sellerDetails['sellerId'];
        $checkDataExist->module = $sellerDetails['module'];
        if(!empty($value['financial_event_group_id']))
        $checkDataExist->financial_event_group_id = $value['financial_event_group_id'];
        if(!empty($value['processing_status']))
        $checkDataExist->processing_status = $value['processing_status'];
        if(!empty($value['fund_transfer_status']))
        $checkDataExist->fund_transfer_status = $value['fund_transfer_status'];
        if(!empty($value['original_total']['currency_amount']))
        $checkDataExist->original_total_amount = $value['original_total']['currency_amount'];
        if(!empty($value['original_total']['currency_code']))
        $checkDataExist->original_total_currency = $value['original_total']['currency_code'];
        if(!empty($value['converted_total']['currency_amount']))
        $checkDataExist->converted_total_amount = $value['converted_total']['currency_amount'];
        if(!empty($value['converted_total']['currency_code']))
        $checkDataExist->converted_total_currency = $value['converted_total']['currency_code'];
        if(!empty($value['fund_transfer_date']))
        $checkDataExist->fund_transfer_date = $value['fund_transfer_date'];
        if(!empty($value['financial_event_group_start']))
        $checkDataExist->financial_event_group_start = $value['financial_event_group_start'];
        if(!empty($value['financial_event_group_end']))
        $checkDataExist->financial_event_group_end = $value['financial_event_group_end'];
        if(!empty($value['trace_id']))
        $checkDataExist->trace_id = $value['trace_id'];
        if(!empty($value['account_tail']))
        $checkDataExist->account_tail = $value['account_tail'];
        if(!empty($value['beginning_balance']['currency_amount']))
        $checkDataExist->beginning_balance_amount = $value['beginning_balance']['currency_amount'];
        if(!empty($value['beginning_balance']['currency_code']))
        $checkDataExist->beginning_balance_currency = $value['beginning_balance']['currency_code'];
        $checkDataExist->updated_at = date('Y-m-d H:i:s');
        $checkDataExist->save();

        if($checkDataExist->fund_transfer_status == 'Succeeded'){
            //check entry in az_financial_reports table for mapping
            $checkReportEntry = Azfinancialreport::where('seller_id',$sellerDetails['sellerId'])->where('start_date',$checkDataExist->financial_event_group_start)
                                ->where('end_date',$checkDataExist->financial_event_group_end)->where('total_amount', $checkDataExist->original_total_amount)->where('currency',$checkDataExist->original_total_currency)->first();
            if(!empty($checkReportEntry)){
                $checkReportEntry->financial_event_groups_id = $checkDataExist->id;
                $checkReportEntry->save();
                $checkDataExist->mapped = 'Y';
                $checkDataExist->save();
            }                    
        }
        $lastPurchaseDate = (!empty($value['financial_event_group_start'])) ? $value['financial_event_group_start'] : '';
        return $lastPurchaseDate;
    }

    public function setFinancialGroupEventLastSync($sellerDetails,$LastPurchaseDate,$type)
    {
        $lastSyncData = Azlastsync::getLastSync($sellerDetails['sellerId'],$type,$sellerDetails['region']);     
        if($lastSyncData){   
            $lastSyncData->LastPurchaseDate = date('Y-m-d H:i:s',strtotime($LastPurchaseDate));
            $lastSyncData->LastUpdateDate = date('Y-m-d H:i:s',strtotime($LastPurchaseDate));
            $lastSyncData->save();
        }else{
            $lastSyncObj = new Azlastsync();
            $lastSyncObj->seller_id = $sellerDetails['seller_id'];
            $lastSyncObj->seller_marketplace_id = $sellerDetails['region'];
            $lastSyncObj->LastPurchaseDate = date('Y-m-d H:i:s',strtotime($LastPurchaseDate));
            $lastSyncObj->LastUpdateDate = date('Y-m-d H:i:s',strtotime($LastPurchaseDate));
            $lastSyncObj->sync_type = $type;
            $lastSyncObj->save();
        }      
        return true;    
    }

    public function getFinancialGroupEventRanges($sellerDetails,$financialEventGroupDate,$financialEventGroupEndDate = '',$next_token='')
    {
        $config = app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\ApiController')->getCommonConfigDetails($sellerDetails);
        try{
            if($financialEventGroupEndDate == '')
                $enddate = null;
            else
                $enddate = $financialEventGroupEndDate;
            $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\FinancesApi($config);
            $result = $apiInstance->listFinancialEventGroups(null,$financialEventGroupEndDate,$financialEventGroupDate,$next_token);
            $event_group_result = $result->getPayload();
        }catch (\Exception $e) {
            return array(array());
        }
        return array($event_group_result);
    }

    public function fetchFinancialDocument(Request $request){
        $sellerid = Helper::encryptor('decrypt',$request->sellerid);
        $seller = Azsellers::find($sellerid);
        
        $connection_name = ( strpos($seller->module,'xo') !== false )  ? 'xero_credential' : (strpos($seller->module,'sg') !== false ? 'sage_credential' : '');

        if(strpos($seller->module,'xo') !== false){
            $connection_name = 'xero_credential';
        } else if(strpos($seller->module,'sg') !== false){
            $connection_name = 'sage_credential';
        } else if(strpos($seller->module,'qb') !== false){
            $connection_name = 'qbo_credential';
        }

        if($seller->sync_type == 'Summary'){
            if(strpos($seller->module,'sg') !== false)
            $setting_name = 'sg_summary_sync_settings';
            if(strpos($seller->module,'xo') !== false)
            $setting_name = 'xo_summary_sync_settings';
            if(strpos($seller->module,'qb') !== false)
            $setting_name = 'qbo_summary_setting';
        }
        else{
            if(strpos($seller->module,'sg') !== false)
            $setting_name = 'sg_sync_settings';
            if(strpos($seller->module,'xo') !== false)
            $setting_name = 'xo_sync_settings';
        }
        $sellerDetails = Azsellers::getSellerDetail($sellerid,$connection_name,$setting_name,$seller->module);
        $sellerDetails = $sellerDetails->toArray()[0];

        $this->getReportFromReportGroups($sellerDetails);       
        echo 'success';
        exit;
    }
}