<?php
namespace App\Http\Controllers\Ecomtoacc\Common;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Tally\Tysummaryfees;
use Log;

class CommonFeesSyncController extends Controller
{        
    /*
    * Common function for sync marketplace events to master db 
    * Manali Patel - 05/05/2023
    */
    public function saveFeesToMaster($module, $insertArr,$sellerDetails){
        $updateFlg = false;  
        
	   if(strpos($module,'tl') !== false){
            $eventExist = Tysummaryfees::fetchTallyFeesById($module, $insertArr['marketplace_primary_id'],$insertArr['tally_summary_id'],$insertArr['seller_id'],$insertArr['invoice_date']);  
            if(empty($eventExist)){
                $eventExist = new Tysummaryfees();
                $eventExist->module = $module;
                $eventExist->seller_id = array_key_exists('seller_id', $insertArr) ? $insertArr['seller_id'] : '';
                $eventExist->marketplace_primary_id = array_key_exists('marketplace_primary_id', $insertArr) ? $insertArr['marketplace_primary_id'] : '';  // Primary key of marketplace order table   
                $eventExist->tally_summary_id = array_key_exists('tally_summary_id', $insertArr) ? $insertArr['tally_summary_id'] : '';  // Primary key of marketplace order table   
                $eventExist->sync_flag = array_key_exists('sync_flag',$insertArr) ? $insertArr['sync_flag'] : 'N';
                $eventExist->sync_status = array_key_exists('sync_status',$insertArr) ? $insertArr['sync_status'] : 'New';  
            }
            $sync_id = $eventExist->tally_id;
        }
    
        $eventExist->gateway = array_key_exists('gateway',$insertArr) ? $insertArr['gateway'] : '';
        $eventExist->document_number = array_key_exists('document_number',$insertArr) ? $insertArr['document_number'] : '';
        $eventExist->invoice_date = array_key_exists('invoice_date',$insertArr) ? $insertArr['invoice_date'] : '';
        $eventExist->total_amount = array_key_exists('total_amount',$insertArr) ? $insertArr['total_amount'] : '';
        $eventExist->json_amount = array_key_exists('json_amount',$insertArr) ? $insertArr['json_amount'] : '';
        $eventExist->currency = array_key_exists('currency',$insertArr) ? $insertArr['currency'] : '';
        $eventExist->country_code = array_key_exists('country_code',$insertArr) ? $insertArr['country_code'] : '';
        $eventExist->data = array_key_exists('data',$insertArr) ? $insertArr['data'] : '';
        $eventExist->tax_type = array_key_exists('tax_type',$insertArr) ? $insertArr['tax_type'] : '';

        if(strpos($module,'tl') !== false){
            if(empty($eventExist->tally_id)){
                $eventExist->tally_id = array_key_exists('tally_id',$insertArr) ? $insertArr['tally_id'] : NULL;
            }else{
                if(isset($insertArr['sync_status'])){
                    if($insertArr['sync_status'] == 'Pending')
                    $eventExist->sync_status == 'New';
                    else
                    $eventExist->sync_flag = 'U';
                }else{
                    $eventExist->sync_flag = 'U';
                }
            }
        }
        
        if(empty($sync_id) && array_key_exists('snr_status', $insertArr)){
            if($insertArr['snr_status'] == true)
                $eventExist->sync_status = 'SNR';
            else if($eventExist->sync_status == 'SNR')
                $eventExist->sync_status = 'New';
        }
        $eventExist->save();
        return $eventExist->id;
    }
}