<?php
namespace App\Http\Controllers\Ecomtoacc\Common;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Helpers\Helper;
use App\Models\Tally\Tysummary;
use Log;

class CommonEventSyncController extends Controller
{        
    /*
    * Common function for sync marketplace events to master db 
    * Manali Patel - 05/05/2023
    */
    public function saveEventsToMaster($module, $insertArr,$sellerDetails){
        $updateFlg = false;  
          
        if(strpos($module,'tl') !== false){
            $eventExist = Tysummary::fetchTallyInvoiceById($module, $insertArr['marketplace_primary_id'],$insertArr['seller_id']);  
            if(empty($eventExist)){
                $eventExist = new Tysummary();
                $eventExist->module = $module;
                $eventExist->seller_id = array_key_exists('seller_id', $insertArr) ? $insertArr['seller_id'] : '';
                $eventExist->marketplace_primary_id = array_key_exists('marketplace_primary_id', $insertArr) ? $insertArr['marketplace_primary_id'] : '';  // Primary key of marketplace order table   
                $eventExist->sync_flag = array_key_exists('sync_flag',$insertArr) ? $insertArr['sync_flag'] : 'N';
                $eventExist->sync_status = array_key_exists('sync_status',$insertArr) ? $insertArr['sync_status'] : 'New';  
            }
            $eventExist->marketplace_record_type = 'payout';  
            $eventExist->country_code = array_key_exists('country_code',$insertArr) ? $insertArr['country_code'] : '';
            $eventExist->json_amount = array_key_exists('json_amount',$insertArr) ? $insertArr['json_amount'] : '';  
            $sync_id = $eventExist->tally_id;
            $eventExist->payout_id = array_key_exists('payout_id',$insertArr) ? $insertArr['payout_id'] : '';
            $eventExist->reference = array_key_exists('reference',$insertArr) ? $insertArr['reference'] : '';
            $eventExist->gateway = 'amazon';
            $eventExist->settlement_amount = array_key_exists('settlement_amount',$insertArr) ? $insertArr['settlement_amount'] : '';
        }
    
        $eventExist->document_number = array_key_exists('document_number',$insertArr) ? $insertArr['document_number'] : '';
        $eventExist->invoice_date = array_key_exists('invoice_date',$insertArr) ? $insertArr['invoice_date'] : '';
        $eventExist->start_date = array_key_exists('start_date',$insertArr) ? $insertArr['start_date'] : '';
        $eventExist->end_date = array_key_exists('end_date',$insertArr) ? $insertArr['end_date'] : '';
        $eventExist->total_amount = array_key_exists('total_amount',$insertArr) ? $insertArr['total_amount'] : '';
        $eventExist->currency = array_key_exists('currency',$insertArr) ? $insertArr['currency'] : '';
        $eventExist->data = array_key_exists('data',$insertArr) ? $insertArr['data'] : '';
        $eventExist->tax_type = array_key_exists('tax_type',$insertArr) ? $insertArr['tax_type'] : '';
        
        if(strpos($module,'tl') !== false){
            if(empty($eventExist->tally_id)){
                $eventExist->tally_id = array_key_exists('tally_id',$insertArr) ? $insertArr['tally_id'] : NULL;
            }else{
                if(@$insertArr['sync_status'] == 'Pending'){
                    $eventExist->sync_status == 'New';
                }else{
                        if( ($insertArr['total_amount'] != $insertArr['json_amount']) || ($insertArr['json_amount'] == 0 && $insertArr['total_amount'] == 0) ){
                        $eventExist->sync_flag = 'U';
                    }
                }
            }
        }
        if(empty($sync_id) && array_key_exists('snr_status', $insertArr)){
            if($insertArr['snr_status'] == true)
                $eventExist->sync_status = 'SNR';
            else if($eventExist->sync_status == 'SNR')
                $eventExist->sync_status = 'New';
        }
        $eventExist->save();
        return $eventExist->id;
    }
}