<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use App\Helpers\Helper;
use App\Models\Master\Country;
use App\Models\Master\State;
use App\Models\Tally\Tyconnections;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function cronActionLog($seller_id, $module, $message, $uniqueId){
    	
    }

    public static function fetchStripeKeyCredential($seller_id = "")
    {
        return array(env('STRIPE_KEY_TEST'),'test');
    }

    public static function fetchStripeCredential($seller_id = "")
    {
        return env('STRIPE_SECRET_TEST');
        /*$testStoreArray = Testcredentialseller::pluck("az_sellerid")->toArray();
        $seller = Sellers::where('id',$seller_id)->first();
        if(!empty($seller->az_seller_id) && in_array($seller->az_seller_id, $testStoreArray))
        {   //test
            return env('STRIPE_SECRET_TEST');
        }
        else
        {
            return env('STRIPE_SECRET_LIVE');
            // return env('STRIPE_SECRET_TEST');
        }*/
    } 

    public function getCountry(){      
      $country = Country::select('countryCode2','countryName')->where('parentId','0')->get();     
      return $country;
    }

    public function getState(){
      $state = State::select('stateCode','stateName')->where('countryId','226')->get();     
      return $state; 
    }

    public function getCurlCall($url,$headers){
        
        $response = $error = array();
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL            => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_HTTPHEADER     => $headers,
          CURLOPT_CUSTOMREQUEST  => 'GET',
          CURLOPT_SSL_VERIFYPEER => false,
          CURLOPT_SSL_VERIFYHOST => false,
          CURLOPT_AUTOREFERER    => true,  
          CURLOPT_CONNECTTIMEOUT => 120,
          CURLOPT_TIMEOUT        => 120,   
          CURLOPT_MAXREDIRS      => 10,  
          CURLOPT_POST => true
        ));
        curl_setopt( $curl, CURLOPT_POSTFIELDS, array());
        $response = curl_exec($curl);
        curl_close($curl);        
        
        $api_response = json_decode($response,true);
        if(isset($api_response['error'])){
          $error = $api_response;
        }else{
          $response = $api_response;
        }
        return array($response,$error);
    }

    public function postCurlCall($url,$headers,$postFields){
        
        $response = $error = array();
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER     => $headers,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_AUTOREFERER    => true,  
            CURLOPT_CONNECTTIMEOUT => 120,
            CURLOPT_TIMEOUT        => 120,   
            CURLOPT_MAXREDIRS      => 10,  
            CURLOPT_POSTFIELDS => http_build_query($postFields),
            CURLOPT_POST => true
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $api_response = json_decode($response,true);
        if(isset($api_response['error'])){
            $error = $api_response;
        }else{
            $response = $api_response;
        }
        return array($response,$error);
    }
    /*
      Manali Patel - 05/05/2023
      Check for accounting system connection
    */
    public function checkForConnection($seller_id, $module){

        $connected = [];        
        if(strpos($module,'tl') !== false){
            $connected = Tyconnections::checkTallyConnected($seller_id,$module);
        } 
        return $connected;
    }
    public function xml2array($xmlObject)
    {
      $out = array();
        foreach ( (array) $xmlObject as $index => $node )
            $out[$index] = ( is_object ( $node ) ) ? $this->xml2array ( $node ) : $node;

        return $out;
    }
}
