<?php

namespace App\Http\Controllers\Amazon\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Master\UserSellers;
use App\Models\Amazon\Azsellers;
use App\Models\Amazon\Marketplace;
use App\Models\Amazon\Useractionlog;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use View;
use Log;
use Auth;
use Session;
use DateTime;
use DateTimeZone;

class AuthController extends Controller
{
   public function appAuth(Request $request)
   {  
        $authorizeState = explode('@', $request->get('state'));
        $authModule = $authorizeState[0];
        $code = $request->get('code');
        
        $azAccessTokenData = app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\ApiController')->getAmazonAccessToken($code);
        
        $seller_id = $this->userSellerManage($azAccessTokenData,$authorizeState);
        
        if(is_numeric($seller_id)){ 
            $seller_id_enc = Helper::encryptor("encrypt",$seller_id);
            echo redirect()->route("plans",array("seller_id"=>$seller_id_enc))->with('success', "Seller created successfully");      
        }else{
          echo $seller_id;
        }
    }

    public function userSellerManage($AccessTokenData,$authorizeState){

        $module = $authorizeState[0];
        $country = $authorizeState[1];
        $currency = (isset(config('ecomtoacc.amazon.SELLER_CURRENCY')[$country])) ?  config('ecomtoacc.amazon.SELLER_CURRENCY')[$country] : '' ;
        $time_zone = (isset(config('ecomtoacc.amazon.SELLER_TIME_ZONE')[$country])) ?  config('ecomtoacc.amazon.SELLER_TIME_ZONE')[$country] : '' ;
        
        $region = config('ecomtoacc.amazon.SELLER_REGIONS')[$country];

        $marketplaceFetchData = array();
        $marketplaceFetchData['az_access_token'] = $AccessTokenData['access_token'];
        $marketplaceFetchData['az_refresh_token'] = $AccessTokenData['refresh_token'];
        $marketplaceFetchData['az_expire_in'] = strtotime('now') + $AccessTokenData['expires_in'];
        
        $marketPlaceInformation = app('App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\ApiController')->getMarketplaceInformation($marketplaceFetchData,$region);
        
        if(!empty($marketPlaceInformation)){
            
            $sellersData = new Sellers;
            $sellersData->seller_name = $seller_name;
            $sellersData->seller_display_name = $seller_name;
            $sellersData->az_seller_id = '';       
            $sellersData->az_app_token = '';     
            $sellersData->marketplace_name = $module;
            $sellersData->country = $country;
            $sellersData->currency = $currency;
            $sellersData->time_zone = $time_zone;  
            $sellersData->status = 'Active';
            $sellersData->save();

            $sellerID = $sellersData->id;

            $userId = Helper::encryptor('decrypt',$authorizeState[2]);
            if(isset(Auth::user()->id) && empty($userId))
            $userId = Auth::user()->id; 

            $SellersIntData = UserSellers::getUserSellerInfo($sellersData->id,$userId);  
            if(empty($SellersIntData)){
              $SellersIntData = new UserSellers;
              $SellersIntData->user_id  = $userId;
              $SellersIntData->seller_id = $sellerID;
              $SellersIntData->role = 'Owner';
            }else{
              $SellersIntData->status = 'Active';
            }
            $SellersIntData->save();

            $UseractionlogObj = new Useractionlog();           
            $UseractionlogObj->user_id = $userId;
            $UseractionlogObj->seller_id = $sellerID;
            $UseractionlogObj->action = 'Seller Created - '.$sellersData->id;
            $UseractionlogObj->save();

            $AzSellerData = new Azsellers;
            $AzSellerData->id = $sellerID;
            $AzSellerData->seller_name = $seller_name;
            $AzSellerData->country = $country;
            $AzSellerData->currency = $currency;
            $AzSellerData->time_zone = $time_zone;
            $AzSellerData->az_access_token = $AccessTokenData['access_token'];
            $AzSellerData->az_refresh_token = $AccessTokenData['refresh_token'];
            $AzSellerData->az_expire_in = strtotime('now') + $AccessTokenData['expires_in'];
            $AzSellerData->az_app_type = 'SPAPI';
            $AzSellerData->module = $module;
            if($country != 'US')
                $AzSellerData->tax_method = 'default';
            else
                $AzSellerData->tax_method = 'line';

            $AzSellerData->status = 'Active';
            $AzSellerData->save();

            /*save marketplaces*/
            foreach ($marketPlaceInformation as $key => $value) {
    	        $marketplace_data = $value->getMarketplace();
                $Marketplace = new Marketplace();
                $Marketplace->seller_id = $sellerID;
                $Marketplace->az_marketplace_id = $marketplace_data['id'];
                $Marketplace->az_marketplace_name = $marketplace_data['name'];
                $Marketplace->country = $marketplace_data['country_code'];
                $Marketplace->currency = $marketplace_data['default_currency_code'];
                if(array_key_exists($marketplace_data['country_code'], config('ecomtoacc.amazon.SELLER_REGIONS'))){
                    $Marketplace->region = config('ecomtoacc.amazon.SELLER_REGIONS')[$marketplace_data['country_code']];
                } else {
                    $authLog = new Logger('Log');
                    $authLog->pushHandler(new StreamHandler(storage_path('logs/handle/'.date("Y-m-d").'.log')), Logger::INFO);
                    $authLog->info('Amazonxo region not found in config : ',array('seller_id'=>$sellerID, 'country_code' => $marketplace_data['country_code'], 'marketplace_id' => $marketplace_data['id']));
                }
                $Marketplace->save();
            }
            $Marketplace = new Marketplace();
            $Marketplace->seller_id = $sellerID;
            $Marketplace->az_marketplace_id = $marketplace_data['id'];
            $Marketplace->az_marketplace_name = $marketplace_data['name'];
            $Marketplace->country = 'GB';
            $Marketplace->currency = 'GBP';
            $Marketplace->region = config('ecomtoacc.amazon.SELLER_REGIONS')['GB'];
            $Marketplace->save();

            /* save seller history */
            $SellerHistory = new SellerHistory;
            $SellerHistory->user_id = $userId;
            $SellerHistory->seller_id = $sellerID;
            $SellerHistory->module = $module;
            $SellerHistory->action = 'install';
            $SellerHistory->save();
            
            return $sellerID;
        }
        return false;
    }
    
}
