<html lang="en">
    <!--begin::Head-->
    <head>
        <title>Parex Bridge</title>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!--begin::Fonts-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
        <!--end::Fonts-->
        <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logos/parexfavicon.png')); ?>" type="image/png">
        <link href="<?php echo e(asset('assets/css/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
        <!--begin::Global Stylesheets Bundle(used by all pages)-->
        <link href="<?php echo e(asset('assets/css/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('assets/css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet" type="text/css" />

        <!-- <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" /> -->
        
        <!--end::Global Stylesheets Bundle-->
        <?php if(isset($REQUEST['shop'])): ?>
            <script src="https://unpkg.com/@shopify/app-bridge@3.4.3/umd/index.js"></script>
        <?php endif; ?>
    </head>
    <!-- <body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed"> -->
    <body id="kt_body" class="<?php echo e((!isset($_GET['shop'])) ? 'header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed' : ''); ?>">
        <div class="d-flex flex-column flex-root">
            <div class="page d-flex flex-row flex-column-fluid">
                <!--begin::Sidemenu-->
                <?php if(!isset($_GET['shop'])): ?>
                    <?php echo $__env->make('layouts/sidemenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <!--end::Sidemenu-->
                <div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
                    <!--begin::Header-->
                    <?php if(!isset($_GET['shop'])): ?>
                        <?php echo $__env->make('layouts/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!--end::Header-->

                    <!--begin::Toolbar-->
                    <div class="toolbar py-2" id="kt_toolbar">
                        <div id="kt_toolbar_container" class="container-fluid d-flex align-items-center">
                            <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                                <h1 class="d-flex align-items-center text-dark fw-bolder my-1 fs-3"><?php echo $__env->yieldContent('title'); ?></h1>
                                <span class="h-20px border-gray-200 border-start mx-3"></span>
                            </div>
                            <div class="flex-grow-1 flex-shrink-0 me-5">
                                
                            </div>
                        </div>
                    </div>
                    <!--end::Toolbar-->
                    <!--begin::Content-->
                    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
                        <!--begin::Container-->
                        <div id="kt_content_container" class="container-xxl">
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                        <!--end::Container-->
                    </div>
                    <!--end::Content-->
                    <!--begin::Footer-->
                    <?php if(!isset($_GET['shop'])): ?>
                        <?php echo $__env->make('layouts/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!--end::Footer-->
                </div>
            </div>
        </div>
        <?php if(isset($REQUEST['shop'])): ?>
        <script type="text/javascript">
            var AppBridge = window['app-bridge'];
            var createApp = AppBridge.default;

            <?php
                $spyData = [];
                if(!empty($shop))
                    $spyData = DB::table('spy_credential')->where("store_domain",$shop)->first(); 
            ?>

            var app = createApp({
              apiKey: '<?php echo e(config("shopify.ShopiFyapiKey")); ?>',
              host : '<?php echo e($spyData->host); ?>'
            });
        </script>
        <?php endif; ?>
        <script src="<?php echo e(asset('assets/js/plugins.bundle.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/scripts.bundle.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/widgets.bundle.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/custom/widgets.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/jquery.validate.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/plugins/jqueryblockui/jquery.blockui.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
        
        <?php echo $__env->yieldContent('more_scripts'); ?>
        <script type="text/javascript">
            $(document).ready(function () {
              setTimeout(function () {
                 $("#success-alert").hide().removeClass('d-flex');
              }, 3000);

              $(document).on('click','.close', function(){
                $(".modal").modal('hide');
              });


                $('.nav-tabs > li a[title]').tooltip();
                
                $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

                    var $target = $(e.target);
                
                    if ($target.parent().hasClass('disabled')) {
                        return false;
                    }
                });

            });

            function startLoading(msg=""){
                if(msg == "")
                  msg = "Please wait ..."
                $.blockUI({ 
                  css: { 
                      border: 'none', 
                      padding: '15px', 
                      backgroundColor: '#444349', 
                      '-webkit-border-radius': '10px', 
                      '-moz-border-radius': '10px', 
                      opacity: .6, 
                      color: '#fff' 
                  },
                  overlayCSS:  { 
                        backgroundColor: '#444349', 
                        opacity:         0.6 
                    },
                  message: '<div align="center"><img src="<?php echo e(config('app.url')); ?>/assets/images/loading.gif" alt="Loading" style="margin-bottom: 10px;"/><div>'+msg+'</div></div>'
                });
            }
            function stopLoading() {      
                setTimeout($.unblockUI, 20); 
            }

      </script>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\ecomm2db\resources\views/layouts/default.blade.php ENDPATH**/ ?>