
<?php $__env->startSection('title'); ?>
Tally Connection - <?php echo e($seller_details->seller_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="connect_page">
   <div class="card" id="kt_conenct">
      <!--begin::Card body-->
      <div class="card-body p-lg-10">
          <!--begin::Plans-->
          <div class="d-flex flex-column">
              <!--begin::Heading-->
              <div class="mb-5 text-center">
                  <h1 class="fw-bolder mb-5">Connect your Tally account</h1>
                  <div class="text-gray-400 fw-bold fs-5"></div>
              </div>
              <!--end::Heading-->
              <!--begin::Row-->
              <div class="row g-10">
                  <div class="col-md-12 text-center connection-img">
                    <?php if($module == 'tlaz'): ?>
                      <img src="<?php echo e(asset('assets/images/az-tl-connection.png')); ?>" width="300">
                    <?php endif; ?>
                  </div>
                  <div class="col-md-12">
                  <div>
                    <h4>Instructions to Setup the app with your Tally file</h4>
                  </div>
                  <ol>
                    <li>Please make sure you have the Tally application version installed and open in the computer you wish to do the sync.</li>
                    <li>Open the company in Tally which you would like to integrate with this app.</li>
                    <li>Download the PTG file by clicking on the Download button here. <button class="btn btn-primary btn-sm" type="button" onclick="generatePTGFile()" style="    padding: calc(0.45rem + 1px) calc(0.8rem + 1px);">Download</button>
                    </li>
                    <li>A PTG File will be generated and downloaded to your system. In case it does not download automatically, please check if it is stopped by any blocker in your browser.</li>
                    <li>If you plan to use this on a PC/Server other than where it was download, please copy this file to that PC/Server before proceeding further and complete the next steps from that PC/server.</li>
                    <li>Double-click on the PTG file. If the Tally and Tally webconnector is properly setup in your PC/Server, this file will be recognized and a Wizard will open in the Tally software.</li>
                    <li>If the setup is smooth, our application will be displayed in the Tally Web Connector window. If you have multiple integrations, Click the relevant row, else click first check box.</li>
                    <li>Click on Update Selected button for the correct row and wait to for the validation process to complete.</li>
                    <li>When you click on the Update Selected button, it will execute some basic queries to check that a proper communication is established between our Server to your Tally file. It will also fetch the required data from your company file necessary to setup the system.</li>
                    <li>Once the process complete in Tally web connector on your PC/server, click on Test Connection button below to verify that communication is established successfully.</li>
                    <li>If connection is setup successfully, a Setup button will become visible. Please click on the Setup button to proceed to the application Settings page.</li>
                  </ol>
                </div>

                <?php if(isset($downloadFile) && !empty($downloadFile) && $downloadFile == 'yes'): ?>
                  <div class="col-md-4 text-left mb-10" id="settingsBtn">
                      <a class="btn btn-info btn-sm" href="<?php echo e(@$settingUrl); ?>">Setup Settings</a>
                  </div>
                <?php else: ?>
                  <div class="col-md-2 text-left mb-10 hidden" id="proccedNext">
                      <button class="btn btn-success btn-sm" onclick="testConnection()" id="testConnection">Test Connection</button>
                      <a class="btn btn-info btn-sm hidden" href="<?php echo e(route('tyauth',array('seller_id' => $seller_id))); ?>" id="next-step">Setup Company</a>
                  </div>
                <?php endif; ?>
              </div>
              <!--end::Row-->
          </div>
          <!--end::Plans-->
      </div>
      <!--end::Card body-->
    </div>
</div>
<div class="modal fade" id="mdlTestConnection" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Test Connection</h4>
        <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times fa-lg"></i></a>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <p id="testConnectionMsg"></p>
          </div>            
        </div>
      </div>
      <div class="modal-footer">
        <a href="javascript:void(0);" class="btn btn-primary close" data-dismiss="modal">Ok</a>
      </div>
    </div>
  </div>
</div>  
<?php $__env->stopSection(); ?>
<?php $__env->startSection('more_scripts'); ?>
<script type="text/javascript">
  function testConnection(){
    $.ajax({
        type: 'GET',
        url: "<?php echo e(route('checktallyconnection')); ?>?seller_id=<?php echo e($seller_id); ?>", 
        data:"",
        success:function( data ) 
        { 
          stopLoading();
          if(data.success == true){
            $("#next-step").removeClass("hidden");
            $("#testConnection").addClass("hidden");              

            $('#testConnectionMsg').text(data.message);
            $('#mdlTestConnection').modal('show');
          }else{
            if(data.data == 'updatecompany'){
              $("#next-step").removeClass("hidden");
              $("#testConnection").addClass("hidden");
            } else {
              $('#testConnectionMsg').text(data.message);
              $('#mdlTestConnection').modal('show');               
            }
          }
        },
        error : function(error)
        {
        }
    });
  }

  function generatePTGFile() 
  {
      <?php if(isset($downloadFile) && !empty($downloadFile) && $downloadFile == 'yes'): ?>
        var url = "<?php echo e(route("generateptgfile")); ?>?seller_id=<?php echo e($seller_id); ?>&downloadFile=yes";
      <?php else: ?>
        var url = "<?php echo e(route("generateptgfile")); ?>?seller_id=<?php echo e($seller_id); ?>";
      <?php endif; ?>
      
       $.ajax({
            type: 'GET',
            url: url, 
            data:"",
            success:function( data ) 
            {
                var element = document.createElement('a');
                element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(data.content));
                element.setAttribute('download', data.fileName);
                element.click();

                $("#proccedNext").removeClass('hidden');
                <?php if(isset($downloadFile) && !empty($downloadFile) && $downloadFile == 'yes'): ?>
                  $("#settingsBtn").removeClass("hidden");
                <?php endif; ?>
            },
            error : function(xhr,status,error)
            {
               console.log(error);
            }
      });
  }

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\ecomm2db\resources\views/tally/connection/connect.blade.php ENDPATH**/ ?>