<?php

use Illuminate\Support\Facades\Route;

Route::group([ 'prefix' => 'tally','middleware' => ['auth', 'web']], function () {

	Route::group([ 'prefix' => 'auth','middleware' => ['auth', 'web']], function () {
		Route::get('/checktallyconnection', [App\Http\Controllers\Master\Connection\TallyConnectionController::class, 'checkTallyConnection'])->name('checktallyconnection');
		Route::get('/generateptgfile', [App\Http\Controllers\Master\Connection\TallyConnectionController::class, 'generatePtgFile'])->name('generateptgfile');
		Route::post('/updatecompany', [App\Http\Controllers\Master\Connection\TallyConnectionController::class, 'updateCompany'])->name('updatecompany');
	});

	Route::get('/accountdetails', [App\Http\Controllers\Tally\Tlsellers\TallySellersController::class, 'accountDetails'])->name('tlaccountdetails');	
	Route::get('/settings', [App\Http\Controllers\Tally\Settings\TallySettingsController::class, 'index'])->name('tlsettings');
	Route::post('/storesetting', [App\Http\Controllers\Tally\Settings\TallySettingsController::class, 'storeSettings'])->name('storesetting');
	Route::post('/createsummaryaccounts', [App\Http\Controllers\Tally\Settings\TallySettingsController::class, 'createSummaryAccounts'])->name('createsummaryaccounts');
	Route::get('/checkqueuestatus', [App\Http\Controllers\Master\Connection\TallyConnectionController::class, 'checkQueueStatus'])->name('checkqueuestatus');
	Route::get('/summaryfetchrequest', [App\Http\Controllers\Tally\Tlsellers\TallySellersController::class, 'summaryFetchRequest'])->name('summaryfetchrequest');	
	
});
