<?php

use Illuminate\Support\Facades\Route;

Route::group([ 'prefix' => 'ecomtoacc','middleware' => ['web']], function () {
	Route::group([ 'prefix' => 'shopify','middleware' => ['web']], function () {
		Route::get('/fetchspyorders', [App\Http\Controllers\Ecomtoacc\Shopify\OrderController::class, 'fetchSpyOrders'])->name('fetchspyorders');
		Route::get('/fetchspypayouts', [App\Http\Controllers\Ecomtoacc\Shopify\PayoutController::class, 'fetchSpyPayouts'])->name('fetchspypayouts');
		Route::get('/generatereports', [App\Http\Controllers\Ecomtoacc\Shopify\ReportController::class, 'generateReports'])->name('generatereports');
		Route::get('/processsummaryrequest', [App\Http\Controllers\Shopify\ShopifyController::class, 'processSummaryRequest'])->name('processsummaryrequest');
	});
});

Route::group(['middleware' => ['web'],'namespace'=>'Ecomtoacc'], function () {  
	Route::group([ 'prefix' => 'ecomtodb','middleware' => ['web'],'namespace'=>'Ecomtodb'], function () {
	    Route::group([ 'prefix' => 'amazon','middleware' => ['web']], function () {    
	    	Route::get('/getfinanceevents', [App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\FinanceController::class, 'getFinanceEvents'])->name('getFinanceEvents');

	    	Route::get('/getfinancialevents', [App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\FinancialeventsController::class, 'getFinancialEvents'])->name('getFinancialEvents');

	    	Route::get('/getordersfromamazon', [App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon\OrderController::class, 'getOrdersFromAmazon'])->name('getOrdersFromAmazon');
		});	
	});

    Route::group([ 'prefix' => 'dbtoacc','middleware' => ['web'],'namespace'=>'Dbtoacc'], function () {
        Route::group([ 'prefix' => 'amazon','middleware' => ['web']], function () { 
        	Route::get('/syncdbtoacc', [App\Http\Controllers\Ecomtoacc\Dbtoacc\AmazonController::class, 'syncDbToAcc'])->name('syncDbToAcc');
        });
    });

});