@extends('layouts.default')
@section('title')
  Seller Settings - {{ @$seller_details->seller_name }}
@stop
@section('content')
<div class="setting_page">
  <div class="card" id="kt_conenct">
      <div class="card-body p-lg-10">
        <div class="d-flex flex-column">
            <div class="wizard">
              <div class="wizard-inner">
                  <div class="connecting-line"></div>
                  <div class="progress-with-circle">
                    <div class="progress-bar" role="progressbar" aria-valuenow="4" aria-valuemin="1" aria-valuemax="4" style="width: 100%;"></div>
                  </div>
                  <ul class="nav nav-tabs" role="tablist">
                      <li role="presentation" class="active">
                          <a href="#step1" data-toggle="tab" aria-controls="step1" role="tab" title="" data-original-title="Basic Settings" aria-expanded="false">
                              <span class="round-tab">
                                  <i class="fa fa-user" aria-hidden="true"></i>
                                  <p class="r_text">Basic Settings</p>
                              </span>

                          </a>
                      </li>

                      <li role="presentation" class="disabled">
                          <a href="#step2" data-toggle="tab" aria-controls="step2" role="tab" title="" data-original-title="Account & Tax Rate">
                              <span class="round-tab">
                                  <i class="fa fa-user" aria-hidden="true"></i>
                                  <p class="r_text">Account & Tax Rate</p>
                              </span>
                          </a>
                      </li>
                  </ul>
              </div>
              {!! Form::open(array('url' => '#','id' => 'create-form','autocomplete'=>'off')) !!}
                  <input type="hidden" name="seller_id" id="seller_id" value="{{ $seller_id}}">
                  <div class="tab-content">
                      <div class="tab-pane active" role="tabpanel" id="step1">
                        <div class="row ">
                            <!--begin::Wrapper-->
                            <div class="col-md-12 mb-8">
                              <div class="form-group {{ $errors->has('tlPrefix') ? ' has-error' : '' }} ">
                                <div class="next-label"><span class="fs-6 fw-bold">Tally Prefix</span> (For connecting multiple Amazon stores to one Tally account) </div>
                                <div class="row">
                                    <div class="col-md-5">
                                        <input class="form-control" type="text" name="tlPrefix" id="tlPrefix" value="{{ (!empty(@$settingData['id']))? @$settingData['prefix'] : $defaultPrefix }}" placeholder="Tally Prefix" style="text-transform: uppercase;"/>
                                    </div>
                                    <div class="col-md-12"><input type="checkbox" name="prefix_required" id="prefix_required" {{ (!empty(Input::old('prefix_required')) || @$settingData['prefix_required']=="N")? 'checked' : '' }} <?php if($editable=='false' ) echo "disabled='true'" ; ?> onclick="tallyPrefixChecked();"> Disable Prefix but Prefix is ideal if you have multiple store connected with same Tally Account
                                    </div>
                                </div>
                              </div>
                            </div>

                            <div class="col-md-12 mb-8">
                              <div class="form-group {{ $errors->has('sync_type') ? ' has-error' : '' }}">
                                <div class="next-label"><span class="fs-6 fw-bold">How do you want to account for completely paid orders?</span><span class="error">*</span></div>
                                <div class="row">
                                  <div class="col-md-5">
                                    {{ Form::select('sync_type', $syncTypeList , Input::old('sync_type', @$settingData['sync_type']), array('class'=>'form-control', 'style'=>'width:100%')) }}
                                    {!! $errors->first('sync_type', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="col-md-12 mb-8">
                              <div class="form-group {{ $errors->has('tlPrefix') ? ' has-error' : '' }} ">
                                <div class="next-label"><span class="fs-6 fw-bold">What date do you want your data sync to Tally to start from?</span><span class="error">*</span></div>
                                  <div class="row">
                                      <div class="col-xl-12 fv-row fv-plugins-icon-container">
                                          <div class="col-md-5 d-flex align-items-center">
                                              <!--begin::Svg Icon | path: icons/duotune/general/gen014.svg-->
                                              <span class="svg-icon position-absolute ms-4 mb-1 svg-icon-2">
                                                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                      <path opacity="0.3" d="M21 22H3C2.4 22 2 21.6 2 21V5C2 4.4 2.4 4 3 4H21C21.6 4 22 4.4 22 5V21C22 21.6 21.6 22 21 22Z" fill="black"></path>
                                                      <path d="M6 6C5.4 6 5 5.6 5 5V3C5 2.4 5.4 2 6 2C6.6 2 7 2.4 7 3V5C7 5.6 6.6 6 6 6ZM11 5V3C11 2.4 10.6 2 10 2C9.4 2 9 2.4 9 3V5C9 5.6 9.4 6 10 6C10.6 6 11 5.6 11 5ZM15 5V3C15 2.4 14.6 2 14 2C13.4 2 13 2.4 13 3V5C13 5.6 13.4 6 14 6C14.6 6 15 5.6 15 5ZM19 5V3C19 2.4 18.6 2 18 2C17.4 2 17 2.4 17 3V5C17 5.6 17.4 6 18 6C18.6 6 19 5.6 19 5Z" fill="black"></path>
                                                      <path d="M8.8 13.1C9.2 13.1 9.5 13 9.7 12.8C9.9 12.6 10.1 12.3 10.1 11.9C10.1 11.6 10 11.3 9.8 11.1C9.6 10.9 9.3 10.8 9 10.8C8.8 10.8 8.59999 10.8 8.39999 10.9C8.19999 11 8.1 11.1 8 11.2C7.9 11.3 7.8 11.4 7.7 11.6C7.6 11.8 7.5 11.9 7.5 12.1C7.5 12.2 7.4 12.2 7.3 12.3C7.2 12.4 7.09999 12.4 6.89999 12.4C6.69999 12.4 6.6 12.3 6.5 12.2C6.4 12.1 6.3 11.9 6.3 11.7C6.3 11.5 6.4 11.3 6.5 11.1C6.6 10.9 6.8 10.7 7 10.5C7.2 10.3 7.49999 10.1 7.89999 10C8.29999 9.90003 8.60001 9.80003 9.10001 9.80003C9.50001 9.80003 9.80001 9.90003 10.1 10C10.4 10.1 10.7 10.3 10.9 10.4C11.1 10.5 11.3 10.8 11.4 11.1C11.5 11.4 11.6 11.6 11.6 11.9C11.6 12.3 11.5 12.6 11.3 12.9C11.1 13.2 10.9 13.5 10.6 13.7C10.9 13.9 11.2 14.1 11.4 14.3C11.6 14.5 11.8 14.7 11.9 15C12 15.3 12.1 15.5 12.1 15.8C12.1 16.2 12 16.5 11.9 16.8C11.8 17.1 11.5 17.4 11.3 17.7C11.1 18 10.7 18.2 10.3 18.3C9.9 18.4 9.5 18.5 9 18.5C8.5 18.5 8.1 18.4 7.7 18.2C7.3 18 7 17.8 6.8 17.6C6.6 17.4 6.4 17.1 6.3 16.8C6.2 16.5 6.10001 16.3 6.10001 16.1C6.10001 15.9 6.2 15.7 6.3 15.6C6.4 15.5 6.6 15.4 6.8 15.4C6.9 15.4 7.00001 15.4 7.10001 15.5C7.20001 15.6 7.3 15.6 7.3 15.7C7.5 16.2 7.7 16.6 8 16.9C8.3 17.2 8.6 17.3 9 17.3C9.2 17.3 9.5 17.2 9.7 17.1C9.9 17 10.1 16.8 10.3 16.6C10.5 16.4 10.5 16.1 10.5 15.8C10.5 15.3 10.4 15 10.1 14.7C9.80001 14.4 9.50001 14.3 9.10001 14.3C9.00001 14.3 8.9 14.3 8.7 14.3C8.5 14.3 8.39999 14.3 8.39999 14.3C8.19999 14.3 7.99999 14.2 7.89999 14.1C7.79999 14 7.7 13.8 7.7 13.7C7.7 13.5 7.79999 13.4 7.89999 13.2C7.99999 13 8.2 13 8.5 13H8.8V13.1ZM15.3 17.5V12.2C14.3 13 13.6 13.3 13.3 13.3C13.1 13.3 13 13.2 12.9 13.1C12.8 13 12.7 12.8 12.7 12.6C12.7 12.4 12.8 12.3 12.9 12.2C13 12.1 13.2 12 13.6 11.8C14.1 11.6 14.5 11.3 14.7 11.1C14.9 10.9 15.2 10.6 15.5 10.3C15.8 10 15.9 9.80003 15.9 9.70003C15.9 9.60003 16.1 9.60004 16.3 9.60004C16.5 9.60004 16.7 9.70003 16.8 9.80003C16.9 9.90003 17 10.2 17 10.5V17.2C17 18 16.7 18.4 16.2 18.4C16 18.4 15.8 18.3 15.6 18.2C15.4 18.1 15.3 17.8 15.3 17.5Z" fill="black"></path>
                                                  </svg>
                                              </span>
                                              <!--end::Svg Icon-->
                                              <input class="col-md-12 form-control form-control-solid ps-12 flatpickr-input" name="sync_start_date" placeholder="Pick a date" id="sync_start_date" type="text" data-mindate="{{ $syncMinDate }}" value="{{ @$settingData['sync_start_date'] }}" <?php echo (empty($editable)) ? 'disabled="disabled"' : '' ?>>
                                              <label id="sync_start_date-error" class="col-md-12 error" for="sync_start_date" style="display: none;"></label>
                                              @if(empty($editable))
                                                  <input type="hidden" name="sync_start_date" value="{{ $settingData['sync_start_date'] }}">
                                              @endif
                                          </div>
                                          {!! $errors->first('sync_start_date', '<span class="fv-plugins-message-container invalid-feedback">:message</span>') !!}
                                          <div class="col-sm-12 form-text">Select date to fetch data from the date.</div>
                                          <div class="col-sm-12 form-text">If you prefer to sync orders before "{{ date('d M Y', strtotime($syncMinDate)) }}", please contact our support team from the Contact us page.</div>
                                          <div class="col-sm-12 form-text">There might be a small one-time fee for the backdated order sync based on the total orders required to be synced.</div>
                                          <div class="col-sm-12 form-text error">Note: Our app may not be able to recognize duplicates if you had entered them manually or with another app in the past. In that case there might be possible duplicate entries created. Please select the start date accordingly.</div>
                                          <div class="fv-plugins-message-container invalid-feedback"></div>
                                      </div>
                                  </div>
                                </div>
                            </div>

                            <div class="form-group {{ $errors->has('bank_account') ? ' has-error' : '' }}">
                              <div class="row">
                                <div class="col-md-5">
                                  <div class="next-label">Select Bank Account<span class="error">*</span></div>
                                  {{ Form::select('bank_account', $bankAccountList , Input::old('bank_account', @$settingData['bank_account']), array('class'=>'form-control', 'style'=>'width:100%','id'=>'bank_account')) }}
                                  {!! $errors->first('bank_account', '<span class="alert-msg"><i class="fa fa-times"></i> :message</span>') !!}
                                </div>
                                <p class="msgText col-md-12">Select Bank account where you receive payments.</p>                            
                              </div>
                            </div>
                            <!--end::Wrapper-->
                        </div>
                        <div class="pull-right">
                            <button type="button" class="btn btn-primary next-step">Next</button>
                        </div>
                      </div>
                      <div class="tab-pane" role="tabpanel" id="step2">
                          <div class="row">
                              <table class="table align-middle table-row-dashed fs-5 gy-3">
                                <thead class="fw-bolder text-muted">
                                  <tr>
                                    <th style="width: 30% !important;">Transaction Type</th>
                                    <th style="width: 40% !important; padding-left: 25px;">Account</th>
                                    @if($seller_details->country != "US" && $seller_details->country != "CA")
                                    <th class="taxrate_optional" style="width: 30% !important; padding-left: 25px;">Tax Rate </th>
                                    @endif
                                  </tr>
                                </thead>
                                <?php
                                  reset($setting_fields);
                                  $first_key = key($setting_fields);
                                ?>
                                @foreach($setting_fields as $key1=>$field_value1)
                                <?php                             
                                if($key1 !== $first_key){ ?>
                                <hr style="border-top: 1px solid #9d8f8f !important;">
                                <?php } ?>
                                <table class="table align-middle table-row-dashed fs-6 gy-3">
                                  @foreach($field_value1 as $key=>$field_value)
                                  @php
                                  $acc_field_name = $field_value['field_name'].'_acc';
                                  $tax_field_name = $field_value['field_name'].'_tax_rate';
                                  @endphp
                                  <tr style="width: 30% !important;">
                                    <td style="width: 30% !important;">{{$field_value['label']}} <a href="#" title="" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-dismiss="click" data-bs-placement="right" data-bs-original-title="{{$field_value['field_info']}}" class="pull-right"><i
                                          class="fa fa-info-circle" aria-hidden="true"></i></a>
                                    </td>
                                    <?php                                
                                          if($settingDataSetFlg == false){
                                            $taxfieldselect = '';
                                            if(isset($field_value['accounts']['0,'.$field_value['label']])){
                                              $fieldselect = '0,'.$field_value['label'];
                                            }else if(isset($field_value['accounts'][$field_value['label']])){
                                              $fieldselect = $field_value['accounts'][$field_value['label']];
                                            } else {                                          
                                              $fieldselect = array_keys($field_value['accounts'])[1];
                                            }
                                          }else{ 
                                              $fieldselect = @$settingData[$acc_field_name];
                                              $taxfieldselect = @$settingData[$tax_field_name];
                                          } 
                                    ?>
                                    <td style="width: 40% !important;">{{ Form::select($acc_field_name,
                                      $field_value['accounts'] , Input::old($acc_field_name, $fieldselect),
                                      array('class'=>'form-control select2 account_settings_acc',
                                      'style'=>'width:100%','id'=>$acc_field_name,'onchange'=>'defaultChange("'.$acc_field_name.'","'.$field_value['label'].'");'))
                                      }}</td>

                                    @if($seller_details->country != "US" && $seller_details->country != "CA")
                                    <td style="width: 30% !important;" class="taxrate_optional">{{
                                      Form::select($tax_field_name, $taxCodeList , Input::old($tax_field_name,
                                      $taxfieldselect), array('class'=>'form-control select2 account_settings_tax_rate',
                                      'style'=>'width:100%' , 'id'=>$tax_field_name)) }}</td>
                                    @endif
                                  </tr>
                                  @endforeach
                                </table>
                                @endforeach
                                <input name="account_settings" id="account_settings" type="hidden">
                            </table>
                          </div>
                          <div class="row mt-10">
                              <div class="col-md-12 pull-right">
                                  <button type="button" class="btn btn-secondary prev-step">Previous</button>
                                  <button type="button" class="btn btn-primary next-step pull-right" onclick="storeSettings();">Save</button>
                              </div>
                          </div>
                      </div>
                      
                  </div>
              {{ Form::close() }}
            </div>
         </div>
      </div>
  </div>
</div>
<div class="modal fade" id="modal-create-accounts">
  <div class="modal-dialog" >
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Create Tally Accounts</h4>
        <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-times fa-lg"></i></a>
      </div>
      <div class="modal-body">
          <p>Following accounts do not exists in your Tally account. These are the default accounts that our app will create in Tally for the summary sync. Click on continue and run the web connector to create following accounts.</p>
          <div id="section_create_accounts" style="max-height: 300px; overflow-y: auto;">
            
          </div>
          <input type="hidden" name="accounts_json" id="accounts_json">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default pull-left close" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary btn-sm" onclick="queueCreateAccount();">Continue</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
@stop

@section('more_scripts')
<script type="text/javascript">
  $(document).ready(function(){

      @if(isset($_REQUEST['submitRequest']) && $_REQUEST['submitRequest'] == true)
        storeSettings();
      @endif

      $('#create-form').validate({
            rules: {
                tlPrefix: {
                  required: true
                },
                bank_account: {
                  required: true
                },
                sync_start_date: {
                  required: true
                },
                sync_type: {
                  required: true
                }
            }, 
      });

      $("#sync_start_date").flatpickr({
        'minDate': "{{ $syncMinDate }}"
      });

     $(document).on('click', '.next-step', function(){

        if($("#create-form").valid()){
          var $active = $('.wizard .nav-tabs li.active');
          $active.next().removeClass('disabled');
          nextTab($active);
          $(".connecting-line").css('background', 'linear-gradient(to right, #5bc0de 75%, #e0e0e0 25%)');
        }
        
     });

     $(".prev-step").click(function (e) {
          var $active = $('.wizard .nav-tabs li.active');
          prevTab($active);
          $(".connecting-line").css('background', 'linear-gradient(to right, #5bc0de 20%, #e0e0e0 80%)');
      });
  });

  function tallyPrefixChecked()
  {
    if($("#prefix_required").prop("checked") == true)
    {
      setTimeout(function() {
      $('#tlPrefix').rules('remove')}, 0);
      $('#tlPrefix').val('');
    }
    else
    {
      setTimeout(function() {
      $('#tlPrefix').rules('add', { required: true })
      }, 0);
    }
  }

  function nextTab(elem) {
      $(elem).next().find('a[data-toggle="tab"]').click();
  }
  function prevTab(elem) {
      $(elem).prev().find('a[data-toggle="tab"]').click();
  }

  function storeSettings()
  {
    if($('#create-form').valid())
    {
      var inputs = $(".account_settings_acc");
      jsonObj = [];
      addAccount = [];
      for(var i = 0; i < inputs.length; i++){
          var acc_name = $(inputs[i]).attr('name');
          var tax_rate_name = acc_name.replace("_acc", "_tax_rate");
          var acc_val = $("#"+acc_name).val();
          var tax_rate_val = $("#"+tax_rate_name).val();
          if(acc_val != ''){
            item = {};
            item [acc_name] = acc_val;
            acc_split = acc_val.split(",");
            if(acc_split[0] == "0"){              
              addAccount.push(acc_split[1]);
            } else {
              item [acc_name] = acc_val;
              item [tax_rate_name] = tax_rate_val;
              jsonObj.push(item);
            }            
          }
      }
      
      $('#account_settings').val(JSON.stringify(jsonObj));
      
      if (addAccount.length > 0) {
          $("#accounts_json").val(JSON.stringify(addAccount));
          accHtml = '<table class="table fs-6">';
          $(addAccount).each(function( key, val ) {
              accHtml += '<tr><td>'+val+'</td></tr>';
          });
          accHtml += '</table>';
          $("#section_create_accounts").html(accHtml);
          $("#modal-create-accounts").modal('show');
      } else {
          startLoading();
          $.ajaxSetup({
              headers: {
                   'X-CSRF-TOKEN': '{{ csrf_token() }}'
              }
          });
          var createForm = $('#create-form');

          // Find disabled inputs, and remove the "disabled" attribute
          var disabled = createForm.find(':input:disabled').removeAttr('disabled');

          // serialize the form
          var serialized = createForm.serialize();

          // re-disabled the set of inputs that you previously enabled
          disabled.attr('disabled','disabled');
          $.ajax({
                  type: 'POST',
                  url: "{{ route('storesetting',array('seller_id' => $seller_id)) }}", 
                  data:serialized,
                  success:function( data , code ) 
                  { 
                    stopLoading();                  
                    //var data = JSON.parse(data);
                    if(data.success == true)
                    {
                        window.location.href = '{{ route('tlaccountdetails',array("seller_id" => $seller_id)) }}';
                    }
                    if(data.errors){
                        var errors = data.errors;
                        var errorHtml = '';
                        $.each(
                          
                        errors, function( index, value ) {
                          console.log( index + ": " + value );
                          errorHtml += "<br/>"+value;
                        });
                        $('.tab-pane.active').prepend('<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>'+errorHtml+'</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>');
                    }
                  },
                  error : function(reject)
                  {
                    stopLoading();
                    if(reject.status == 422)
                    {
                      var errorHtml = '<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>Required field error.</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>';
                      $('.tab-pane.active').prepend(errorHtml);
                     
                    }
                    else if(reject.status == 401)
                    {
                      var errorHtml = '<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>'+reject.responseJSON.errors+'</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>';
                      $('.tab-pane.active').prepend(errorHtml);
                    }
                    else
                    {
                      var errorHtml = '<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>Something went wrong, Please try again.</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>';
                      $('.tab-pane.active').prepend(errorHtml);
                    }
                    window.scrollTo(0,0);
                  }
          });
      }
    }
  }

  function queueCreateAccount(){

      startLoading();

      $.ajaxSetup({
          headers: {
               'X-CSRF-TOKEN': '{{ csrf_token() }}'
          }
      });

      accountsdata = $("#accounts_json").val();
      $.ajax({
          type: 'POST',
          url: "{{route('createsummaryaccounts',array('seller_id' => $seller_id))}}", 
          data:{"accountsdata": accountsdata, "formdata": $("#create-form").serializeArray()},
          success:function( data ) 
          {            
            if(data.success == true)
            {
                startLoading('Please go to your Tally web connector application and click on the Update Selected button.');      
                checkQueueStatus();
            } else {
                stopLoading();

                var errorHtml = '<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>Something went wrong, Please try again.</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>';

                $('.tab-pane.active').prepend(errorHtml);
                window.scrollTo(0,0);  
            }
          },
          error : function(reject)
          {
              stopLoading();
              var errorHtml = '<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>Something went wrong, Please try again.</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>';

              $('.tab-pane.active').prepend(errorHtml);
              window.scrollTo(0,0);
          }
      });
    }

    function checkQueueStatus()
    {      
      var checkQueueStatus = setInterval(function() {        
          $.ajax({
                type: 'GET',
                url: "{{route('checkqueuestatus',array('seller_id' => $seller_id ))}}", 
                data:"",
                success:function( data , code ) 
                { 
                  if(data.success == true)
                  {
                    $("#section_create_accounts").html('');
                    $("#modal-create-accounts").modal('hide');
                    stopLoading();
                    clearInterval(checkQueueStatus);
                    window.location.href = "{{ route('tlsettings', array('seller_id' => $seller_id)) }}&submitRequest=true";
                  }
                  
                },
                error : function(reject)
                {
                  stopLoading();
                  clearInterval(checkQueueStatus);
                  var errorHtml = '<div class="alert alert-dismissible bg-light-danger border border-danger border-1 d-flex flex-column flex-sm-row p-5 mb-10"><span class="svg-icon svg-icon-2hx svg-icon-danger me-4 mb-5 mb-sm-0"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path><path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path></svg></span><div class="d-flex flex-column pe-0 pe-sm-10"><h4 class="fw-bold">Error</h4><span>Something went wrong, Please try again.</span></div><button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert"><i class="bi bi-x fs-1 text-danger"></i></button></div>';

                    $('.tab-pane.active').prepend(errorHtml);

                  window.scrollTo(0,0);
                }
          });
      }, 30000);
    }

</script>
@stop