@extends('layouts.default')
@section('title')
  Select Tally Company
@stop
@section('content')
<div class="company_page">
   <div class="card" id="kt_conenct">
      <div class="card-body p-lg-10">
          <div class="d-flex flex-column">
              <div class="mb-5 text-center">
                  <h1 class="fw-bolder mb-5">Select your company for {{ @config('app.appModules')[$module] }}</h1>
                  <div class="text-gray-400 fw-bold fs-5"></div>
              </div>
              <div class="row g-10">
                <div class="col-md-12 text-center connection-img">
                  @if($module == 'tlaz')
                      <img src="{{ asset('assets/images/az-tl-connection.png') }}" width="300">
                    @endif
                </div>
                
                <div class="col-md-12 fs-6">
                  <p>We have fetched your tally company list from your tally application. Please select the tally company which you wish to integrate with {{ @config('app.appModules')[$module] }} connection from below dropdown list.</p>
                  <p>Data will sync in the company which you have select from the below dropdown.</p>
                  <div class="row">
                    <div class="col-md-4">
                        <form id="from_update_company" name="from_update_company">
                            <select name="company_name" id="company_name" class="form-control">
                                <option value="">Select Company</option>
                                @foreach($companyList as $ckey => $cval)
                                  <option value="{{ $cval['guid'].','.$cval['name'] }}">{{ $cval['name'] }}</option>
                                @endforeach
                            </select>
                        </form>
                    </div>
                    <div class="col-md-4">
                      <button type="button" class="btn btn-info btn-sm" id="save-company">Update</button>
                    </div>
                  </div>
                </div>
                <p>
                  <span class="error">If you do not have the Tally(.PTG) file, please </span><a href='{{ route("tyauth",array("seller_id"=>$seller_id,"downloadFile" => "yes")) }}'> Click Here</a>
                </p>
                <div class="col-md-12 mb-10" id="proccedNext">
                  <button class="btn btn-success btn-sm" onclick="testConnection()" id="testConnection">Test Connection</button>
                  <a class="btn btn-info btn-md {{ $tallyConnected->company_update_flag == 0 ? 'hidden' : ''}}" href="{{ route('tyauth',array('seller_id' => $seller_id)) }}" id="next-step">Setup Settings</a>
                </div>
              </div>
          </div>
      </div>
    </div>
</div>
@stop

@section('more_scripts')
<script type="text/javascript">
  $(document).ready(function(){
    $("#company_name").select2();
  });
  
  $(document).on('click', '#save-company', function(){
      companyName = $("#company_name").val();
      if(companyName == '' || companyName == undefined){
          Swal.fire(
              "Error",
              "Please select company.",
              "error"
          );
      } else {
          $.ajaxSetup({
            headers: {
                 'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
          });
          $.ajax({
              type: 'POST',
              url: "{{ route('updatecompany')}}?seller_id={{$seller_id}}", 
              data: {"companyName": companyName},
              success:function( data ) 
              { 
                if(data.success == true){
                  /*$("#next-step").removeClass("hidden");
                  $("#testConnection").addClass("hidden");*/

                  startLoading('Please go to your Tally web connector application and click on the Update button.');

                  checkDataUpdated();
                }else{
                  alert(data.message)
                }
              },
              error : function(error)
              {
                 alert(error.responseJSON.message)
              }
          });
      }
  });
  function testConnection(){
      $.ajax({
          type: 'GET',
          url: "{{ route("checktallyconnection")}}?seller_id={{$seller_id}}", 
          data:"",
          success:function( data ) 
          { 
            stopLoading();
            if(data.success == true){
              $("#next-step").removeClass("hidden");
              $("#testConnection").addClass("hidden");
            }else{
              alert(data.message)
            }
          },
          error : function(error)
          {
             alert(error.responseJSON.message)
          }
    });
  }

  function checkDataUpdated()
{
  var checkDataUpdated = setInterval(function() {
      $.ajax({
            type: 'GET',
            url: "{{route('checktallyconnection',array('seller_id' => $seller_id ))}}", 
            data:"",
            success:function( data ) 
            { 
              if(data.success == true)
              {
                stopLoading();
                clearInterval(checkDataUpdated);
                window.location.reload();
              }
              
            },
            error : function(reject)
            {
              stopLoading();
              clearInterval(checkDataUpdated);
              var errorHtml = '<div class="col-md-12"><div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">&times;</button><i class="fa fa-exclamation-circle faa-pulse animated"></i><strong>Error: </strong>Something went wrong,Please try again.</div></div>';

                $('.card-body').prepend(errorHtml);

              window.scrollTo(0,0);
            }
        });

      }, 30000);
}
</script>
@stop