@extends('layouts/default')

@section('title')
Report Dashboard
@stop

@section('content')
<div class="dashboard_page">	
	<div class="alert bg-light-success border border-success border-1 d-flex flex-column flex-sm-row p-5 mb-10" id="success-alert" style="display: none !important;">
	    <!--begin::Icon-->
	    <span class="svg-icon svg-icon-2hx svg-icon-success me-4 mb-5 mb-sm-0">
	        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
	            <path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path>
	            <path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path>
	        </svg>
	    </span>
	    <!--end::Icon-->

	    <!--begin::Wrapper-->
	    <div class="d-flex flex-column pe-0 pe-sm-10">
	        <!--begin::Title-->
	        <h4 class="fw-bold">Success</h4>
	        <!--end::Title-->
	        <!--begin::Content-->
	        <span>Your request has been submitted successfully!</span>
	        <!--end::Content-->
	    </div>
	    <!--end::Wrapper-->

	    <!--begin::Close-->
	    <button type="button" class="position-absolute position-sm-relative m-2 m-sm-0 top-0 end-0 btn btn-icon ms-sm-auto" data-bs-dismiss="alert">
	        <i class="bi bi-x fs-1 text-success"></i>
	    </button>
	    <!--end::Close-->
	</div>
	
    <!-- <a class="btn btn-primary" href="https://localhost/ecommerce/public/shopify/settings?shop=local-report-test.myshopify.com">Settings</a> -->
    <div class="card mb-5 mb-xl-10">
    	<div class="card-header">
			<!--begin::Card title-->
			<div class="card-title m-0">
				<h3 class="fw-bolder m-0">Request For Generate Report</h3>
			</div>
			<div class="card-toolbar">
				<a href="{{ route('settings', array('shop'=> $shop)) }}" class="btn btn-sm btn-success my-1">Report Settings</a>
			</div>
			<!--end::Card title-->			
		</div>
		<div class="card-body pt-9 pb-0">
			<!--begin::Details-->
			<div class="d-flex flex-wrap flex-sm-nowrap mb-3">
				<!--begin::Info-->
				<div class="flex-grow-1">
					<!--begin::Title-->
					<div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
						<!--begin::User-->
						<div class="d-flex flex-column">
							@if($requestedFlg)
								<p style="color: red">
								We have received your request to fetch the data from Shopify for the Summary entries. This process
			                      might take 15-20 minutes to complete. Once this process is complete, you will see a list of Journals
			                      ready to be synced in the space below.
			                      <br />You can fetch data for more days/payouts after the previous request is completed.
								</p>
							@else
								<p>Generate a request for fetch the shopify data and generate the report. Request process fetch 10 Shopify payouts at a time and 10
                      			days for other payment methods. This process might take about 15-20 minutes.</p>
							@endif
						</div>
						
						<button class="btn btn-sm btn-primary me-2 add-request" onclick="syncSummaryRequest();" <?php echo ($requestedFlg) ? 'disabled="disabled"' : ''?>>Generate Request</button>
						
						<!--end::User-->
					</div>
					<!--end::Title-->
					
				</div>
				<!--end::Info-->
			</div>
			<!--end::Details-->
		</div>
	</div>

	<div class="card mb-5 mb-lg-10">
		<!--begin::Card header-->
		<div class="card-header">
			<!--begin::Heading-->
			<div class="card-title">
				<h3>Latest Settlements</h3>
			</div>
			<!--end::Heading-->
			<div class="card-toolbar">
				<a href="{{ route('allsettlements', array('shop'=>$shop)) }}" class="btn btn-sm btn-info my-1">View All Settlements</a>
			</div>
		</div>
		<!--end::Card header-->
		<!--begin::Card body-->
		<div class="card-body p-0">
			<!--begin::Table wrapper-->
			<div class="table-responsive">
				<!--begin::Table-->
				<table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
					<!--begin::Thead-->
					<thead class="border-gray-200 fs-5 fw-bold bg-lighten">
						<tr>
							<th class="min-w-100px">Date</th>
							<th class="min-w-100px">Gateway</th>
							<th class="min-w-100px">Total</th>
							<th class="min-w-100px">Currency</th>
							<th class="min-w-100px">Tax Type</th>
							<th class="min-w-100px">Action</th>
						</tr>
					</thead>
					<!--end::Thead-->
					<!--begin::Tbody-->
					<tbody class="fw-6 fw-bold text-gray-600 fs-6">
						@if(!empty($settlementData))
							@foreach($settlementData as $key=>$value)
							<tr>
								<td>{{ $value['invoice_date'] }}</td>
								<td>{{ $value['gateway'] }}</td>
								<td>{{ $value['settlement_amount'] }}</td>
								<td>{{ $value['currency'] }}</td>
								<td>{{ $value['tax_type'] }}</td>
								<td>
									<a href="{{ route('settlementdetail', array('shop' => $shop, 'settlement_id'=> App\Helpers\Helper::encryptor('encrypt', $value['id']))) }}" class="btn btn-sm btn-primary">Review</a>
								</td>
							</tr>
							@endforeach
						@else
							<tr><td class="text-center" colspan="6">No Data Found.</td></tr>
						@endif
					</tbody>
					<!--end::Tbody-->
				</table>
				<!--end::Table-->
			</div>
			<!--end::Table wrapper-->
		</div>
		<!--end::Card body-->
	</div>
</div>
@stop
@section('more_scripts')
<script type="text/javascript">
    function syncSummaryRequest()
	{
	  $.ajax({
	      type: 'GET',
	      url: "{{route('addsummaryrequest',['shop'=>$shop])}}", 
	      data:"",
	      success:function( data , code ) 
	      {
	      	$(".add-request").attr("disabled", true);
	      	$("#success-alert").css('display','flex');
	      	setTimeout(function () {
             $("#success-alert").hide().removeClass('d-flex');
          	}, 3000);
	        //window.location.reload();
	      },
	      error : function(reject)
	      {
	        // window.location.reload();
	      }
	  });
	}
</script>
@stop