<!doctype html>
<html lang="en">
    <!--begin::Head-->
    <head>
        <title>Parex Bridge</title>
        <meta charset="utf-8" />
        <!--begin::Fonts-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
        <!--end::Fonts-->
        <link rel="shortcut icon" href="{{ asset('assets/images/logos/parexfavicon.png') }}" type="image/png">
        <!--begin::Global Stylesheets Bundle(used by all pages)-->
        <link href="{{ asset('assets/css/plugins.bundle.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/css/style.bundle.css') }}" rel="stylesheet" type="text/css" />
    </head>
    <body id="kt_body" class="" style="background-color: #fff">
        <div class="d-flex flex-column flex-root">
            <!--begin::Authentication - Sign-in -->
            <div class="d-flex flex-column flex-lg-row flex-column-fluid">
                <!--begin::Aside-->
                <div class="d-flex flex-column flex-lg-row-auto w-xl-700px positon-xl-relative" style="background-color: #F2C98A">
                    <!--begin::Wrapper-->
                    <div class="d-flex flex-column position-xl-fixed top-0 bottom-0 w-xl-700px scroll-y">
                        <!--begin::Content-->
                        <div class="d-flex flex-row-fluid flex-column text-center p-10 pt-lg-20">
                            <!--begin::Logo-->
                            <a href="javascript:void(0);" class="py-9 mb-5">
                                <img alt="Logo" src="{{ asset('assets/images/logos/parexlogo.png')}}" class="h-60px" />
                            </a>
                            <!--end::Logo-->
                            <!--begin::Title-->
                            <h1 class="fw-bolder fs-2qx pb-5 pb-md-10" style="color: #986923;">Welcome to Parex Bridge</h1>
                            <!--end::Title-->
                            <!--begin::Description-->
                            <p class="fw-bold fs-3" style="color: #986923;">Automated Accounting & Ecommerce 
                            <br />Integration</p>
                            <!--end::Description-->
                        </div>
                        <!--end::Content-->
                        <!--begin::Illustration-->
                        <div class="d-flex flex-row-auto bgi-no-repeat bgi-position-x-center bgi-size-contain bgi-position-y-bottom min-h-100px min-h-lg-350px" style="background-image: url({{ asset('assets/images/login-visual.svg') }})"></div>
                        <!--end::Illustration-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Aside-->
                <!--begin::Body-->
                <div class="d-flex flex-column flex-lg-row-fluid py-10">
                    <!--begin::Content-->
                    <div class="d-flex flex-center flex-column flex-column-fluid">
                        <!--begin::Wrapper-->
                        <div class="w-lg-500px p-10 p-lg-15 mx-auto">
                            <!--begin::Form-->
                            @yield('content')
                            <!--end::Form-->
                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Content-->
                    <!--begin::Footer-->
                    <div class="d-flex flex-center flex-wrap fs-6 p-5 pb-0">
                        <!--begin::Links-->
                        <div class="d-flex flex-center fw-bold fs-6">
                            <a href="javascript:void(0);" class="text-muted text-hover-primary px-2">About</a>
                            <a href="javascript:void(0);" class="text-muted text-hover-primary px-2">Support</a>
                            <a href="javascript:void(0);" class="text-muted text-hover-primary px-2">Contact</a>
                        </div>
                        <!--end::Links-->
                    </div>
                    <!--end::Footer-->
                </div>
                <!--end::Body-->
            </div>
            <!--end::Authentication - Sign-in-->
        </div>
        <script src="{{ asset('assets/js/plugins.bundle.js') }}"></script>
        <script src="{{ asset('assets/js/scripts.bundle.js') }}"></script>
        <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
        <!-- <script src="{{ asset('assets/js/front/general.js') }}"></script> -->
        <script type="text/javascript">
            $(document).ready(function(){
                $( "form" ).submit(function( event ) {
                    $(".btnsubmit").attr('data-kt-indicator','on');
                });
            });
        </script>
    </body>
</html>
