<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Model;

class Spysummarypayout extends Model
{
    protected $connection = 'shopify';
    protected $dates = [''];
    protected $table = 'spy_summary_payout';
    protected $rules = array(
        
    );
    protected $injectUniqueIdentifier = true;

    public static function fetchLastPayout($seller_id)
    {
    	$SpyorderObj = Spysummarypayout::where("seller_id",$seller_id)->orderBy("date","DESC")->limit(1)->first();
    	return $SpyorderObj;
    }

    public static function fetchSpyPayoutSingleData($column , $value,$seller_id,$module)
    {
        $SpycredentialObj = Spysummarypayout::where($column,$value)
                                    ->where("seller_id",$seller_id)
                                    ->where("module",$module)
                                    ->first();
        return $SpycredentialObj;
    }

    public static function fetchUnsyncPayout($seller_id)
    {
        $spyPayoutObj = Spysummarypayout::where("seller_id",$seller_id)
                                ->whereNull("xo_id")
                                ->orderBy("date")
                                ->get();
        return $spyPayoutObj;
    }

    public static function fetchpayouts($seller_id,$start_date,$end_date)
    {

        $spyPayoutObj = Spysummarypayout::where("seller_id",$seller_id)
                                ->whereBetween("date",[$start_date,$end_date])
                                
                                ->get();
        if(!empty($spyPayoutObj))
            $spyPayoutObj = $spyPayoutObj->toArray();
        else
            $spyPayoutObj = array();
        return $spyPayoutObj;
    }
    public static function fetchUnsyncPayouts($seller_id,$module,$reportCount,$startdate="",$enddate="",$reCalcParameters)
    {
        $reportType=(isset($reCalcParameters['reportType']))?$reCalcParameters['reportType']:"";
        $posted_date=(isset($reCalcParameters['posted_date']))?$reCalcParameters['posted_date']:"";
        $transactionId=(isset($reCalcParameters['transactionId']))?$reCalcParameters['transactionId']:"";
       
        $spyOrder = Spysummarypayout::select('spy_summary_payout.*')
        ->leftjoin('spy_summary_report', function ($join) {
            $join->on('spy_summary_payout.seller_id',  '=', 'spy_summary_report.seller_id')
            ->on('spy_summary_payout.payout_id',  '=', 'spy_summary_report.unique_id');
        });
        $spyOrder=$spyOrder->where("spy_summary_payout.seller_id", $seller_id);
        $spyOrder=$spyOrder->where("spy_summary_payout.module", $module);
        
        if(!empty($startdate) && !empty($enddate)){
            $spyOrder=$spyOrder->whereBetween("spy_summary_payout.date",[$startdate,$enddate]);
        }else if($reportType != "recalculateReport"){
            $spyOrder=$spyOrder->whereNull("spy_summary_report.unique_id");
        }else{
            $spyOrder=$spyOrder->where("spy_summary_report.posted_date", $posted_date);
            $spyOrder=$spyOrder->where("spy_summary_report.unique_id", $transactionId);
        }
        if(empty($startdate) && empty($enddate)){
            $spyOrder= $spyOrder->limit($reportCount);
        }
       $spyOrder= $spyOrder->get();
     
        return $spyOrder;
    }
}
