<?php

namespace App\Models\Shopify;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTime;
use DateTimeZone;
use DB;

class Spysummaryfees extends Model
{
    protected $connection = 'shopify';
    protected $dates = [''];
    protected $table = 'spy_summary_fees';
    protected $fillable =['module','seller_id','order_id','spy_order_transaction_id','transaction_id','gateway','fee_amount','referance','transaction_date'];

    use HasFactory;
    public static function fetchTransactionSingleData($column , $value,$seller_id)
    {
        $SpycredentialObj = SpySummaryFees::where($column,$value)->where('seller_id',$seller_id)->first();

        return $SpycredentialObj;
    }
    public static function addSpyFees($spy_order_transaction_id,$transaction_id,$spyConnected,$orderTransactions)
    {
        $feeAmtData = array_column($orderTransactions, 'fee_amount');
        if(!isset($feeAmtData[0]))
        $feeAmtData = array_column($orderTransactions, 'mc_fee'); 
       return  SpySummaryFees::updateOrCreate([
            //Add unique field combo to match here
            //For example, perhaps you only want one entry per user:
            'transaction_id'   => $transaction_id,
            'seller_id'   => $spyConnected['id'],
            'module'   => $spyConnected['module'],
        ],[
            'module' => $spyConnected['module'],
            'seller_id' => $spyConnected['id'],
            'order_id' => $orderTransactions['order_id'],
            'spy_order_transaction_id' => $spy_order_transaction_id,
            'transaction_id' => $orderTransactions['id'],
            'gateway' => $orderTransactions['gateway'],
            'fee_amount' => (isset($feeAmtData[0]))?$feeAmtData[0]:"",
            'referance' =>$orderTransactions['authorization'],
            'transaction_date' =>(new DateTime($orderTransactions['created_at']))->setTimezone(new DateTimeZone($spyConnected['spy_timezone']))->format('Y-m-d H:i:s'),
        ]);

    }
    public static function fetchUnsyncgatewayFees($seller_id,$module,$startdate,$reportenddate)
    {
        // $spyOrder = DB::connection('mysqlXeroSummaryCred')->select(DB::Raw("SELECT * FROM `spy_summary_fees` WHERE `seller_id` = '".$seller_id."' and (gateway != 'shopify_payments' OR gateway IS NULL) and transaction_date > '".$startdate."' and transaction_date < '".$reportenddate."' and transaction_date <'".date('Y-m-d')."' order by transaction_date asc")); 

        $spyOrder= SpySummaryFees::select(['spy_summary_fees.*'])->join('spy_summary_order_transaction', 'spy_summary_order_transaction.transaction_id', '=', 'spy_summary_fees.transaction_id')->leftjoin('spy_summary_order', 'spy_summary_order.order_id', '=', 'spy_summary_order_transaction.order_id')
        ->where('spy_summary_fees.seller_id',$seller_id)
        ->where('spy_summary_order_transaction.seller_id',$seller_id)
        ->where('spy_summary_fees.module',$module)
        ->whereBetween('spy_summary_fees.transaction_date', [$startdate, $reportenddate])
        ->whereDate('spy_summary_fees.transaction_date', '<', date('Y-m-d'))
        ->where('spy_summary_fees.gateway', '!=', 'shopify_payments')
        ->where('spy_summary_fees.gateway', '!=', 'shopify_installments')
        ->where('spy_summary_fees.gateway', '!=', 'shop_cash')
        ->where('spy_summary_order.sync_flg', '!=', 'D')
        ->get();

       $spyOrder = json_decode(json_encode($spyOrder),true);
       return $spyOrder;
    }
}
