<?php

namespace App\Models\Summary;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
class SpySummaryFeesReport extends Model
{
    protected $connection = 'shopify';
    protected $dates = [''];
    protected $connection = 'mysqlXeroSummaryCred';
    protected $table = 'spy_summary_fees_report';
    protected $fillable =[];
    use HasFactory;

    public static function fetchFeesReportLast($store_id,$module)
    {   
        $SpycredentialObj = SpySummaryFeesReport::where('store_id',$store_id)->where('module',$module)->where('gateway','!=','shopify_payments')->where('gateway','!=','shopify_installments')->where('gateway','!=','shop_cash')->orderby('posted_date','DESC')->first();

        return $SpycredentialObj;
    }
    public static function fetchReportData($store_id,$module)
    {
        $SpycredentialObj = SpySummaryFeesReport::where('sync_flg','N')->where('store_id',$store_id)->where('module',$module)->get();

        return $SpycredentialObj;
    }
   
    public static function fetchReportStart($store_id)
    {
        $SpycredentialObj = Spylastsync::where('store_id',$store_id)->where('sync_type','Fees')->orderby('report_date','DESC')->first(['report_date']);

        return $SpycredentialObj;
    }
    public static function savereportData($reportData,$type,$settingData,$reportstartdate=""){
       
        $modelName=SpySummaryFeesReport::class;
        
        foreach ($reportData as $key => $reports) {
            if(stripos($key,',') !== false || (isset($reports['transaction_type']) &&  $reports['transaction_type']=="Individual")){
                $reports=array('0'=>$reports);
            }
            foreach ($reports as $settlement_month=>$value) {
          
                if((is_null($value['total_amount']) || ($value['total_amount']===""  ) ) && (empty($reCalc)) ){
                    //Log::info("savereportData Data ---" .print_r($value,true));
                    continue;
                }
                $module=(isset($value['module']) && !empty($value['module']))?$value['module']:"xosp";

                $validGateway=(!empty($value['gateway']))?$value['gateway']:null;
                if(!empty($reCalc)){
                    $storeReport = $modelName::where('id',$reCalc['report_id'])->where('store_id',$value['store_id'])->where('module',$module)->where('settlement_month',$value['settlement_month'])->first();
                    if(empty($storeReport)){
                        continue;
                    }
                }else if($type == 'payout'){
                    $storeReport = $modelName::where('store_id',$value['store_id'])->where('module',$module)->where('unique_id',$value['unique_id'])->where('posted_date',$value['posted_date'])->where('settlement_month',$settlement_month)->where('gateway',$validGateway)->where('transaction_type',$value['transaction_type'])->first();
                }else if($value['transaction_type']=="Individual"){
                    $storeReport = $modelName::where('store_id',$value['store_id'])->where('module',$module)->where('posted_date',$value['posted_date'])->where('unique_id',$value['unique_id'])->where('gateway',$validGateway)->first();
                } else{
                    $storeReport = $modelName::where('store_id',$value['store_id'])->where('module',$module)->where('posted_date',$value['posted_date'])->where('gateway',$validGateway)->first();
                }
                
                if(empty($storeReport) && empty($reCalc)){
                    $storeReport = new $modelName();
                }
                if(isset($value['store_id']) && !empty($value['store_id'])){
                    $storeReport->store_id = $value['store_id'];
                }
                if(isset($module) && !empty($module)){
                    $storeReport->module = $module;
                }
                if(isset($value['unique_id']) && !empty($value['unique_id'])){
                    $storeReport->unique_id = $value['unique_id'];
                }
                if(isset($value['posted_date']) && !empty($value['posted_date'])){
                    $storeReport->posted_date = $value['posted_date'];
                }
                if(isset($value['settlement_month']) && !empty($value['settlement_month'])){
                    $storeReport->settlement_month = $value['settlement_month'];
                }
                if (isset($value['taxes_included']) && !empty($value['taxes_included'])) {
                    $storeReport->tax_type = $value['taxes_included'];
                }
                if(isset($value['currency']) && !empty($value['currency'])){
                    $storeReport->currency = $value['currency'];
                }
                if(isset($value['total_transactions']) && !empty($value['total_transactions'])){
                    $storeReport->total_transactions = $value['total_transactions'];
                }
                if(isset($value['transaction_type']) && !empty($value['transaction_type'])){
                    $storeReport->transaction_type = $value['transaction_type'];
                }
                if(isset($value['gateway']) && !empty($value['gateway'])){
                    $storeReport->gateway = $value['gateway'];
                }
                $storeReport->total_amount = (!empty($value['total_amount']))?$value['total_amount']:NULL;
            
                if(isset($value['summary_details']) && !empty($value['summary_details'])){
                   $storeReport->summary_details = json_encode($value['summary_details']);
                }
                if($value['transaction_type']=="Individual"){
                    $storeReport->reference = Spysummaryreport::getreference($value,$module);
                }
                
                $storeReport->document_number= getDocumentNumber($settingData, $value);

                $storeReport->sync_flg='N';

                if(count($reports) > 1){
                    $storeReport->partial_settlement = 'Y';                    
                }
                
                $storeReport->save();
                $Spylastsyncdata = SpySummaryFeesReport::updateLastSyncReportDate($reportstartdate,$value['store_id'],$module);

            }
        }

    }
    public static function updateLastSyncReportDate($reportstartdate,$store_id,$module)
    {
        $lastUpdatedReport = date('Y-m-d', strtotime($reportstartdate . ' +1 day'));
       
        $start=date('Y-m-d',strtotime($lastUpdatedReport));
        $end=date('Y-m-d');
        $checkNextDaysRecord = SpySummaryFees::where('store_id',$store_id)->where('module',$module)->whereDate('transaction_date', '>=', $lastUpdatedReport)->orderby('transaction_date','DESC')->first(['transaction_date']);
        if(!empty($checkNextDaysRecord)){
            
            if($start<$end){
                $Spylastsyncobj = Spylastsync::where('store_id',$store_id)->where('module',$module)->where('sync_type','Fees')->first();
                if (empty($Spylastsyncobj)) {
                    $Spylastsyncobj = new Spylastsync();                        
                }
                $Spylastsyncobj->store_id= $store_id;
                $Spylastsyncobj->module= $module;
                $Spylastsyncobj->last_updated_at =$lastUpdatedReport;
                $Spylastsyncobj->report_date =$lastUpdatedReport;
                $Spylastsyncobj->sync_type= "Fees";
                $Spylastsyncobj->save();
            }
            /* Spylastsync::where("store_id", $store_id)->where('sync_type','Fees')->update([
                "report_date" => $lastUpdatedReport,
            ]); */
        }
        return $lastUpdatedReport;
    }
}
