<?php
namespace App\Models\Master;

use App\Models\Master\Plans;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Auth;
use DB;

class SellerPlan extends Model
{
  protected $connection = 'mysql';
    use SoftDeletes;
    
    protected $dates = ['deleted_at'];
    protected $table = 'seller_plan';
    protected $rules = array(
        
    );
    protected $injectUniqueIdentifier = true;
 	protected $fillable = [];
    
    public static function getSellerPlan($seller_id){
      $checkPlan = SellerPlan::where('seller_id', $seller_id)->where('status','Active')->orderby('id','desc')->first();
      return $checkPlan;
      
    }

    public static function CheckTrial($seller_id,$plan_id)
    {
        $datee = DB::table('seller_plan')->where('seller_id',$seller_id)->WhereNotNull('deleted_at')->orderby('id','asc')->first();
        $plans = Plans::where('id',$plan_id)->first();
         $time ='current';
        if(!empty($datee)){
            $date =date('Y-m-d');
            $date1=date_create($datee->plan_activated_on);
            $date2=date_create($date);
            $diff=date_diff($date1,$date2);
            if($plans->trial_days >= 1){
                $date = $plans->trial_days - $diff->format("%a");
                if($date <= $plans->trial_days && $date >=1){
                  $time = strtotime("+".$date." day");
                }else{
                  $time = strtotime("now");
                }
            }else{
               $time = strtotime("now");
            }
        }
        return $time;
    }

    public static function SavesubScriptions($subscriptions,$plan_id_primary,$stripe_customer_id = null)
    {
        $getSellerPlan = Plans::where('id',$plan_id_primary)->first();
        $SellerPlan =array();

        $SellerPlan = new SellerPlan;
        $SellerPlan->seller_id = $subscriptions['seller_id'];
        $SellerPlan->plan_id = $plan_id_primary;
        $SellerPlan->subscriptions_id = (isset($subscriptions['id']))?$subscriptions['id']:'';
        $SellerPlan->stripe_customer_id = $stripe_customer_id;
        $SellerPlan->product_id = (isset($subscriptions['plan']['id']))?$subscriptions['plan']['id']:'';
        $SellerPlan->gateway = $subscriptions['gateway'];
        $SellerPlan->plan_name =(isset($subscriptions['plan']['name'])) ? $subscriptions['plan']['name']: (isset($subscriptions['plan_name']) ? $subscriptions['plan_name'] : '');
        if($subscriptions['gateway'] == 'stripe'){
         $checkstrip = \App\Http\Controllers\Controller::fetchStripeCredential($subscriptions['seller_id']);     
         $SellerPlan->test = (strpos(env('STRIPE_SECRET'), 'test'))?'Y':'N';
        }
        $SellerPlan->plan_activated_on = date('Y-m-d');
        if(isset($subscriptions['charge_amt']) && isset($subscriptions['orders_limit'])){
            $SellerPlan->max_orders_allowed = $subscriptions['orders_limit'];
            $dollar_per_order = ((int)$subscriptions['charge_amt'])/((int)$subscriptions['orders_limit']);
            $SellerPlan->dollar_per_order = $dollar_per_order;
        }else{
           $SellerPlan->max_orders_allowed = $getSellerPlan->max_orders_allowed;
           $SellerPlan->dollar_per_order = $getSellerPlan->dollar_per_order;
        }

        $SellerPlan->plan_activated_on =date('Y-m-d');
        $SellerPlan->plan_price =(isset($subscriptions['plan']['amount']))?$subscriptions['plan']['amount']/100:$subscriptions['amount']/100;
        $SellerPlan->total_price =(isset($subscriptions['plan']['amount']))?$subscriptions['plan']['amount']/100:$subscriptions['amount']/100;
        
        if(isset($subscriptions['plan']['interval'])){
          $SellerPlan->plan_duration =($subscriptions['plan']['interval'] == 'month')?30:7;
        }else{
            $SellerPlan->plan_duration =$subscriptions['plan_duration'];  
        }
        if(isset($subscriptions['plan_type']))
          $SellerPlan->plan_type = $subscriptions['plan_type'];

        $SellerPlan->status ='Active';
        $SellerPlan->save();
      
        return $SellerPlan;
    }

    public static function DeletePlan($seller_id)
    {
      $date = date('Y-m-d');
      $update =SellerPlan::where('seller_id', $seller_id)
                ->update(['plan_cancelled_on' => $date,'status'=>'Inactive']);
      return true;
    }
}
