<?php
namespace App\Models\Master;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Auth;
use DB;

class Billingdetailsint extends Model
{
    use SoftDeletes;
   
    protected $connection = 'mysql';
    protected $dates = ['deleted_at'];
    protected $table = 'seller_billing_address_int';
    protected $rules = array();
    protected $injectUniqueIdentifier = true;
 	protected $fillable = [];

 	public function scopeTextSearch($query, $search)
    {
        return $query->where(function ($query) use ($search) {
            $query->where('seller_name', 'LIKE', '%'.$search.'%');
        });
    }

    
    public static function getUserwiseBillingDetailInfo($userId){
        return Billingdetailsint::join('seller_billing_address','seller_billing_address_int.billing_address_id','=','seller_billing_address.id')->where('user_id',$userId)->groupBy('billing_address_id')->get();
    }

    public static function getBillingDetailsForSeller($seller_id){
        $billingDetails = Billingdetailsint::join('seller_billing_address','seller_billing_address_int.billing_address_id','=','seller_billing_address.id')->where('seller_billing_address_int.user_id',Auth::user()->id)->where('seller_billing_address_int.seller_id',$seller_id)->first();

        return $billingDetails;
    }
}
