<?php
namespace App\Models\Amazon;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;

class Summarycostreport extends Model
{
  protected $connection = 'amazon';
    protected $table = 'az_summary_cost_report';
    protected $rules = array(
    );
    protected $injectUniqueIdentifier = true;
  
    public static function maxEventIdFromReport($seller_id){
        return Summarycostreport::select(DB::raw('MAX(summary_event_id) as maxEventId'))->where('seller_id',$seller_id)->first();
    }

    public static function checkExistOfEventEntry($seller_id,$order_month,$event_id){
     return Summarycostreport::where('seller_id',$seller_id)->where('settlement_month',$order_month)->where('summary_event_id',$event_id)->first(); 
    }

    public static function getEventsCostForSync($seller_id, $sync_status, $sync_flag, $type = ''){
        $azEvent = Summarycostreport::whereIn('sync_flg',$sync_flag)->where('sync_status_flg',$sync_status)->where('seller_id',$seller_id)->limit(config('ecomtoacc.amazon.eventSyncDbToAccLimit'))->get();

        return $azEvent;
    }
}
