<?php
namespace App\Models\Amazon;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Auth;
use DB;

class Marketplace extends Model
{
    use SoftDeletes;
    protected $connection = 'amazon';
    protected $dates = ['deleted_at'];
    protected $table = 'seller_marketplace_id';
    protected $rules = array(
        
    );
    protected $injectUniqueIdentifier = true;
    protected $fillable = [];

    public function scopeTextSearch($query, $search)
    {
        return $query->where(function ($query) use ($search) {
        
            $query->where('seller_name', 'LIKE', '%'.$search.'%');
        });
    }

    public static function getActiveMarketPlaceCurrency($seller_id){
        return Marketplace::select('currency')->where('seller_id',$seller_id)->where('status','Active')->get()->toArray();
    }
    
}
