<?php
namespace App\Models\Amazon;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\User;
use Auth;
use DB;

class Azsellers extends Model
{
    use SoftDeletes;
    protected $connection = 'amazon';
    protected $dates = ['deleted_at'];
    protected $table = 'az_seller';
    protected $rules = array(
    );
    protected $injectUniqueIdentifier = true;
    protected $fillable = ['seller_name', 'status'];

    public static function getSellerDetail($seller_id,$connection_name,$setting_name,$module)
    {
      
       $sellerdetails = Azsellers::select('az_seller.id as sellerId','az_seller.seller_name','seller_marketplace_id.az_marketplace_id','seller_marketplace_id.id as seller_marketplace_id','az_seller.sync_type',$setting_name.'.*','az_seller.module','seller_marketplace_id.region','az_seller.az_refresh_token as az_refresh_token','seller_marketplace_id.az_marketplace_name','az_seller.az_expire_in','az_seller.az_access_token','az_seller.sync_type as sync_type')
            ->join($connection_name,$connection_name.'.seller_id','=','az_seller.id')
            ->join($setting_name,$setting_name.'.seller_id','=','az_seller.id')
            ->join('seller_marketplace_id','seller_marketplace_id.seller_id','=','az_seller.id')
            ->join(env('DB_DATABASE').'.seller_plan','seller_plan.seller_id','=','az_seller.id')
            ->where('az_seller.status','Active')
            ->where($connection_name.'.module',$module)
            ->where('seller_plan.status','Active')
            ->where('seller_marketplace_id.status','Active')            
            ->whereNull('seller_plan.deleted_at')
            ->where('az_seller.id',$seller_id);
            if(strpos($module,'qbd') !== false){
              $sellerdetails->where($connection_name.'.qb_status','Active')->where($connection_name.'.preference_fetch',1)->where($connection_name.'.account_fetch',1);
            } else {
              $sellerdetails->where($connection_name.'.status','Active');
            }

        if(strpos($setting_name, 'xo_sync_settings') !== false){        
          $sellerdetails->whereNull($setting_name.'.deleted_at');
        } else {
          $sellerdetails->where($setting_name.'.status', 'Active');
        }

        $sellerdetails = $sellerdetails->get();
            
        return $sellerdetails;
    }

    
    public static function getSellerDetails($seller_id='')
    {
      $checkSeller = Azsellers::where('id',$seller_id)->where('status','Active')->first();  
      if(!empty($checkSeller)){        
          $sellerdetails = array();
          if($checkSeller->module == 'tlaz'){
            $settingData = env('DB_DATABASE').'.tally_summary_setting';
            if($checkSeller->sync_type == 'Summary')
            $sellerdetails =Azsellers::select($settingData.'.*','az_seller.*','az_seller.sync_type as sync_type')->join($settingData,$settingData.'.seller_id','=','az_seller.id')->where('az_seller.id',$seller_id)->where('az_seller.status','Active')->where($settingData.'.status','Active')->get();
            return $sellerdetails;
          }     
       }
     }

     public static function getSellerDetailsSp($seller_id,$connection_name,$setting_name,$module)    
    {
      $sellerdetails = Azsellers::select('az_seller.id','az_seller.seller_name','seller_marketplace_id.az_marketplace_id','seller_marketplace_id.id as seller_marketplace_id',$setting_name.'.*','seller_marketplace_id.az_marketplace_name','seller_marketplace_id.country',        
        DB::raw('group_concat(seller_marketplace_id.az_marketplace_id SEPARATOR ",") as marketplaces'),'seller_marketplace_id.region','az_seller.az_access_token as az_access_token','az_seller.az_refresh_token as az_refresh_token','az_seller.az_expire_in')
      ->join($connection_name,$connection_name.'.seller_id','=','az_seller.id')
      ->join($setting_name, $setting_name.'.seller_id','=','az_seller.id')
      ->join('seller_marketplace_id','seller_marketplace_id.seller_id','=','az_seller.id')
      ->where('seller_marketplace_id.status','Active')      
      ->where($connection_name.'.module',$module)
      ->where($connection_name.'.status','Active')
      ->where('az_seller.id',$seller_id)
      ->where('az_seller.status','Active');
      
      if($setting_name == 'xo_sync_settings'){        
        $sellerdetails->whereNull($setting_name.'.deleted_at');
      } else {
        $sellerdetails->where($setting_name.'.status', 'Active');
      }
      $sellerdetails = $sellerdetails->groupBy('seller_marketplace_id.region')->get();
      
      return $sellerdetails;
   }
   public static function getSellerWithMarketplace($seller_id,$connection_name,$setting_name,$module){

    $sellerdetails = Azsellers::select('az_seller.id','az_seller.seller_name','seller_marketplace_id.az_marketplace_id','seller_marketplace_id.id as seller_marketplace_id',$connection_name.'.*','seller_marketplace_id.az_marketplace_name','seller_marketplace_id.country','seller_marketplace_id.region','az_seller.az_access_token','az_seller.az_refresh_token','az_seller.az_expire_in')
      ->join($connection_name,$connection_name.'.seller_id','=','az_seller.id')
      ->join($setting_name,$setting_name.'.seller_id','=','az_seller.id')
      ->join('seller_marketplace_id','seller_marketplace_id.seller_id','=','az_seller.id')
      ->where('seller_marketplace_id.status','Active')      
      ->where($connection_name.'.status','Active')
      ->where($connection_name.'.module',$module)
      ->where('az_seller.id',$seller_id)
      ->where('az_seller.status','Active');
      if($setting_name == 'xo_sync_settings'){        
        $sellerdetails->whereNull($setting_name.'.deleted_at');
      } else {
        $sellerdetails->where($setting_name.'.status', 'Active');
      }

      $sellerdetails = $sellerdetails->get();
      
      return $sellerdetails;
   }
}