<?php

namespace App\Models\Amazon;

use Illuminate\Database\Eloquent\Model;
use App\Helpers\Helper;
use DB;

class Azorder extends Model
{
    protected $dates = [''];
    protected $connection = 'amazon';
    protected $table = 'az_order';
    protected $rules = array(
        
    );

    protected $injectUniqueIdentifier = true;

    public static function orderSyncAsyncCountMonth($seller_id,$date)
    {
        $azOrder = Azorder::select('t1.syncOrders','t2.unsyncOrders')
        ->leftjoin(DB::raw("(select count(id) as syncOrders,DATE_FORMAT(created_at, '%Y-%m') as refordate from az_order where seller_id = '".$seller_id."' and sync_status_flg IN ('Sync','SyncPending') and DATE_FORMAT(created_at, '%Y-%m') = '".$date."'  group by DATE_FORMAT(created_at, '%Y-%m')) as t1 "),DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'=','t1.refordate')
        ->leftjoin(DB::raw("(select count(id) as unsyncOrders,DATE_FORMAT(created_at, '%Y-%m') as refordate from az_order where seller_id = '".$seller_id."' and sync_status_flg IN ('Pending','Manualsync') and DATE_FORMAT(created_at, '%Y-%m') = '".$date."'  group by DATE_FORMAT(created_at, '%Y-%m')) as t2 "),DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'=','t2.refordate')
        ->where('seller_id',$seller_id)
        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'=',$date)
        ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m')"),'t1.syncOrders','t2.unsyncOrders')->first();

        if(!empty($azOrder))
            $azOrder = $azOrder->toArray();
        else
            $azOrder = array();

        return $azOrder;
    }
    public static function orderTotalSync($sd_id)
    {
        $azOrder = Azorder::whereIn('sync_status_flg',['Sync','SyncPending'])
        ->where('seller_id',$sd_id)->count();

        return $azOrder;
    }
    public static function fetchOrderSingleData($column , $value,$seller_id='')
   {
      $orderObj = Azorder::where($column,$value)->where("seller_id",$seller_id)->first();
      return $orderObj;
   }
   public static function checkRefundInOrderExist($orderId,$seller_id){
      $azOrder = Azorder::where('AmazonOrderId',$orderId)->where('seller_id',$seller_id)->first();
      if(empty($azOrder)){
        return false;
      }else{
        return true;
      }
    }
    public static function getMaxSyncOrderDate($seller_id,$duration = ''){
      $azOrder = Azorder::select(DB::raw('MAX(PurchaseDate) as maxDate'))->where('seller_id',$seller_id)->where('sync_flg','Y')->whereNotNull('xo_id')->first();

        return $azOrder;
    }
    public static function getUnsyncOrderCount($seller_id){
      $azOrder = Azorder::where('seller_id',$seller_id)->whereNull('xo_id');
      $azOrder = $azOrder->count();
      return $azOrder; 
    }
    public static function checkMarketplaceIdwiseOrder($seller_id='',$market_place_id='')
  {
    $azOrder = Azorder::where("seller_id",$seller_id)->where("MarketplaceId",$market_place_id)->get()->toarray();
      return $azOrder;
  }

  public static function getMaxOrderCount($seller_id,$duration = ''){
      $azOrder = Azorder::where('seller_id',$seller_id)->where('sync_status_flg','Sync');

      if($duration != '')
        $azOrder = $azOrder->where('created_at','>=',$duration);

      $azOrder = $azOrder->count();

        return $azOrder;
    }
    public static function getOrderByOrderId($seller_id,$order_id){
      return $azOrder = Azorder::where('seller_id',$seller_id)->where('AmazonOrderId',$order_id)->first();
    }
}
