<?php

namespace App\Http\Controllers\Tally\Tlsellers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use App\Models\Master\Sellers;
use App\Models\Master\SellerPlan;
use App\Models\Tally\Tyconnections;
use App\Models\Tally\Tysummarysettings;
use View;

class TlSellersController extends Controller
{
	public function accountDetails(Request $request) {

		$seller_id_enc = $request->get('seller_id');
        $seller_id = Helper::encryptor('decrypt', $seller_id_enc);

        $sellerData = Sellers::getSellerData('id', $seller_id);
        if(!empty($sellerData)){
        	/* Check seller plan */
        	$sellerPlanData = SellerPlan::getSellerPlan($seller_id);
        	if(empty($sellerPlanData)){
        		return redirect()->route('plans', array('seller_id'=>$seller_id_enc));
        	}
            $tlConnected = Tyconnections::checkTallyConnected($seller_id, $sellerData->marketplace_name);
            if($tlConnected == 'connected'){
                $tlSettings = Tysummarysettings::fetchSettingForSeller($seller_id);
                if(!empty($tlSettings)){
                    echo 'Dashboard';exit;
                } else {
                    return redirect()->route('tlsettings', array('seller_id'=>$seller_id_enc));    
                }
            } else {
                return redirect()->route('tyauth', array('seller_id'=>$seller_id_enc));
            }         	
        }
    }

}
