<?php

namespace App\Http\Controllers\Shopify;

use App\Http\Controllers\Controller;
use App\Models\Shopify\Spycredential;
use Illuminate\Http\Request;
use App\Helpers\Shopify;
use Redirect;

class AuthenticationController extends Controller
{
    /**
     * Shopify App Auth url
     */
    public function index()
    {   
        $shop    = $_REQUEST['shop'];
        $scopes  = config("shopify.shopify_scope");
        $installUrl   = "https://$shop/admin/oauth/authorize?client_id=" . env('SHOPIFY_KEY') . "&scope=$scopes&redirect_uri=" . env('SHOPIFY_REDIRECT');

        $spyData = Spycredential::fetchSpySingleData('store_domain', $shop);
        
        if(empty($spyData) || $spyData->status != 'Active'){
            $code = ' <script type="text/javascript">
                  window.parent.location.href = "' . $installUrl . '";
                  </script>';
            echo $code;
        } else {
            return redirect::route('shopifyHome', array("shop" => $_REQUEST["shop"]));
        }
    }

    /*
        Install app callback
    */
    public function authCallBack()
    {
        foreach ($_REQUEST as $key => $value) {
            if ($key !== "hmac" && $key != "signature") {
                $hashArray[] = $key . "=" . $value;
            }
        }
        
        $hashString   = implode("&",$hashArray);
        $hashedString = hash_hmac("sha256", $hashString, env('SHOPIFY_SECRET'));

        /* compare resulting hashed string with hmac parameter */
        if ($_REQUEST['hmac'] !== $hashedString) {
            return 403;
        }
        
        $host = (!empty($_REQUEST['host'])) ? $_REQUEST['host'] : "";

        $shopUrl  = "https://" . $_REQUEST["shop"] . "/admin/oauth/access_token.json";
        $postData = http_build_query(
            array(
                "client_id"     => env('SHOPIFY_KEY'),
                "client_secret" => env('SHOPIFY_SECRET'),
                "code"          => $_REQUEST["code"],
            )
        );

        $result = app('App\Http\Controllers\Ecomtoacc\Shopify\ApiController')::shop_auth_curl_request_call($shopUrl, $postData);
        
        $tokenResponse = json_decode($result, true);        
        if (!empty($tokenResponse['access_token'])) {
            $shopUrl      = "https://" . $_REQUEST["shop"] . "/admin/shop.json";
            $result       = app('App\Http\Controllers\Ecomtoacc\Shopify\ApiController')::shop_curl_request_call($shopUrl, $tokenResponse['access_token']);            
            $shopResponse = json_decode($result, true);

            $SpycredentialObj = Spycredential::fetchSpySingleData("store_domain", $_REQUEST["shop"]);

            if (empty($SpycredentialObj)) {
                $SpycredentialObj                 = new Spycredential();
                $SpycredentialObj->term_condition = "Y";
                $SpycredentialObj->payment_status = "paid";
            }
            $SpycredentialObj->store_domain       = $_REQUEST["shop"];
            $SpycredentialObj->store_access_token = $tokenResponse['access_token'];

            if (!empty($shopResponse['shop'])) {
                $SpycredentialObj->shop_id       = $shopResponse['shop']['id'];
                $SpycredentialObj->shop_name     = $shopResponse['shop']['name'];
                $SpycredentialObj->shop_email    = $shopResponse['shop']['email'];
                $SpycredentialObj->shop_address1 = $shopResponse['shop']['address1'];
                $SpycredentialObj->shop_city     = $shopResponse['shop']['city'];
                $SpycredentialObj->shop_zip      = $shopResponse['shop']['zip'];
                $SpycredentialObj->shop_province = $shopResponse['shop']['province'];
                $SpycredentialObj->shop_country  = $shopResponse['shop']['country'];
                $SpycredentialObj->shop_address2 = $shopResponse['shop']['address2'];
                $SpycredentialObj->shop_phone    = $shopResponse['shop']['phone'];
                $SpycredentialObj->shop_currency = $shopResponse['shop']['currency'];
                $SpycredentialObj->shop_owner    = $shopResponse['shop']['shop_owner'];
                $SpycredentialObj->plan_name     = $shopResponse['shop']['plan_name'];
                
                if (!empty($shopResponse['shop']['iana_timezone'])) {
                    $SpycredentialObj->spy_timezone = $shopResponse['shop']['iana_timezone'];
                }

                $SpycredentialObj->status = "Active";
                $SpycredentialObj->host = $host;
                $SpycredentialObj->module = 'shopify';
            }
            $SpycredentialObj->save();
        }

        return redirect::route('shopifyHome', array("shop" => $_REQUEST["shop"]));
        exit;
    }

}
