<?php

namespace App\Http\Controllers\Ecomtoacc\Shopify;

use App\Http\Controllers\Controller;
use App\Models\Shopify\Spycredential;
use App\Models\Shopify\Spyreportsetting;
use App\Models\Shopify\Spylastsync;
use App\Models\Shopify\Spysummaryorder;
use App\Models\Shopify\Spyorderlineitems;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;
use DateTime;
use DateTimeZone;
use Input;

class ApiController extends Controller
{
    public static function shop_auth_curl_request_call($curlUrl = null, $postField = null)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $curlUrl);
        curl_setopt($ch, CURLOPT_POST, 3);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postField);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the transfer as a string

        /* pass to the browser to return results of the request */
        $result = curl_exec($ch);

        /* closes cURL resource */
        curl_close($ch);

        return $result;
    }

    public static function shop_curl_request_call($curlUrl = null, $accessToken = null)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "X-Shopify-Access-Token: $accessToken",
        ));
        curl_setopt($ch, CURLOPT_URL, $curlUrl);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the transfer as a string

        /* pass to the browser to return results of the request */
        $result = curl_exec($ch);

        /* closes cURL resource */
        curl_close($ch);

        return $result;
    }

    public static function shop_curl_request_call_header($curlUrl = null, $accessToken = null)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "X-Shopify-Access-Token: $accessToken",
        ));
        curl_setopt($ch, CURLOPT_URL, $curlUrl);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the transfer as a string
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);

        /* pass to the browser to return results of the request */
        $result = curl_exec($ch);

        /* closes cURL resource */
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $header      = substr($result, 0, $header_size);
        $body        = substr($result, $header_size);
        curl_close($ch);
        $link = self::get_next_link($header);
        $data = array('url' => $link, 'data' => $body);
        return $data;
    }

    public function get_next_link($header)
    {
        $link = '';
        if (strpos($header, 'Link:') !== false || strpos($header, 'link:') !== false) {
            if (strpos($header, 'rel="next"') !== false) {
                preg_match('/<(.*)>; rel="next"/', $header, $matches);
                if (!empty($matches) && isset($matches[1])) {
                    if (strpos($matches['1'], ',')) {
                        $links    = explode(',', $matches[1]);
                        $links[1] = trim($links[1]);
                        $link     = ltrim($links[1], "<");
                    } else {
                        $link = $matches[1];

                    }
                }

            }
        }
        return $link;
    }

    function getPrevKey($key, $hash = array()) {
        $keys = array_keys($hash);
        $found_index = array_search($key, $keys);
        if ($found_index === false || $found_index === 0)
            return false;
        return $keys[$found_index-1];
    }
}
