<?php
namespace App\Http\Controllers\Ecomtoacc\Ecomtodb\Amazon;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Amazon\Azsellers;
use App\Helpers\Helper;
use View;
use Log;
use Config;


/*
ApiController contails all spapi api calls.
*/
class ApiController extends Controller
{	
    public function getAmazonAccessToken($code){
        $client_id=config('ecomtoacc.amazon.SP_API_CLIENT_ID');
        $client_secret=config('ecomtoacc.amazon.SP_API_CLIENT_SECRET');
         
         $ch = curl_init();
         $header = array("Content-Type:application/x-www-form-urlencoded;charset=UTF-8");        
         $postDataJson = "client_id=$client_id&client_secret=$client_secret&grant_type=authorization_code&code=".$code;
         curl_setopt($ch, CURLOPT_URL, 'https://api.amazon.com/auth/o2/token');
         curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
         curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
         curl_setopt($ch, CURLOPT_POST, 1);
         curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);

        // response of the POST request
         $response = curl_exec($ch);
         $response = json_decode($response,1);
         return $response;
    }

    public function getMarketplaceInformation($seller_details,$region){
        $seller_details['region'] = $region;
        $config = $this->getCommonConfigDetails($seller_details);

        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\SellersApi($config);

        $result = $apiInstance->getMarketplaceParticipations();
        $seller_marketplaces = $result->getPayload();
        return $seller_marketplaces;
    }

    /*
    * Manali Patel - 06/07/2022
    * Get common config details
    */
    public function getCommonConfigDetails($seller_details){

        $region = $seller_details['region'];   
        $region = 'EUROPE';
        $token_expires_in = $seller_details['az_expire_in'];
        if($token_expires_in < time() + 300){                   
            $accessToken = $this->refreshAccessToken($seller_details);
        } else {               
            $accessToken = $seller_details['az_access_token'];
        }
        
        $config = \ClouSale\AmazonSellingPartnerAPI\Configuration::getDefaultConfiguration();
        $config->setHost(\ClouSale\AmazonSellingPartnerAPI\SellingPartnerEndpoint::$$region);
        $config->setAccessToken($accessToken);        
        $config->setAccessKey(config('ecomtoacc.amazon.SP_API_ACCESS_KEY'));
        $config->setSecretKey(config('ecomtoacc.amazon.SP_API_SECRET_KEY'));
        $config->setRegion(\ClouSale\AmazonSellingPartnerAPI\SellingPartnerRegion::$$region);
        return $config;
    }
    /*
    * Margee Patel - 06/07/2021
    * Refresh access token from refresh token
    */
    public function refreshAccessToken($seller_details){

        $accessToken = \ClouSale\AmazonSellingPartnerAPI\SellingPartnerOAuth::getAccessTokenFromRefreshToken(
            $seller_details['az_refresh_token'],
            config('ecomtoacc.amazon.SP_API_CLIENT_ID'),
            config('ecomtoacc.amazon.SP_API_CLIENT_SECRET')
        );
        
        if(!empty($accessToken)){
            Azsellers::where('id',$seller_details['seller_id'])->update(["az_access_token"=>$accessToken,'az_expire_in' => time() + 3600]);
            return $accessToken;    
        } 
        return false;       
    }

    public function getAmazonOrders($seller_details, $createdAfter, $maxResults = '', $fulfillmentChannels = '', $createdBefore = ''){

        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  

        if($maxResults == '')            
            $maxResults = config('ecomtoacc.amazon.orderMaxResultsPerPageSp');
        
        $orderResponse = array();
        try{
            $result = $apiInstance->getOrders(
                    explode(",",$seller_details['marketplaces']), // Marketplaces
                    $createdAfter, // Created After
                    !empty($createdBefore) ? date("Y-m-d\TH:i:s\Z", strtotime($createdBefore)) : '',                
                    '', // last_updated_after
                    '', // last_updated_before
                    '', // order_statuses
                    $fulfillmentChannels, // fulfillment_channels
                    '', // payment_methods
                    '', // buyer_email
                    '', // seller_order_id
                    $maxResults, // max_results_per_page,
                    '', // easy_ship_shipment_statuses
                    '', // next_token,
                    '' // amazon_order_ids
            );
           
            $orderResponse = $result->getPayload();

        } catch(\ClouSale\AmazonSellingPartnerAPI\ApiException $e) {
            Log::info('AZXO getAmazonOrders request error: '.$seller_details['seller_id'].'-'.$e->getMessage());
            if(!is_array($e->getMessage()) && stripos($e->getMessage(), '"code": "Unauthorized"') !== false){
                //Azsellers::where('id',$seller_details['seller_id'])->update(["mm_disconnected" => date('Y-m-d H:i:s')]);
                Azsellers::where('id',$seller_details['seller_id'])->update(["mm_disconnected" => date('Y-m-d H:i:s')]);
            }
        }
        return $orderResponse;
    }

    public function getUpdatedAmazonOrders($seller_details, $createdAfter, $maxResults = '', $fulfillmentChannels = '', $createdBefore = ''){

        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  

        if($maxResults == '')            
            $maxResults = config('ecomtoacc.amazon.orderMaxResultsPerPageSp');
        
        $orderResponse = array();
        try{
            $result = $apiInstance->getOrders(
                    explode(",",$seller_details['marketplaces']), // Marketplaces
                    '', // Created After
                    '', // Created Before                
                    $createdAfter, // last_updated_after
                    !empty($createdBefore) ? date("Y-m-d\TH:i:s\Z", strtotime($createdBefore)) : '', // last_updated_before
                    '', // order_statuses
                    $fulfillmentChannels, // fulfillment_channels
                    '', // payment_methods
                    '', // buyer_email
                    '', // seller_order_id
                    $maxResults, // max_results_per_page,
                    '', // easy_ship_shipment_statuses
                    '', // next_token,
                    '' // amazon_order_ids
            );
           
            $orderResponse = $result->getPayload();
        } catch(\ClouSale\AmazonSellingPartnerAPI\ApiException $e) {
            Log::info('AZXO getUpdatedAmazonOrders request error: '.$seller_details['seller_id'].'-'.$e->getMessage());
        }         
        return $orderResponse;
    }

    public function getAmazonOrdersByNextToken($seller_details, $nextToken){

        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  

        $result = $apiInstance->getOrders(
                explode(",",$seller_details['marketplaces']), // Marketplaces
                '', // Created After
                '', // Created Before               
                '', // last_updated_after
                '', // last_updated_before
                '', // order_statuses
                '', // fulfillment_channels
                '', // payment_methods
                '', // buyer_email
                '', // seller_order_id
                '', // max_results_per_page,
                '', // easy_ship_shipment_statuses
                $nextToken, // next_token,
                '' // amazon_order_ids
        );
       
        $orderResponse = $result->getPayload();            
        return $orderResponse;

    }

    public function getOrderAddress($seller_details, $order_id, $count = '0'){
        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  

        $addressResponse = [];
        try{
            $result = $apiInstance->getOrderAddress($order_id);
            $addressResponse = $result->getPayload()->getShippingAddress();
        } catch(\ClouSale\AmazonSellingPartnerAPI\ApiException $e) {
            Log::info('AZXO request error: '.$count.'-'.$e->getMessage());            
            $count++;
            if($count < 3){
                sleep(1);
                return $this->getOrderAddress($seller_details, $order_id, $count);
            }
        }
         
        return $addressResponse;

    }

    public function getOrdersLineItems($seller_details, $order_id){
        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  
        
        $lineItemResponse = [];
        try{
            $result = $apiInstance->getOrderItems($order_id);
            $lineItemResponse = $result->getPayload(); 
        } catch(\InvalidArgumentException $e) {
            Log::info('AZXO lineitem request error:'.$seller_details['seller_id'].' - '.$order_id.' - '.$e->getMessage());
        }

        return $lineItemResponse;
    }

    public function getOrderBuyerDetails($seller_details, $order_id){
        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  

        $result = $apiInstance->getOrderBuyerInfo($order_id);                
        $buyerResponse = $result->getPayload(); 
                
        return $buyerResponse;
    }

    public function getSingleOrder($seller_details, $order_id){
        $config = $this->getCommonConfigDetails($seller_details);        
        $apiInstance = new \ClouSale\AmazonSellingPartnerAPI\Api\OrdersApi($config);  

        $result = $apiInstance->getOrder($order_id);                
        $orderResponse = $result->getPayload(); 

        return $orderResponse;
    }
    
}